/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.validator.internal;

import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluationException;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluationResult;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluator;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormFieldEvaluationResult;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class DDMFormValuesValidatorImpl
implements DDMFormValuesValidator {
    private DDMFormEvaluator _ddmFormEvaluator;
    private JSONFactory _jsonFactory;

    @Override
    public void validate(DDMFormValues ddmFormValues) throws DDMFormValuesValidationException {
        DDMForm ddmForm = ddmFormValues.getDDMForm();
        if (ddmForm == null) {
            throw new NullPointerException("A DDM Form instance was never set");
        }
        this.evaluateDDMFormFieldValidationExpressions(ddmFormValues, ddmForm);
        this.traverseDDMFormFields(ddmForm.getDDMFormFields(), ddmFormValues.getDDMFormFieldValuesMap());
        this.traverseDDMFormFieldValues(ddmFormValues.getDDMFormFieldValues(), ddmForm.getDDMFormFieldsMap(false));
    }

    protected JSONArray createJSONArray(String fieldName, String json) throws DDMFormValuesValidationException {
        try {
            return this._jsonFactory.createJSONArray(json);
        }
        catch (JSONException jsone) {
            throw new DDMFormValuesValidationException.MustSetValidValue(fieldName);
        }
    }

    protected void evaluateDDMFormFieldValidationExpressions(DDMFormValues ddmFormValues, DDMForm ddmForm) throws DDMFormValuesValidationException {
        try {
            DDMFormEvaluationResult ddmFormEvaluationResult = this._ddmFormEvaluator.evaluate(ddmForm, ddmFormValues, ddmFormValues.getDefaultLocale());
            this.inspectDDMFormEvaluationResult(ddmFormEvaluationResult);
        }
        catch (DDMFormEvaluationException ddmfee) {
            throw new DDMFormValuesValidationException(ddmfee);
        }
    }

    protected List<DDMFormFieldValue> getDDMFormFieldValuesByFieldName(Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, String fieldName) {
        List<DDMFormFieldValue> ddmFormFieldValues = ddmFormFieldValuesMap.get(fieldName);
        if (ddmFormFieldValues == null) {
            return Collections.emptyList();
        }
        return ddmFormFieldValues;
    }

    protected void inspectDDMFormEvaluationResult(DDMFormEvaluationResult ddmFormEvaluationResult) throws DDMFormValuesValidationException {
        Map ddmFormFieldEvaluationResultsMap = ddmFormEvaluationResult.getDDMFormFieldEvaluationResultsMap();
        ArrayList<DDMFormFieldEvaluationResult> ddmFormFieldEvaluationResults = new ArrayList<DDMFormFieldEvaluationResult>();
        for (DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult : ddmFormFieldEvaluationResultsMap.values()) {
            if (ddmFormFieldEvaluationResult.isValid()) continue;
            ddmFormFieldEvaluationResults.add(ddmFormFieldEvaluationResult);
        }
        if (!ddmFormFieldEvaluationResults.isEmpty()) {
            throw new DDMFormValuesValidationException.MustSetValidValues(ddmFormFieldEvaluationResults);
        }
    }

    protected boolean isNull(Value value) {
        if (value == null) {
            return true;
        }
        for (Locale availableLocale : value.getAvailableLocales()) {
            if (!Validator.isNull((String)value.getString(availableLocale))) continue;
            return true;
        }
        return false;
    }

    @Reference(unbind="-")
    protected void setDDMFormEvaluator(DDMFormEvaluator ddmFormEvaluator) {
        this._ddmFormEvaluator = ddmFormEvaluator;
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void traverseDDMFormFields(List<DDMFormField> ddmFormFields, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap) throws DDMFormValuesValidationException {
        for (DDMFormField ddmFormField : ddmFormFields) {
            List<DDMFormFieldValue> ddmFormFieldValues = this.getDDMFormFieldValuesByFieldName(ddmFormFieldValuesMap, ddmFormField.getName());
            this.validateDDMFormFieldValues(ddmFormField, ddmFormFieldValues);
            for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
                this.traverseDDMFormFields(ddmFormField.getNestedDDMFormFields(), ddmFormFieldValue.getNestedDDMFormFieldValuesMap());
            }
        }
    }

    protected void traverseDDMFormFieldValues(List<DDMFormFieldValue> ddmFormFieldValues, Map<String, DDMFormField> ddmFormFieldsMap) throws DDMFormValuesValidationException {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            DDMFormField ddmFormField = ddmFormFieldsMap.get(ddmFormFieldValue.getName());
            if (!Validator.isNotNull((Object)ddmFormField)) continue;
            this.validateDDMFormFieldValue(ddmFormFieldsMap.get(ddmFormFieldValue.getName()), ddmFormFieldValue);
            this.traverseDDMFormFieldValues(ddmFormFieldValue.getNestedDDMFormFieldValues(), ddmFormField.getNestedDDMFormFieldsMap());
        }
    }

    protected void validateDDMFormFieldOptions(DDMFormField ddmFormField, Value value) throws DDMFormValuesValidationException {
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        if (ddmFormFieldOptions == null) {
            return;
        }
        Set optionValues = ddmFormFieldOptions.getOptionsValues();
        if (optionValues.isEmpty()) {
            return;
        }
        Map selectedValues = value.getValues();
        for (String selectedValue : selectedValues.values()) {
            JSONArray jsonArray = this.createJSONArray(ddmFormField.getName(), selectedValue);
            for (int i = 0; i < jsonArray.length(); ++i) {
                if (optionValues.contains(jsonArray.getString(i))) continue;
                throw new DDMFormValuesValidationException.MustSetValidValue(ddmFormField.getName());
            }
        }
    }

    protected void validateDDMFormFieldValue(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) throws DDMFormValuesValidationException {
        if (ddmFormField == null) {
            throw new DDMFormValuesValidationException.MustSetValidField(ddmFormFieldValue.getName());
        }
        DDMFormValues ddmFormValues = ddmFormFieldValue.getDDMFormValues();
        this.validateDDMFormFieldValue(ddmFormField, ddmFormValues.getAvailableLocales(), ddmFormValues.getDefaultLocale(), ddmFormFieldValue.getValue());
        this.traverseDDMFormFieldValues(ddmFormFieldValue.getNestedDDMFormFieldValues(), ddmFormField.getNestedDDMFormFieldsMap());
    }

    protected void validateDDMFormFieldValue(DDMFormField ddmFormField, Set<Locale> availableLocales, Locale defaultLocale, Value value) throws DDMFormValuesValidationException {
        if (Validator.isNull((String)ddmFormField.getDataType())) {
            if (value != null) {
                throw new DDMFormValuesValidationException.MustNotSetValue(ddmFormField.getName());
            }
        } else {
            if (value == null || ddmFormField.isRequired() && this.isNull(value)) {
                throw new DDMFormValuesValidationException.RequiredValue(ddmFormField.getName());
            }
            if (ddmFormField.isLocalizable() && !value.isLocalized() || !ddmFormField.isLocalizable() && value.isLocalized()) {
                throw new DDMFormValuesValidationException.MustSetValidValue(ddmFormField.getName());
            }
            this.validateDDMFormFieldValueLocales(ddmFormField, availableLocales, defaultLocale, value);
            this.validateDDMFormFieldOptions(ddmFormField, value);
        }
    }

    protected void validateDDMFormFieldValueLocales(DDMFormField ddmFormField, Set<Locale> availableLocales, Locale defaultLocale, Value value) throws DDMFormValuesValidationException {
        if (!value.isLocalized()) {
            return;
        }
        if (!availableLocales.equals(value.getAvailableLocales())) {
            throw new DDMFormValuesValidationException.MustSetValidAvailableLocales(ddmFormField.getName());
        }
        if (!defaultLocale.equals(value.getDefaultLocale())) {
            throw new DDMFormValuesValidationException.MustSetValidDefaultLocale(ddmFormField.getName());
        }
    }

    protected void validateDDMFormFieldValues(DDMFormField ddmFormField, List<DDMFormFieldValue> ddmFormFieldValues) throws DDMFormValuesValidationException {
        if (ddmFormField.isRequired() && ddmFormFieldValues.size() == 0) {
            throw new DDMFormValuesValidationException.RequiredValue(ddmFormField.getName());
        }
        if (!ddmFormField.isRepeatable() && ddmFormFieldValues.size() > 1) {
            throw new DDMFormValuesValidationException.MustSetValidValuesSize(ddmFormField.getName());
        }
    }
}

