/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.validator.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.validator.DDMFormLayoutValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormLayoutValidator;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidationException;
import com.liferay.dynamic.data.mapping.validator.internal.util.DDMFormRuleValidatorUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.HashSet;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormLayoutValidator.class})
public class DDMFormLayoutValidatorImpl
implements DDMFormLayoutValidator {
    private static final int _MAX_ROW_SIZE = 12;
    private DDMExpressionFactory _ddmExpressionFactory;

    public void validate(DDMFormLayout ddmFormLayout) throws DDMFormLayoutValidationException, DDMFormValidationException {
        DDMFormRuleValidatorUtil.validateDDMFormRules(this._ddmExpressionFactory, ddmFormLayout.getDDMFormRules());
        this._validateDDMFormLayoutDefaultLocale(ddmFormLayout);
        this._validateDDMFormFieldNames(ddmFormLayout);
        this._validateDDMFormLayoutPageTitles(ddmFormLayout);
        this._validateDDMFormLayoutRowSizes(ddmFormLayout);
    }

    @Reference(unbind="-")
    protected void setDDMExpressionFactory(DDMExpressionFactory ddmExpressionFactory) {
        this._ddmExpressionFactory = ddmExpressionFactory;
    }

    private void _validateDDMFormFieldNames(DDMFormLayout ddmFormLayout) throws DDMFormLayoutValidationException {
        HashSet<String> duplicatedDDMFormFieldNames = new HashSet<String>();
        HashSet<String> ddmFormFieldNames = new HashSet<String>();
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutPage.getDDMFormLayoutRows()) {
                for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                    for (String ddmFormFieldName : ddmFormLayoutColumn.getDDMFormFieldNames()) {
                        if (ddmFormFieldNames.add(ddmFormFieldName)) continue;
                        duplicatedDDMFormFieldNames.add(ddmFormFieldName);
                    }
                }
            }
        }
        if (SetUtil.isNotEmpty(duplicatedDDMFormFieldNames)) {
            throw new DDMFormLayoutValidationException.MustNotDuplicateFieldName(duplicatedDDMFormFieldNames);
        }
    }

    private void _validateDDMFormLayoutDefaultLocale(DDMFormLayout ddmFormLayout) throws DDMFormLayoutValidationException {
        Locale defaultLocale = ddmFormLayout.getDefaultLocale();
        if (defaultLocale == null) {
            throw new DDMFormLayoutValidationException.MustSetDefaultLocale();
        }
    }

    private void _validateDDMFormLayoutPageTitles(DDMFormLayout ddmFormLayout) throws DDMFormLayoutValidationException {
        Locale defaultLocale = ddmFormLayout.getDefaultLocale();
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            LocalizedValue title = ddmFormLayoutPage.getTitle();
            if (defaultLocale.equals(title.getDefaultLocale())) continue;
            throw new DDMFormLayoutValidationException.MustSetEqualLocaleForLayoutAndTitle();
        }
    }

    private void _validateDDMFormLayoutRowSizes(DDMFormLayout ddmFormLayout) throws DDMFormLayoutValidationException {
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutPage.getDDMFormLayoutRows()) {
                int rowSize = 0;
                for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                    int columnSize = ddmFormLayoutColumn.getSize();
                    if (columnSize <= 0 || columnSize > 12) {
                        throw new DDMFormLayoutValidationException.InvalidColumnSize();
                    }
                    rowSize += ddmFormLayoutColumn.getSize();
                }
                if (rowSize == 12) continue;
                throw new DDMFormLayoutValidationException.InvalidRowSize();
            }
        }
    }
}

