/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.validator.internal;

import com.liferay.dynamic.data.mapping.constants.DDMConstants;
import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueValidationException;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidator;
import com.liferay.dynamic.data.mapping.validator.internal.util.DDMFormRuleValidatorUtil;
import com.liferay.portal.kernel.bean.BeanProperties;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormValidator.class})
public class DDMFormValidatorImpl
implements DDMFormValidator {
    private static final String[] _DDM_FORM_FIELD_INDEX_TYPES = new String[]{"", "keyword", "none", "text"};
    private static final Log _log = LogFactoryUtil.getLog(DDMFormValidatorImpl.class);
    private static final Pattern _ddmFormFieldNamePattern = Pattern.compile("([^\\p{Punct}|\\p{Space}$]|_)+");
    private static final Pattern _ddmFormFieldTypePattern = Pattern.compile("([^\\p{Punct}|\\p{Space}$]|[-_])+");
    @Reference
    private BeanProperties _beanProperties;
    private DDMExpressionFactory _ddmExpressionFactory;
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;

    public void validate(DDMForm ddmForm) throws DDMFormFieldValueValidationException, DDMFormValidationException {
        DDMFormRuleValidatorUtil.validateDDMFormRules(this._ddmExpressionFactory, ddmForm.getDDMFormRules());
        this._validateDDMFormLocales(ddmForm);
        List ddmFormFields = ddmForm.getDDMFormFields();
        if (ddmFormFields.isEmpty()) {
            throw new DDMFormValidationException.MustSetFieldsForForm();
        }
        this._validateDDMFormFieldNames(ddmFormFields);
        this._validateDDMFormFields(ddmFormFields, new HashSet<String>(), ddmForm.allowInvalidAvailableLocalesForProperty(), ddmForm.getAvailableLocales(), ddmForm.getDefaultLocale());
    }

    @Reference(unbind="-")
    protected void setDDMExpressionFactory(DDMExpressionFactory ddmExpressionFactory) {
        this._ddmExpressionFactory = ddmExpressionFactory;
    }

    @Reference(unbind="-")
    protected void setDDMFormFieldTypeServicesTracker(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
    }

    protected void validateDDMFormFieldValidationExpression(DDMFormField ddmFormField, Set<Locale> locales) throws DDMFormValidationException {
        DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
        if (ddmFormFieldValidation == null) {
            return;
        }
        DDMFormFieldValidationExpression ddmFormFieldValidationExpression = ddmFormFieldValidation.getDDMFormFieldValidationExpression();
        if (ddmFormFieldValidationExpression == null || Validator.isNull((String)ddmFormFieldValidationExpression.getValue())) {
            return;
        }
        try {
            if (ddmFormFieldValidation.getParameterLocalizedValue() == null) {
                this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)ddmFormFieldValidationExpression.getValue()).build());
            } else {
                LocalizedValue parameterLocalizedValue = ddmFormFieldValidation.getParameterLocalizedValue();
                for (Locale locale : locales) {
                    this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)ddmFormFieldValidationExpression.getExpression(null, parameterLocalizedValue.getString(locale), null)).build());
                }
            }
        }
        catch (DDMExpressionException ddmExpressionException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ddmExpressionException);
            }
            throw new DDMFormValidationException.MustSetValidValidationExpression(ddmFormField.getName(), ddmFormFieldValidationExpression.getValue());
        }
    }

    private void _validateDDMFormAvailableLocales(Set<Locale> availableLocales, Locale defaultLocale) throws DDMFormValidationException {
        if (availableLocales == null || availableLocales.isEmpty()) {
            throw new DDMFormValidationException.MustSetAvailableLocales();
        }
        if (!availableLocales.contains(defaultLocale)) {
            throw new DDMFormValidationException.MustSetDefaultLocaleAsAvailableLocale(defaultLocale);
        }
    }

    private void _validateDDMFormFieldIndexType(DDMFormField ddmFormField) throws DDMFormValidationException {
        if (!ArrayUtil.contains((Object[])_DDM_FORM_FIELD_INDEX_TYPES, (Object)ddmFormField.getIndexType())) {
            throw new DDMFormValidationException.MustSetValidIndexType(ddmFormField.getName());
        }
    }

    private void _validateDDMFormFieldName(DDMFormField ddmFormField, Set<String> ddmFormFieldNames) throws DDMFormValidationException {
        Matcher matcher = _ddmFormFieldNamePattern.matcher(ddmFormField.getName());
        if (!matcher.matches()) {
            throw new DDMFormValidationException.MustSetValidCharactersForFieldName(ddmFormField.getName());
        }
        if (ddmFormFieldNames.contains(StringUtil.toLowerCase((String)ddmFormField.getName()))) {
            throw new DDMFormValidationException.MustNotDuplicateFieldName(ddmFormField.getName());
        }
        ddmFormFieldNames.add(StringUtil.toLowerCase((String)ddmFormField.getName()));
    }

    private void _validateDDMFormFieldNames(List<DDMFormField> ddmFormFields) throws DDMFormValidationException {
        HashSet<String> duplicatedDDMFieldNames = new HashSet<String>();
        HashSet<String> ddmFormFieldNames = new HashSet<String>();
        for (DDMFormField ddmFormField : ddmFormFields) {
            if (ddmFormFieldNames.add(ddmFormField.getName())) continue;
            duplicatedDDMFieldNames.add(ddmFormField.getName());
        }
        if (SetUtil.isNotEmpty(duplicatedDDMFieldNames)) {
            throw new DDMFormValidationException.MustNotDuplicateFieldName(duplicatedDDMFieldNames);
        }
    }

    private void _validateDDMFormFieldOptions(boolean allowInvalidAvailableLocalesForProperty, DDMFormField ddmFormField, Set<Locale> ddmFormAvailableLocales, Locale ddmFormDefaultLocale) throws DDMFormValidationException {
        try {
            this._validateDDMFormFieldOptions(ddmFormField, ddmFormAvailableLocales, ddmFormDefaultLocale);
        }
        catch (DDMFormValidationException ddmFormValidationException) {
            if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidAvailableLocalesForProperty && allowInvalidAvailableLocalesForProperty) {
                return;
            }
            throw ddmFormValidationException;
        }
    }

    private void _validateDDMFormFieldOptions(DDMFormField ddmFormField, Set<Locale> ddmFormAvailableLocales, Locale ddmFormDefaultLocale) throws DDMFormValidationException {
        String fieldType = ddmFormField.getType();
        if (fieldType.equals("grid")) {
            this._validateDDMFormFieldOptionsProperties(ddmFormField, "columns", ddmFormAvailableLocales, ddmFormDefaultLocale);
            this._validateDDMFormFieldOptionsProperties(ddmFormField, "rows", ddmFormAvailableLocales, ddmFormDefaultLocale);
        }
        if (!(fieldType.equals("checkbox_multiple") || fieldType.equals("radio") || fieldType.equals("select"))) {
            return;
        }
        if (!Validator.isBlank((String)ddmFormField.getDataSourceType()) && !Objects.equals(ddmFormField.getDataSourceType(), "manual")) {
            return;
        }
        this._validateDDMFormFieldOptionsProperties(ddmFormField, "options", ddmFormAvailableLocales, ddmFormDefaultLocale);
    }

    private void _validateDDMFormFieldOptionsProperties(DDMFormField ddmFormField, String propertyName, Set<Locale> ddmFormAvailableLocales, Locale ddmFormDefaultLocale) throws DDMFormValidationException {
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        if (!propertyName.equals("options")) {
            ddmFormFieldOptions = (DDMFormFieldOptions)ddmFormField.getProperty(propertyName);
        }
        Set optionsValues = Collections.emptySet();
        if (ddmFormFieldOptions != null) {
            optionsValues = ddmFormFieldOptions.getOptionsValues();
        }
        if (optionsValues.isEmpty()) {
            LocalizedValue localizedValue = ddmFormField.getLabel();
            throw new DDMFormValidationException.MustSetOptionsForField(localizedValue.getString(ddmFormDefaultLocale), ddmFormField.getName());
        }
        for (String optionValue : ddmFormFieldOptions.getOptionsValues()) {
            LocalizedValue localizedValue = ddmFormFieldOptions.getOptionLabels(optionValue);
            this._validateDDMFormFieldPropertyValue(ddmFormField.getName(), propertyName, localizedValue, ddmFormAvailableLocales, ddmFormDefaultLocale);
        }
    }

    private void _validateDDMFormFieldPropertyValue(String fieldName, String propertyName, LocalizedValue propertyValue, Set<Locale> ddmFormAvailableLocales, Locale ddmFormDefaultLocale) throws DDMFormValidationException {
        if (!ddmFormDefaultLocale.equals(propertyValue.getDefaultLocale())) {
            throw new DDMFormValidationException.MustSetValidDefaultLocaleForProperty(fieldName, propertyName);
        }
        if (!ddmFormAvailableLocales.equals(propertyValue.getAvailableLocales())) {
            throw new DDMFormValidationException.MustSetValidAvailableLocalesForProperty(fieldName, propertyName);
        }
    }

    private void _validateDDMFormFields(List<DDMFormField> ddmFormFields, Set<String> ddmFormFieldNames, boolean allowInvalidAvailableLocalesForProperty, Set<Locale> ddmFormAvailableLocales, Locale ddmFormDefaultLocale) throws DDMFormValidationException {
        for (DDMFormField ddmFormField : ddmFormFields) {
            this._validateDDMFormFieldName(ddmFormField, ddmFormFieldNames);
            this._validateDDMFormFieldType(ddmFormField);
            this._validateDDMFormFieldIndexType(ddmFormField);
            this._validateDDMFormFieldOptions(allowInvalidAvailableLocalesForProperty, ddmFormField, ddmFormAvailableLocales, ddmFormDefaultLocale);
            this._validateOptionalDDMFormFieldLocalizedProperty(ddmFormField, "label", allowInvalidAvailableLocalesForProperty, ddmFormAvailableLocales, ddmFormDefaultLocale);
            this._validateOptionalDDMFormFieldLocalizedProperty(ddmFormField, "tip", allowInvalidAvailableLocalesForProperty, ddmFormAvailableLocales, ddmFormDefaultLocale);
            this.validateDDMFormFieldValidationExpression(ddmFormField, ddmFormAvailableLocales);
            this._validateDDMFormFieldVisibilityExpression(ddmFormField);
            this._validateDDMFormFields(ddmFormField.getNestedDDMFormFields(), ddmFormFieldNames, allowInvalidAvailableLocalesForProperty, ddmFormAvailableLocales, ddmFormDefaultLocale);
        }
    }

    private void _validateDDMFormFieldType(DDMFormField ddmFormField) throws DDMFormValidationException {
        if (Validator.isNull((String)ddmFormField.getType())) {
            throw new DDMFormValidationException.MustSetFieldType(ddmFormField.getName());
        }
        Matcher matcher = _ddmFormFieldTypePattern.matcher(ddmFormField.getType());
        if (!matcher.matches()) {
            throw new DDMFormValidationException.MustSetValidCharactersForFieldType(ddmFormField.getType());
        }
        HashSet ddmFormFieldTypeNames = new HashSet(this._ddmFormFieldTypeServicesTracker.getDDMFormFieldTypeNames());
        ddmFormFieldTypeNames.addAll(SetUtil.fromArray((Object[])DDMConstants.SUPPORTED_DDM_FORM_FIELD_TYPES));
        if (!ddmFormFieldTypeNames.contains(ddmFormField.getType())) {
            throw new DDMFormValidationException.MustSetValidType(ddmFormField.getType());
        }
    }

    private void _validateDDMFormFieldVisibilityExpression(DDMFormField ddmFormField) throws DDMFormValidationException {
        String visibilityExpression = ddmFormField.getVisibilityExpression();
        if (Validator.isNull((String)visibilityExpression)) {
            return;
        }
        try {
            this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)visibilityExpression).build());
        }
        catch (DDMExpressionException ddmExpressionException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ddmExpressionException);
            }
            throw new DDMFormValidationException.MustSetValidVisibilityExpression(ddmFormField.getName(), visibilityExpression);
        }
    }

    private void _validateDDMFormLocales(DDMForm ddmForm) throws DDMFormValidationException {
        Locale defaultLocale = ddmForm.getDefaultLocale();
        if (defaultLocale == null) {
            throw new DDMFormValidationException.MustSetDefaultLocale();
        }
        this._validateDDMFormAvailableLocales(ddmForm.getAvailableLocales(), defaultLocale);
    }

    private void _validateOptionalDDMFormFieldLocalizedProperty(DDMFormField ddmFormField, String propertyName, boolean allowInvalidAvailableLocalesForProperty, Set<Locale> ddmFormAvailableLocales, Locale ddmFormDefaultLocale) throws DDMFormValidationException {
        LocalizedValue propertyValue = (LocalizedValue)this._beanProperties.getObject((Object)ddmFormField, propertyName);
        if (propertyValue == null || MapUtil.isEmpty((Map)propertyValue.getValues())) {
            return;
        }
        try {
            this._validateDDMFormFieldPropertyValue(ddmFormField.getName(), propertyName, propertyValue, ddmFormAvailableLocales, ddmFormDefaultLocale);
        }
        catch (DDMFormValidationException ddmFormValidationException) {
            if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidAvailableLocalesForProperty && allowInvalidAvailableLocalesForProperty) {
                return;
            }
            throw ddmFormValidationException;
        }
    }
}

