/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.background.task;

import com.liferay.exportimport.background.task.BaseStagingBackgroundTaskExecutor;
import com.liferay.exportimport.background.task.PortletStagingBackgroundTaskStatusMessageTranslator;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManagerUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportLocalServiceUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.Callable;

public class PortletStagingBackgroundTaskExecutor
extends BaseStagingBackgroundTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(PortletStagingBackgroundTaskExecutor.class);

    public PortletStagingBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new PortletStagingBackgroundTaskStatusMessageTranslator());
    }

    public BackgroundTaskExecutor clone() {
        PortletStagingBackgroundTaskExecutor portletStagingBackgroundTaskExecutor = new PortletStagingBackgroundTaskExecutor();
        portletStagingBackgroundTaskExecutor.setBackgroundTaskStatusMessageTranslator(this.getBackgroundTaskStatusMessageTranslator());
        portletStagingBackgroundTaskExecutor.setIsolationLevel(this.getIsolationLevel());
        return portletStagingBackgroundTaskExecutor;
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(backgroundTask);
        File file = null;
        MissingReferences missingReferences = null;
        try {
            ExportImportThreadLocal.setPortletStagingInProcess((boolean)true);
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)21, (int)36, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
            file = ExportImportLocalServiceUtil.exportPortletInfoAsFile((ExportImportConfiguration)exportImportConfiguration);
            this.markBackgroundTask(backgroundTask.getBackgroundTaskId(), "exported");
            missingReferences = (MissingReferences)TransactionInvokerUtil.invoke((TransactionConfig)transactionConfig, (Callable)new PortletStagingCallable(backgroundTask.getBackgroundTaskId(), exportImportConfiguration, file));
            ExportImportThreadLocal.setPortletStagingInProcess((boolean)false);
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)20, (int)36, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
        }
        catch (Throwable t) {
            ExportImportThreadLocal.setPortletStagingInProcess((boolean)false);
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)19, (int)36, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)t, t);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to publish portlet: " + t.getMessage()));
            }
            this.deleteTempLarOnFailure(file);
            throw new SystemException(t);
        }
        this.deleteTempLarOnSuccess(file);
        return this.processMissingReferences(backgroundTask.getBackgroundTaskId(), missingReferences);
    }

    private class PortletStagingCallable
    implements Callable<MissingReferences> {
        private final long _backgroundTaskId;
        private final ExportImportConfiguration _exportImportConfiguration;
        private final File _file;

        public PortletStagingCallable(long backgroundTaskId, ExportImportConfiguration exportImportConfiguration, File file) {
            this._backgroundTaskId = backgroundTaskId;
            this._exportImportConfiguration = exportImportConfiguration;
            this._file = file;
        }

        @Override
        public MissingReferences call() throws PortalException {
            ExportImportLocalServiceUtil.importPortletDataDeletions((ExportImportConfiguration)this._exportImportConfiguration, (File)this._file);
            MissingReferences missingReferences = ExportImportLocalServiceUtil.validateImportPortletInfo((ExportImportConfiguration)this._exportImportConfiguration, (File)this._file);
            PortletStagingBackgroundTaskExecutor.this.markBackgroundTask(this._backgroundTaskId, "validated");
            ExportImportLocalServiceUtil.importPortletInfo((ExportImportConfiguration)this._exportImportConfiguration, (File)this._file);
            return missingReferences;
        }
    }
}

