/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.controller;

import com.liferay.asset.kernel.model.adapter.StagedAssetLink;
import com.liferay.exportimport.controller.PortletExportController;
import com.liferay.exportimport.kernel.controller.ExportController;
import com.liferay.exportimport.kernel.controller.ExportImportController;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportProcessCallbackRegistry;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactory;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerStatusMessageSender;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManager;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.lar.DeletionSystemEventExporter;
import com.liferay.exportimport.lar.PermissionExporter;
import com.liferay.exportimport.lar.ThemeExporter;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutStagingHandler;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.settings.PortletInstanceSettingsLocator;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.model.impl.LayoutImpl;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.kernel.model.Layout"}, service={ExportImportController.class, LayoutExportController.class})
public class LayoutExportController
implements ExportController {
    private static final Log _log = LogFactoryUtil.getLog(LayoutExportController.class);
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    private final DeletionSystemEventExporter _deletionSystemEventExporter = DeletionSystemEventExporter.getInstance();
    @Reference
    private ExportImportHelper _exportImportHelper;
    private ExportImportLifecycleManager _exportImportLifecycleManager;
    @Reference
    private ExportImportProcessCallbackRegistry _exportImportProcessCallbackRegistry;
    private GroupLocalService _groupLocalService;
    private ImageLocalService _imageLocalService;
    private LayoutLocalService _layoutLocalService;
    private LayoutPrototypeLocalService _layoutPrototypeLocalService;
    private LayoutRevisionLocalService _layoutRevisionLocalService;
    private LayoutSetBranchLocalService _layoutSetBranchLocalService;
    private LayoutSetLocalService _layoutSetLocalService;
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;
    private final PermissionExporter _permissionExporter = PermissionExporter.getInstance();
    @Reference
    private PortletDataContextFactory _portletDataContextFactory;
    @Reference
    private PortletDataHandlerStatusMessageSender _portletDataHandlerStatusMessageSender;
    private PortletExportController _portletExportController;
    private final ThemeExporter _themeExporter = ThemeExporter.getInstance();
    private UserLocalService _userLocalService;

    public File export(ExportImportConfiguration exportImportConfiguration) throws Exception {
        PortletDataContext portletDataContext = null;
        try {
            ExportImportThreadLocal.setLayoutExportInProcess((boolean)true);
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            long[] layoutIds = GetterUtil.getLongValues(settingsMap.get("layoutIds"));
            portletDataContext = this.getPortletDataContext(exportImportConfiguration);
            if (ArrayUtil.contains((long[])layoutIds, (long)0L)) {
                layoutIds = this._exportImportHelper.getAllLayoutIds(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
            }
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(3, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
            File file = this.doExport(portletDataContext, layoutIds);
            ExportImportThreadLocal.setLayoutExportInProcess((boolean)false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(2, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
            return file;
        }
        catch (Throwable t) {
            ExportImportThreadLocal.setLayoutExportInProcess((boolean)false);
            if (portletDataContext != null) {
                ZipWriter zipWriter = portletDataContext.getZipWriter();
                zipWriter.umount();
            }
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(1, this.getProcessFlag(), String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext), t});
            throw t;
        }
    }

    protected File doExport(PortletDataContext portletDataContext, long[] layoutIds) throws Exception {
        Map parameterMap = portletDataContext.getParameterMap();
        boolean ignoreLastPublishDate = MapUtil.getBoolean((Map)parameterMap, (String)"IGNORE_LAST_PUBLISH_DATE");
        boolean layoutSetPrototypeSettings = MapUtil.getBoolean((Map)parameterMap, (String)"LAYOUT_SET_PROTOTYPE_SETTINGS");
        boolean layoutSetSettings = MapUtil.getBoolean((Map)parameterMap, (String)"LAYOUT_SET_SETTINGS");
        boolean logo = MapUtil.getBoolean((Map)parameterMap, (String)"LOGO");
        boolean permissions = MapUtil.getBoolean((Map)parameterMap, (String)"PERMISSIONS");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export permissions " + permissions));
        }
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        long companyId = layoutSet.getCompanyId();
        long defaultUserId = this._userLocalService.getDefaultUserId(companyId);
        ServiceContext serviceContext = ServiceContextThreadLocal.popServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
        }
        serviceContext.setCompanyId(companyId);
        serviceContext.setSignedIn(true);
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            BackgroundTask backgroundTask = this._backgroundTaskLocalService.getBackgroundTask(BackgroundTaskThreadLocal.getBackgroundTaskId());
            serviceContext.setUserId(backgroundTask.getUserId());
        } else {
            serviceContext.setUserId(defaultUserId);
        }
        serviceContext.setAttribute("exporting", (Serializable)Boolean.TRUE);
        long layoutSetBranchId = MapUtil.getLong((Map)parameterMap, (String)"layoutSetBranchId");
        serviceContext.setAttribute("layoutSetBranchId", (Serializable)Long.valueOf(layoutSetBranchId));
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        if (ignoreLastPublishDate) {
            portletDataContext.setEndDate(null);
            portletDataContext.setStartDate(null);
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        portletDataContext.setExportDataRootElement(rootElement);
        Element headerElement = rootElement.addElement("header");
        headerElement.addAttribute("available-locales", StringUtil.merge((Collection)LanguageUtil.getAvailableLocales((long)portletDataContext.getScopeGroupId())));
        headerElement.addAttribute("build-number", String.valueOf(ReleaseInfo.getBuildNumber()));
        Bundle bundle = FrameworkUtil.getBundle(LayoutExportController.class);
        Version version = bundle.getVersion();
        headerElement.addAttribute("bundle-version", String.valueOf(version));
        headerElement.addAttribute("export-date", Time.getRFC822());
        if (portletDataContext.hasDateRange()) {
            headerElement.addAttribute("start-date", String.valueOf(portletDataContext.getStartDate()));
            headerElement.addAttribute("end-date", String.valueOf(portletDataContext.getEndDate()));
        }
        headerElement.addAttribute("company-id", String.valueOf(portletDataContext.getCompanyId()));
        headerElement.addAttribute("company-group-id", String.valueOf(portletDataContext.getCompanyGroupId()));
        headerElement.addAttribute("group-id", String.valueOf(portletDataContext.getGroupId()));
        headerElement.addAttribute("user-personal-site-group-id", String.valueOf(portletDataContext.getUserPersonalSiteGroupId()));
        headerElement.addAttribute("private-layout", String.valueOf(portletDataContext.isPrivateLayout()));
        Group group = layoutSet.getGroup();
        String type = "layout-set";
        if (group.isLayoutPrototype()) {
            type = "layout-prototype";
            LayoutPrototype layoutPrototype = this._layoutPrototypeLocalService.getLayoutPrototype(group.getClassPK());
            headerElement.addAttribute("type-uuid", layoutPrototype.getUuid());
            layoutIds = this._exportImportHelper.getAllLayoutIds(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        } else if (group.isLayoutSetPrototype()) {
            type = "layout-set-prototype";
            LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototype(group.getClassPK());
            headerElement.addAttribute("type-uuid", layoutSetPrototype.getUuid());
        }
        headerElement.addAttribute("type", type);
        LayoutSetBranch layoutSetBranch = this._layoutSetBranchLocalService.fetchLayoutSetBranch(layoutSetBranchId);
        if (logo) {
            Image image = null;
            image = layoutSetBranch != null ? this._imageLocalService.getImage(layoutSetBranch.getLogoId()) : this._imageLocalService.getImage(layoutSet.getLogoId());
            if (image != null && image.getTextObj() != null) {
                String logoPath = ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext);
                logoPath = logoPath + "/logo";
                headerElement.addAttribute("logo-path", logoPath);
                portletDataContext.addZipEntry(logoPath, image.getTextObj());
            }
        }
        String layoutSetPrototypeUuid = layoutSet.getLayoutSetPrototypeUuid();
        if (layoutSetPrototypeSettings && Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(layoutSetPrototypeUuid, companyId);
            headerElement.addAttribute("layout-set-prototype-uuid", layoutSetPrototypeUuid);
            headerElement.addAttribute("layout-set-prototype-name", layoutSetPrototype.getName(LocaleUtil.getDefault()));
        }
        Element missingReferencesElement = rootElement.addElement("missing-references");
        portletDataContext.setMissingReferencesElement(missingReferencesElement);
        if (layoutSetBranch != null) {
            this._themeExporter.exportTheme(portletDataContext, layoutSetBranch);
        } else {
            this._themeExporter.exportTheme(portletDataContext, layoutSet);
        }
        if (layoutSetSettings) {
            Element settingsElement = headerElement.addElement("settings");
            if (layoutSetBranch != null) {
                settingsElement.addCDATA(layoutSetBranch.getSettings());
            } else {
                settingsElement.addCDATA(layoutSet.getSettings());
            }
        }
        LinkedHashMap<String, Object[]> portletIds = new LinkedHashMap<String, Object[]>();
        List layouts = this._layoutLocalService.getLayouts(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        for (Portlet portlet : this._exportImportHelper.getDataSiteLevelPortlets(companyId)) {
            String portletId = portlet.getRootPortletId();
            if (ExportImportThreadLocal.isStagingInProcess() && !group.isStagedPortlet(portletId)) continue;
            if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
                PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
                portletDataHandler.prepareManifestSummary(portletDataContext);
            }
            portletIds.put(PortletPermissionUtil.getPrimaryKey((long)0L, (String)portletId), new Object[]{portletId, 0L, portletDataContext.getGroupId(), "", ""});
            if (!portlet.isScopeable()) continue;
            for (Layout layout : layouts) {
                LayoutTypePortlet layoutTypePortlet;
                if (!ArrayUtil.contains((long[])layoutIds, (long)layout.getLayoutId()) || !layout.isTypePortlet() || !layout.hasScopeGroup() || !(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).hasPortletId(portletId)) continue;
                Group scopeGroup = layout.getScopeGroup();
                portletIds.put(PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portlet.getPortletId()), new Object[]{portlet.getPortletId(), layout.getPlid(), scopeGroup.getGroupId(), "", layout.getUuid()});
            }
        }
        for (Layout layout : layouts) {
            this.getLayoutPortlets(portletDataContext, layoutIds, portletIds, layout);
        }
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
            this._portletDataHandlerStatusMessageSender.sendStatusMessage("layout", ArrayUtil.toStringArray(portletIds.keySet()), manifestSummary);
            manifestSummary.resetCounters();
        }
        portletDataContext.addDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(Layout.class)});
        portletDataContext.getExportDataGroupElement(Layout.class);
        for (Layout layout : layouts) {
            this.exportLayout(portletDataContext, layoutIds, layout);
        }
        Element portletsElement = rootElement.addElement("portlets");
        Element servicesElement = rootElement.addElement("services");
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        for (Map.Entry portletIdsEntry : portletIds.entrySet()) {
            Object[] portletObjects = (Object[])portletIdsEntry.getValue();
            String portletId = null;
            long plid = 0L;
            long scopeGroupId = 0L;
            String scopeType = "";
            String scopeLayoutUuid = null;
            if (portletObjects.length == 4) {
                portletId = (String)((Object[])portletIdsEntry.getValue())[0];
                plid = (Long)((Object[])portletIdsEntry.getValue())[1];
                scopeGroupId = (Long)((Object[])portletIdsEntry.getValue())[2];
                scopeLayoutUuid = (String)((Object[])portletIdsEntry.getValue())[3];
            } else {
                portletId = (String)((Object[])portletIdsEntry.getValue())[0];
                plid = (Long)((Object[])portletIdsEntry.getValue())[1];
                scopeGroupId = (Long)((Object[])portletIdsEntry.getValue())[2];
                scopeType = (String)((Object[])portletIdsEntry.getValue())[3];
                scopeLayoutUuid = (String)((Object[])portletIdsEntry.getValue())[4];
            }
            Layout layout = this._layoutLocalService.fetchLayout(plid);
            if (layout == null) {
                layout = new LayoutImpl();
                layout.setGroupId(portletDataContext.getGroupId());
                layout.setCompanyId(companyId);
            }
            portletDataContext.setPlid(plid);
            portletDataContext.setOldPlid(plid);
            portletDataContext.setPortletId(portletId);
            portletDataContext.setScopeGroupId(scopeGroupId);
            portletDataContext.setScopeType(scopeType);
            portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            Map exportPortletControlsMap = this._exportImportHelper.getExportPortletControlsMap(companyId, portletId, parameterMap, type);
            try {
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(9, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
                this._portletExportController.exportPortlet(portletDataContext, layout, portletsElement, permissions, (Boolean)exportPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), (Boolean)exportPortletControlsMap.get("PORTLET_DATA"), (Boolean)exportPortletControlsMap.get("PORTLET_SETUP"), (Boolean)exportPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
                this._portletExportController.exportService(portletDataContext, servicesElement, (Boolean)exportPortletControlsMap.get("PORTLET_SETUP"));
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(8, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
            }
            catch (Throwable t) {
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(7, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext), t});
                throw t;
            }
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
        this._portletExportController.exportAssetLinks(portletDataContext);
        this._portletExportController.exportExpandoTables(portletDataContext);
        this._portletExportController.exportLocks(portletDataContext);
        portletDataContext.addDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(StagedAssetLink.class)});
        this._deletionSystemEventExporter.exportDeletionSystemEvents(portletDataContext);
        if (permissions) {
            this._permissionExporter.exportPortletDataPermissions(portletDataContext);
        }
        this._exportImportHelper.writeManifestSummary(document, portletDataContext.getManifestSummary());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Exporting layouts takes " + stopWatch.getTime() + " ms"));
        }
        boolean updateLastPublishDate = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"UPDATE_LAST_PUBLISH_DATE");
        if (ExportImportThreadLocal.isStagingInProcess() && updateLastPublishDate) {
            this._exportImportProcessCallbackRegistry.registerCallback(portletDataContext.getExportImportProcessId(), (Callable)new UpdateLayoutSetLastPublishDateCallable(portletDataContext.getDateRange(), portletDataContext.getGroupId(), portletDataContext.isPrivateLayout()));
        }
        portletDataContext.addZipEntry("/manifest.xml", document.formattedString());
        ZipWriter zipWriter = portletDataContext.getZipWriter();
        return zipWriter.getFile();
    }

    protected void exportLayout(PortletDataContext portletDataContext, long[] layoutIds, Layout layout) throws Exception {
        if (!ArrayUtil.contains((long[])layoutIds, (long)layout.getLayoutId())) {
            Element layoutElement = portletDataContext.getExportDataElement((ClassedModel)layout);
            layoutElement.addAttribute("action", "skip");
            return;
        }
        if (!this.prepareLayoutStagingHandler(portletDataContext, layout)) {
            return;
        }
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)layout);
    }

    protected void getLayoutPortlets(PortletDataContext portletDataContext, long[] layoutIds, Map<String, Object[]> portletIds, Layout layout) throws Exception {
        if (!ArrayUtil.contains((long[])layoutIds, (long)layout.getLayoutId())) {
            return;
        }
        if (!this.prepareLayoutStagingHandler(portletDataContext, layout) || !layout.isSupportsEmbeddedPortlets()) {
            return;
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        for (Portlet portlet : layoutTypePortlet.getAllPortlets(false)) {
            String portletId = portlet.getPortletId();
            Settings portletInstanceSettings = SettingsFactoryUtil.getSettings((SettingsLocator)new PortletInstanceSettingsLocator(layout, portletId));
            String scopeType = portletInstanceSettings.getValue("lfrScopeType", null);
            String scopeLayoutUuid = portletInstanceSettings.getValue("lfrScopeLayoutUuid", null);
            long scopeGroupId = portletDataContext.getScopeGroupId();
            if (Validator.isNotNull((String)scopeType)) {
                Group scopeGroup = null;
                if (scopeType.equals("company")) {
                    scopeGroup = this._groupLocalService.getCompanyGroup(layout.getCompanyId());
                } else if (scopeType.equals("layout")) {
                    Layout scopeLayout = null;
                    scopeLayout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(scopeLayoutUuid, portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
                    if (scopeLayout == null) continue;
                    scopeGroup = scopeLayout.getScopeGroup();
                } else {
                    throw new IllegalArgumentException("Scope type " + scopeType + " is invalid");
                }
                if (scopeGroup != null) {
                    scopeGroupId = scopeGroup.getGroupId();
                }
            }
            String key = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            portletIds.put(key, new Object[]{portletId, layout.getPlid(), scopeGroupId, scopeType, scopeLayoutUuid});
        }
    }

    protected PortletDataContext getPortletDataContext(ExportImportConfiguration exportImportConfiguration) throws Exception {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
        boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        DateRange dateRange = ExportImportDateUtil.getDateRange((ExportImportConfiguration)exportImportConfiguration);
        Group group = this._groupLocalService.getGroup(sourceGroupId);
        ZipWriter zipWriter = this._exportImportHelper.getLayoutSetZipWriter(sourceGroupId);
        PortletDataContext portletDataContext = this._portletDataContextFactory.createExportPortletDataContext(group.getCompanyId(), sourceGroupId, parameterMap, dateRange.getStartDate(), dateRange.getEndDate(), zipWriter);
        portletDataContext.setExportImportProcessId(String.valueOf(exportImportConfiguration.getExportImportConfigurationId()));
        portletDataContext.setPrivateLayout(privateLayout);
        return portletDataContext;
    }

    protected int getProcessFlag() {
        if (ExportImportThreadLocal.isLayoutStagingInProcess()) {
            return 32;
        }
        return 30;
    }

    protected boolean prepareLayoutStagingHandler(PortletDataContext portletDataContext, Layout layout) {
        boolean exportLAR = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"exportLAR");
        if (exportLAR || !LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            return true;
        }
        long layoutSetBranchId = MapUtil.getLong((Map)portletDataContext.getParameterMap(), (String)"layoutSetBranchId");
        if (layoutSetBranchId <= 0L) {
            return false;
        }
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
        if (layoutRevision != null) {
            layoutRevision = this._layoutRevisionLocalService.fetchLayoutRevision(layoutSetBranchId, layoutRevision.getLayoutBranchId(), true, layout.getPlid());
        } else {
            List layoutRevisions = this._layoutRevisionLocalService.getLayoutRevisions(layoutSetBranchId, layout.getPlid(), true);
            if (!layoutRevisions.isEmpty()) {
                layoutRevision = (LayoutRevision)layoutRevisions.get(0);
            }
        }
        if (layoutRevision == null) {
            return false;
        }
        LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler((Layout)layout);
        layoutStagingHandler.setLayoutRevision(layoutRevision);
        return true;
    }

    @Reference(unbind="-")
    protected void setBackgroundTaskLocalService(BackgroundTaskLocalService backgroundTaskLocalService) {
        this._backgroundTaskLocalService = backgroundTaskLocalService;
    }

    @Reference(unbind="-")
    protected void setExportImportLifecycleManager(ExportImportLifecycleManager exportImportLifecycleManager) {
        this._exportImportLifecycleManager = exportImportLifecycleManager;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setImageLocalService(ImageLocalService imageLocalService) {
        this._imageLocalService = imageLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutPrototypeLocalService(LayoutPrototypeLocalService layoutPrototypeLocalService) {
        this._layoutPrototypeLocalService = layoutPrototypeLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutRevisionLocalService(LayoutRevisionLocalService layoutRevisionLocalService) {
        this._layoutRevisionLocalService = layoutRevisionLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetBranchLocalService(LayoutSetBranchLocalService layoutSetBranchLocalService) {
        this._layoutSetBranchLocalService = layoutSetBranchLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetLocalService(LayoutSetLocalService layoutSetLocalService) {
        this._layoutSetLocalService = layoutSetLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetPrototypeLocalService(LayoutSetPrototypeLocalService layoutSetPrototypeLocalService) {
        this._layoutSetPrototypeLocalService = layoutSetPrototypeLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletExportController(PortletExportController portletExportController) {
        this._portletExportController = portletExportController;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    private class UpdateLayoutSetLastPublishDateCallable
    implements Callable<Void> {
        private final DateRange _dateRange;
        private final long _groupId;
        private final boolean _privateLayout;

        public UpdateLayoutSetLastPublishDateCallable(DateRange dateRange, long groupId, boolean privateLayout) {
            this._dateRange = dateRange;
            this._groupId = groupId;
            this._privateLayout = privateLayout;
        }

        @Override
        public Void call() throws PortalException {
            Group group = LayoutExportController.this._groupLocalService.getGroup(this._groupId);
            Date endDate = null;
            if (this._dateRange != null) {
                endDate = this._dateRange.getEndDate();
            }
            if (group.hasStagingGroup()) {
                Group stagingGroup = group.getStagingGroup();
                ExportImportDateUtil.updateLastPublishDate((long)stagingGroup.getGroupId(), (boolean)this._privateLayout, (DateRange)this._dateRange, (Date)endDate);
            } else {
                ExportImportDateUtil.updateLastPublishDate((long)this._groupId, (boolean)this._privateLayout, (DateRange)this._dateRange, (Date)endDate);
            }
            return null;
        }
    }
}

