/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.model.listener;

import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class BackgroundTaskModelListener
extends BaseModelListener<BackgroundTask> {
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;

    public void onBeforeRemove(BackgroundTask backgroundTask) throws ModelListenerException {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        long exportImportConfigurationId = MapUtil.getLong((Map)taskContextMap, (String)"exportImportConfigurationId");
        if (exportImportConfigurationId == 0L) {
            return;
        }
        try {
            ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(exportImportConfigurationId);
            if (exportImportConfiguration == null) {
                return;
            }
            if (exportImportConfiguration.getStatus() == 2) {
                this._exportImportConfigurationLocalService.deleteExportImportConfiguration(exportImportConfiguration);
            }
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    @Reference(unbind="-")
    protected void setExportImportConfigurationLocalService(ExportImportConfigurationLocalService exportImportConfigurationLocalService) {
        this._exportImportConfigurationLocalService = exportImportConfigurationLocalService;
    }
}

