/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.lar;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Element;
import java.util.Map;

public class ThemeImporter {
    private static final Log _log = LogFactoryUtil.getLog(ThemeImporter.class);
    private static final ThemeImporter _instance = new ThemeImporter();

    public static ThemeImporter getInstance() {
        return _instance;
    }

    public void importTheme(PortletDataContext portletDataContext, LayoutSet layoutSet) throws Exception {
        Attribute colorSchemeIdAttribute;
        boolean importThemeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"THEME_REFERENCE");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Import theme settings " + importThemeSettings));
        }
        if (!importThemeSettings) {
            return;
        }
        Element importDataRootElement = portletDataContext.getImportDataRootElement();
        Element headerElement = importDataRootElement.element("header");
        String themeId = layoutSet.getThemeId();
        String colorSchemeId = layoutSet.getColorSchemeId();
        Attribute themeIdAttribute = headerElement.attribute("theme-id");
        if (themeIdAttribute != null) {
            themeId = themeIdAttribute.getValue();
        }
        if ((colorSchemeIdAttribute = headerElement.attribute("color-scheme-id")) != null) {
            colorSchemeId = colorSchemeIdAttribute.getValue();
        }
        String css = GetterUtil.getString((String)headerElement.elementText("css"));
        LayoutSetLocalServiceUtil.updateLookAndFeel((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (String)themeId, (String)colorSchemeId, (String)css);
    }

    private ThemeImporter() {
    }
}

