/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.messaging;

import aQute.bnd.annotation.ProviderType;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.exportimport.messaging.BasePublisherMessageListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageStatus;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"destination.name=liferay/layouts_local_publisher", "message.status.destination.name=liferay/message_bus/message_status"}, service={LayoutsLocalPublisherMessageListener.class})
@ProviderType
public class LayoutsLocalPublisherMessageListener
extends BasePublisherMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(LayoutsLocalPublisherMessageListener.class);
    @Reference(target="(destination.name=liferay/message_bus/message_status)")
    private Destination _destination;
    @Reference
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private Staging _staging;

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.initialize(componentContext);
    }

    @Deactivate
    protected void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReceive(Message message, MessageStatus messageStatus) throws PortalException {
        long exportImportConfigurationId = GetterUtil.getLong((Object)message.getPayload());
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(exportImportConfigurationId);
        if (exportImportConfiguration == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to find export import configuration with ID " + exportImportConfigurationId));
            }
            return;
        }
        messageStatus.setPayload((Object)exportImportConfiguration);
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long userId = MapUtil.getLong((Map)settingsMap, (String)"userId");
        long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
        long[] layoutIds = GetterUtil.getLongValues(settingsMap.get("layoutIds"));
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        this.initThreadLocals(userId, parameterMap);
        try {
            this._staging.publishLayouts(userId, sourceGroupId, targetGroupId, privateLayout, layoutIds, exportImportConfiguration.getName(), parameterMap);
        }
        finally {
            this.resetThreadLocals();
        }
    }

    protected Destination getDestination() {
        return this._destination;
    }

    @Reference(target="(destination.name=liferay/layouts_local_publisher)", unbind="-")
    protected void setDestination(Destination destination) {
    }

    @Deprecated
    protected void setExportImportConfigurationLocalService(ExportImportConfigurationLocalService exportImportConfigurationLocalService) {
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.exportimport.service)(release.schema.version=1.0.0))", unbind="-")
    protected void setRelease(Release release) {
    }
}

