/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.search;

import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class ExportImportConfigurationIndexer
extends BaseIndexer<ExportImportConfiguration> {
    public static final String CLASS_NAME = ExportImportConfiguration.class.getName();
    private static final String _PREFIX_PARAMETER = "parameter_";
    private static final String _PREFIX_SETTING = "setting_";
    private static final Log _log = LogFactoryUtil.getLog(ExportImportConfigurationIndexer.class);
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this.addStatus(contextBooleanFilter, searchContext);
        contextBooleanFilter.addRequiredTerm("companyId", searchContext.getCompanyId());
        contextBooleanFilter.addRequiredTerm("groupId", GetterUtil.getLong((Object)searchContext.getAttribute("groupId")));
        Serializable type = searchContext.getAttribute("type");
        if (type != null) {
            contextBooleanFilter.addRequiredTerm("type", GetterUtil.getInteger((Object)type));
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, "description", false);
        this.addSearchTerm(searchQuery, searchContext, "exportImportConfigurationId", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
    }

    protected void doDelete(ExportImportConfiguration exportImportConfiguration) throws Exception {
        this.deleteDocument(exportImportConfiguration.getCompanyId(), exportImportConfiguration.getExportImportConfigurationId());
    }

    protected Document doGetDocument(ExportImportConfiguration exportImportConfiguration) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)exportImportConfiguration);
        document.addText("description", exportImportConfiguration.getDescription());
        document.addText("name", exportImportConfiguration.getName());
        document.addKeyword("type", exportImportConfiguration.getType());
        document.addNumber("exportImportConfigurationId", exportImportConfiguration.getExportImportConfigurationId());
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        this.populateDates(document, settingsMap);
        this.populateLayoutIds(document, settingsMap);
        this.populateLocale(document, settingsMap);
        this.populateParameterMap(document, settingsMap);
        this.populateSiteInformation(document, settingsMap);
        this.populateTimeZone(document, settingsMap);
        document.addKeyword("setting_userId", MapUtil.getLong((Map)settingsMap, (String)"userId"));
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        Summary summary = this.createSummary(document, "title", "description");
        return summary;
    }

    protected void doReindex(ExportImportConfiguration exportImportConfiguration) throws Exception {
        Document document = this.getDocument(exportImportConfiguration);
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), exportImportConfiguration.getCompanyId(), document, this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.getExportImportConfiguration(classPK);
        this.doReindex(exportImportConfiguration);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexExportImportConfigurations(companyId);
    }

    protected void populateDates(Document document, Map<String, Serializable> settingsMap) {
        if (settingsMap.containsKey("endDate")) {
            Date endDate = (Date)settingsMap.get("endDate");
            document.addDate("setting_endDate", endDate);
        }
        if (settingsMap.containsKey("startDate")) {
            Date startDate = (Date)settingsMap.get("startDate");
            document.addDate("setting_startDate", startDate);
        }
    }

    protected void populateLayoutIds(Document document, Map<String, Serializable> settingsMap) {
        long[] layoutIds;
        block4: {
            if (!settingsMap.containsKey("layoutIdMap") && !settingsMap.containsKey("layoutIds")) {
                return;
            }
            layoutIds = GetterUtil.getLongValues((Object)settingsMap.get("layoutIds"));
            if (ArrayUtil.isEmpty((long[])layoutIds)) {
                Map layoutIdMap = (Map)((Object)settingsMap.get("layoutIdMap"));
                try {
                    layoutIds = this._exportImportHelper.getLayoutIds(layoutIdMap);
                }
                catch (PortalException pe) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)pe, (Throwable)pe);
                }
            }
        }
        document.addKeyword("layoutIds", layoutIds);
    }

    protected void populateLocale(Document document, Map<String, Serializable> settingsMap) {
        Locale locale = (Locale)settingsMap.get("locale");
        document.addText("setting_locale", locale.toString());
    }

    protected void populateParameterMap(Document document, Map<String, Serializable> settingsMap) {
        if (!settingsMap.containsKey("parameterMap")) {
            return;
        }
        Map parameterMap = (Map)((Object)settingsMap.get("parameterMap"));
        for (Map.Entry entry : parameterMap.entrySet()) {
            String parameterName = (String)entry.getKey();
            if (!Field.validateFieldName((String)parameterName)) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Skipping invalid parameter name: " + parameterName));
                continue;
            }
            String[] parameterValues = (String[])ArrayUtil.clone((Object[])((Object[])entry.getValue()));
            for (int i = 0; i < parameterValues.length; ++i) {
                String parameterValue = parameterValues[i];
                if (parameterValue.equals("true")) {
                    parameterValues[i] = "on";
                    continue;
                }
                if (!parameterValue.equals("false")) continue;
                parameterValues[i] = "off";
            }
            document.addKeyword(_PREFIX_PARAMETER + (String)entry.getKey(), parameterValues);
        }
    }

    protected void populateSiteInformation(Document document, Map<String, Serializable> settingsMap) {
        document.addKeyword("setting_privateLayout", MapUtil.getBoolean(settingsMap, (String)"privateLayout"));
        document.addKeyword("setting_sourceGroupId", MapUtil.getLong(settingsMap, (String)"sourceGroupId"));
        document.addKeyword("setting_targetGroupId", MapUtil.getLong(settingsMap, (String)"targetGroupId"));
    }

    protected void populateTimeZone(Document document, Map<String, Serializable> settingsMap) {
        TimeZone timeZone = (TimeZone)settingsMap.get("timeZone");
        if (timeZone != null) {
            document.addKeyword("setting_timeZone", timeZone.getDisplayName());
        }
    }

    protected void reindexExportImportConfigurations(long companyId) throws PortalException {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._exportImportConfigurationLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ExportImportConfiguration>(){

            public void performAction(ExportImportConfiguration exportImportConfiguration) {
                block2: {
                    try {
                        Document document = ExportImportConfigurationIndexer.this.getDocument(exportImportConfiguration);
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Object)("Unable to index export import configuration " + exportImportConfiguration.getExportImportConfigurationId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    @Reference(unbind="-")
    protected void setExportImportConfigurationLocalService(ExportImportConfigurationLocalService exportImportConfigurationLocalService) {
        this._exportImportConfigurationLocalService = exportImportConfigurationLocalService;
    }
}

