/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.controller;

import com.liferay.asset.kernel.model.adapter.StagedAssetLink;
import com.liferay.exportimport.configuration.ExportImportServiceConfiguration;
import com.liferay.exportimport.controller.PortletImportController;
import com.liferay.exportimport.internal.lar.DeletionSystemEventImporter;
import com.liferay.exportimport.kernel.controller.ExportImportController;
import com.liferay.exportimport.kernel.controller.ImportController;
import com.liferay.exportimport.kernel.exception.LARFileException;
import com.liferay.exportimport.kernel.exception.LARTypeException;
import com.liferay.exportimport.kernel.exception.LayoutImportException;
import com.liferay.exportimport.kernel.exception.MissingReferenceException;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactory;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerStatusMessageSenderUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.lar.UserIdStrategy;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManager;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.exportimport.lar.PermissionImporter;
import com.liferay.exportimport.portlet.data.handler.provider.PortletDataHandlerProvider;
import com.liferay.layout.set.model.adapter.StagedLayoutSet;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.LayoutPrototypeException;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchLayoutPrototypeException;
import com.liferay.portal.kernel.exception.NoSuchLayoutSetPrototypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.plugin.Version;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.site.model.adapter.StagedGroup;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.kernel.model.Layout"}, service={ExportImportController.class, LayoutImportController.class})
public class LayoutImportController
implements ImportController {
    private static final Log _log = LogFactoryUtil.getLog(LayoutImportController.class);
    private ConfigurationProvider _configurationProvider;
    private final DeletionSystemEventImporter _deletionSystemEventImporter = DeletionSystemEventImporter.getInstance();
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private ExportImportLifecycleManager _exportImportLifecycleManager;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPrototypeLocalService _layoutPrototypeLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;
    @Reference
    private PermissionImporter _permissionImporter;
    @Reference
    private PortletDataContextFactory _portletDataContextFactory;
    @Reference
    private PortletDataHandlerProvider _portletDataHandlerProvider;
    @Reference
    private PortletImportController _portletImportController;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private Staging _staging;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importDataDeletions(ExportImportConfiguration exportImportConfiguration, File file) throws Exception {
        ZipReader zipReader = null;
        try {
            ExportImportThreadLocal.setLayoutDataDeletionImportInProcess((boolean)true);
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
            boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
            Map parameterMap = (Map)settingsMap.get("parameterMap");
            LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(targetGroupId, privateLayout);
            zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
            this.validateFile(layoutSet.getCompanyId(), targetGroupId, parameterMap, zipReader);
            PortletDataContext portletDataContext = this.getPortletDataContext(exportImportConfiguration, file);
            boolean deletePortletData = MapUtil.getBoolean((Map)parameterMap, (String)"DELETE_PORTLET_DATA");
            if (deletePortletData) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Deleting portlet data");
                }
                this.deletePortletData(portletDataContext);
            }
            this.populateDeletionStagedModelTypes(portletDataContext);
            this._deletionSystemEventImporter.importDeletionSystemEvents(portletDataContext);
        }
        finally {
            ExportImportThreadLocal.setLayoutDataDeletionImportInProcess((boolean)false);
            if (zipReader != null) {
                zipReader.close();
            }
        }
    }

    public void importFile(ExportImportConfiguration exportImportConfiguration, File file) throws Exception {
        PortletDataContext portletDataContext = null;
        try {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)true);
            portletDataContext = this.getPortletDataContext(exportImportConfiguration, file);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(6, this.getProcessFlag(), String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
            long userId = MapUtil.getLong((Map)exportImportConfiguration.getSettingsMap(), (String)"userId");
            this.doImportFile(portletDataContext, userId);
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(5, this.getProcessFlag(), String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext), Long.valueOf(userId)});
        }
        catch (Throwable throwable) {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(4, this.getProcessFlag(), String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext), throwable});
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MissingReferences validateFile(ExportImportConfiguration exportImportConfiguration, File file) throws Exception {
        ZipReader zipReader = null;
        try {
            ExportImportThreadLocal.setLayoutValidationInProcess((boolean)true);
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
            boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
            Map parameterMap = (Map)settingsMap.get("parameterMap");
            LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(targetGroupId, privateLayout);
            zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
            this.validateFile(layoutSet.getCompanyId(), targetGroupId, parameterMap, zipReader);
            PortletDataContext portletDataContext = this.getPortletDataContext(exportImportConfiguration, file);
            portletDataContext.setPrivateLayout(privateLayout);
            MissingReferences missingReferences = this._exportImportHelper.validateMissingReferences(portletDataContext);
            Map dependencyMissingReferences = missingReferences.getDependencyMissingReferences();
            if (!dependencyMissingReferences.isEmpty()) {
                if (this.isValidateMissingReferences()) {
                    throw new MissingReferenceException(missingReferences);
                }
                if (_log.isWarnEnabled()) {
                    try {
                        JSONArray errorMessagesJSONArray = this._staging.getErrorMessagesJSONArray(LocaleUtil.getDefault(), dependencyMissingReferences);
                        _log.warn((Object)("Missing reference validation errors ignored: " + errorMessagesJSONArray));
                    }
                    catch (Exception exception) {
                        _log.warn((Object)exception, (Throwable)exception);
                    }
                }
            }
            MissingReferences missingReferences2 = missingReferences;
            return missingReferences2;
        }
        finally {
            ExportImportThreadLocal.setLayoutValidationInProcess((boolean)false);
            if (zipReader != null) {
                zipReader.close();
            }
        }
    }

    protected void deletePortletData(PortletDataContext portletDataContext) throws Exception {
        List<Element> portletElements = this.fetchPortletElements(portletDataContext.getImportDataRootElement());
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        if (_log.isDebugEnabled() && !portletElements.isEmpty()) {
            _log.debug((Object)"Deleting portlet data");
        }
        for (Element portletElement : portletElements) {
            long layoutId = GetterUtil.getLong((String)portletElement.attributeValue("layout-id"));
            long plid = 0L;
            Layout layout = (Layout)layouts.get(layoutId);
            if (layout != null) {
                plid = layout.getPlid();
            }
            portletDataContext.setPlid(plid);
            portletDataContext.setPortletId(portletElement.attributeValue("portlet-id"));
            this._portletImportController.deletePortletData(portletDataContext);
        }
    }

    protected void doImportFile(PortletDataContext portletDataContext, long userId) throws Exception {
        Map parameterMap = portletDataContext.getParameterMap();
        Group group = this._groupLocalService.getGroup(portletDataContext.getGroupId());
        String layoutsImportMode = MapUtil.getString((Map)parameterMap, (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        boolean permissions = MapUtil.getBoolean((Map)parameterMap, (String)"PERMISSIONS");
        if (group.isLayoutSetPrototype()) {
            parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{Boolean.FALSE.toString()});
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Import permissions " + permissions));
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this._permissionImporter.clearCache();
        long companyId = portletDataContext.getCompanyId();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
        }
        serviceContext.setCompanyId(companyId);
        serviceContext.setSignedIn(false);
        serviceContext.setUserId(userId);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        this.validateFile(companyId, portletDataContext.getGroupId(), parameterMap, portletDataContext.getZipReader());
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        groupIds.put(portletDataContext.getSourceGroupId(), portletDataContext.getGroupId());
        ManifestSummary manifestSummary = this._exportImportHelper.getManifestSummary(portletDataContext);
        portletDataContext.setManifestSummary(manifestSummary);
        Element rootElement = portletDataContext.getImportDataRootElement();
        Element headerElement = rootElement.element("header");
        String layoutSetPrototypeUuid = headerElement.attributeValue("layout-set-prototype-uuid");
        String larType = headerElement.attributeValue("type");
        portletDataContext.setType(larType);
        if (group.isLayoutPrototype() && larType.equals("layout-prototype")) {
            LayoutPrototype existingLayoutPrototype;
            String layoutPrototypeUuid;
            block25: {
                parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
                layoutPrototypeUuid = GetterUtil.getString((String)headerElement.attributeValue("type-uuid"));
                existingLayoutPrototype = null;
                if (Validator.isNotNull((String)layoutPrototypeUuid)) {
                    try {
                        existingLayoutPrototype = this._layoutPrototypeLocalService.getLayoutPrototypeByUuidAndCompanyId(layoutPrototypeUuid, companyId);
                    }
                    catch (NoSuchLayoutPrototypeException noSuchLayoutPrototypeException) {
                        if (!_log.isDebugEnabled()) break block25;
                        _log.debug((Object)noSuchLayoutPrototypeException, (Throwable)noSuchLayoutPrototypeException);
                    }
                }
            }
            if (existingLayoutPrototype == null) {
                LayoutPrototype layoutPrototype = this._layoutPrototypeLocalService.getLayoutPrototype(group.getClassPK());
                List layouts = this._layoutLocalService.getLayoutsByLayoutPrototypeUuid(layoutPrototype.getUuid());
                layoutPrototype.setUuid(layoutPrototypeUuid);
                this._layoutPrototypeLocalService.updateLayoutPrototype(layoutPrototype);
                for (Layout layout : layouts) {
                    layout.setLayoutPrototypeUuid(layoutPrototypeUuid);
                    this._layoutLocalService.updateLayout(layout);
                }
            }
        } else if (group.isLayoutSetPrototype() && larType.equals("layout-set-prototype")) {
            LayoutSetPrototype existingLayoutSetPrototype;
            String importedLayoutSetPrototypeUuid;
            block26: {
                parameterMap.put("LAYOUT_SET_PROTOTYPE_SETTINGS", new String[]{Boolean.TRUE.toString()});
                importedLayoutSetPrototypeUuid = GetterUtil.getString((String)headerElement.attributeValue("type-uuid"));
                existingLayoutSetPrototype = null;
                if (Validator.isNotNull((String)importedLayoutSetPrototypeUuid)) {
                    try {
                        existingLayoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(importedLayoutSetPrototypeUuid, companyId);
                    }
                    catch (NoSuchLayoutSetPrototypeException noSuchLayoutSetPrototypeException) {
                        if (!_log.isDebugEnabled()) break block26;
                        _log.debug((Object)noSuchLayoutSetPrototypeException, (Throwable)noSuchLayoutSetPrototypeException);
                    }
                }
            }
            if (existingLayoutSetPrototype == null) {
                LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototype(group.getClassPK());
                List layoutSets = this._layoutSetLocalService.getLayoutSetsByLayoutSetPrototypeUuid(layoutSetPrototype.getUuid());
                layoutSetPrototype.setUuid(importedLayoutSetPrototypeUuid);
                this._layoutSetPrototypeLocalService.updateLayoutSetPrototype(layoutSetPrototype);
                for (LayoutSet curLayoutSet : layoutSets) {
                    curLayoutSet.setLayoutSetPrototypeUuid(importedLayoutSetPrototypeUuid);
                    this._layoutSetLocalService.updateLayoutSet(curLayoutSet);
                }
            }
        } else if (larType.equals("layout-set-prototype")) {
            parameterMap.put("LAYOUT_SET_PROTOTYPE_SETTINGS", new String[]{Boolean.TRUE.toString()});
            layoutSetPrototypeUuid = GetterUtil.getString((String)headerElement.attributeValue("type-uuid"));
        }
        if (Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            portletDataContext.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
        }
        List<Element> portletElements = this.fetchPortletElements(rootElement);
        if (permissions) {
            for (Element element : portletElements) {
                String portletPath = element.attributeValue("path");
                Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletPath));
                this._permissionImporter.checkRoles(companyId, portletDataContext.getGroupId(), userId, portletDocument.getRootElement());
            }
            this._permissionImporter.readPortletDataPermissions(portletDataContext);
        }
        if (!layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            this._portletImportController.readExpandoTables(portletDataContext);
        }
        this._portletImportController.readLocks(portletDataContext);
        Element groupsElement = portletDataContext.getImportDataGroupElement(StagedGroup.class);
        for (Element groupElement : groupsElement.elements()) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)groupElement);
        }
        int n = GetterUtil.getInteger((String)headerElement.attributeValue("build-number"));
        if (n < 7100) {
            this.importLayoutsFromLegacyLar(portletDataContext, layoutSetPrototypeUuid, serviceContext, portletElements, manifestSummary, userId);
        }
        this._portletImportController.importAssetLinks(portletDataContext);
        this._groupLocalService.updateSite(portletDataContext.getGroupId(), true);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing layouts takes " + stopWatch.getTime() + " ms"));
        }
        ZipReader zipReader = portletDataContext.getZipReader();
        zipReader.close();
    }

    protected List<Element> fetchPortletElements(Element rootElement) {
        ArrayList<Element> portletElements = new ArrayList<Element>();
        Element sitePortletsElement = rootElement.element("site-portlets");
        if (sitePortletsElement == null) {
            sitePortletsElement = rootElement.element("portlets");
        }
        portletElements.addAll(sitePortletsElement.elements("portlet"));
        XPath xPath = SAXReaderUtil.createXPath((String)"staged-model/portlets/portlet");
        Element layoutsElement = rootElement.element(Layout.class.getSimpleName());
        List nodes = xPath.selectNodes((Object)layoutsElement);
        Stream nodesStream = nodes.stream();
        nodesStream.map(node -> (Element)node).forEach(portletElements::add);
        return portletElements;
    }

    protected PortletDataContext getPortletDataContext(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long userId = MapUtil.getLong((Map)settingsMap, (String)"userId");
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        Group group = this._groupLocalService.getGroup(targetGroupId);
        String userIdStrategyString = MapUtil.getString((Map)parameterMap, (String)"USER_ID_STRATEGY");
        UserIdStrategy userIdStrategy = this._exportImportHelper.getUserIdStrategy(userId, userIdStrategyString);
        PortletDataContext portletDataContext = this._portletDataContextFactory.createImportPortletDataContext(group.getCompanyId(), targetGroupId, parameterMap, userIdStrategy, ZipReaderFactoryUtil.getZipReader((File)file));
        portletDataContext.setExportImportProcessId(String.valueOf(exportImportConfiguration.getExportImportConfigurationId()));
        portletDataContext.setPrivateLayout(privateLayout);
        return portletDataContext;
    }

    protected int getProcessFlag() {
        if (ExportImportThreadLocal.isLayoutStagingInProcess()) {
            return 32;
        }
        return 31;
    }

    protected void importLayoutsFromLegacyLar(PortletDataContext portletDataContext, String layoutSetPrototypeUuid, ServiceContext serviceContext, List<Element> portletElements, ManifestSummary manifestSummary, long userId) throws Exception {
        HashSet<Layout> modifiedLayouts = new HashSet<Layout>();
        Map parameterMap = portletDataContext.getParameterMap();
        boolean layoutSetPrototypeLinkEnabled = MapUtil.getBoolean((Map)parameterMap, (String)"LAYOUT_SET_PROTOTYPE_LINK_ENABLED");
        Group group = this._groupLocalService.getGroup(portletDataContext.getGroupId());
        if (group.isLayoutSetPrototype()) {
            layoutSetPrototypeLinkEnabled = false;
            parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{Boolean.FALSE.toString()});
        }
        if (Validator.isNotNull((String)layoutSetPrototypeUuid) && layoutSetPrototypeLinkEnabled) {
            LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(layoutSetPrototypeUuid, portletDataContext.getCompanyId());
            List previousLayouts = this._layoutLocalService.getLayouts(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
            for (Layout layout : previousLayouts) {
                if (Validator.isNull((String)layout.getSourcePrototypeLayoutUuid())) continue;
                if (SitesUtil.isLayoutModifiedSinceLastMerge((Layout)layout)) {
                    modifiedLayouts.add(layout);
                    continue;
                }
                Layout sourcePrototypeLayout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(layout.getSourcePrototypeLayoutUuid(), layoutSetPrototype.getGroupId(), true);
                if (sourcePrototypeLayout != null) continue;
                this._layoutLocalService.deleteLayout(layout, serviceContext);
            }
        }
        Element stagedLayoutSetsElement = portletDataContext.getImportDataGroupElement(StagedLayoutSet.class);
        List stagedLayoutSetElements = stagedLayoutSetsElement.elements();
        for (Element stagedLayoutSetElement : stagedLayoutSetElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)stagedLayoutSetElement);
        }
        Element layoutsElement = portletDataContext.getImportDataGroupElement(Layout.class);
        List layoutElements = layoutsElement.elements();
        if (_log.isDebugEnabled() && !layoutElements.isEmpty()) {
            _log.debug((Object)"Importing layouts");
        }
        for (Object layoutElement : layoutElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)layoutElement);
        }
        if (_log.isDebugEnabled() && !portletElements.isEmpty()) {
            _log.debug((Object)"Importing portlets");
        }
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        for (Element portletElement : portletElements) {
            String portletId = portletElement.attributeValue("portlet-id");
            Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
            if (!portlet.isActive() || portlet.isUndeployedPortlet()) continue;
            long layoutId = GetterUtil.getLong((String)portletElement.attributeValue("layout-id"));
            Layout layout = (Layout)layouts.get(layoutId);
            long plid = 0L;
            if (layout != null) {
                plid = layout.getPlid();
                if (modifiedLayouts.contains(layout)) continue;
            }
            portletDataContext.setPlid(plid);
            portletDataContext.setPortletId(portletId);
            if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
                PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage((String)"portlet", (String)portletId, (ManifestSummary)manifestSummary);
            }
            String portletPath = portletElement.attributeValue("path");
            Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletPath));
            portletElement = portletDocument.getRootElement();
            long portletPreferencesGroupId = portletDataContext.getGroupId();
            Element portletDataElement = portletElement.element("portlet-data");
            Map importPortletControlsMap = this._exportImportHelper.getImportPortletControlsMap(portletDataContext.getCompanyId(), portletId, parameterMap, portletDataElement, manifestSummary);
            if (layout != null) {
                portletPreferencesGroupId = layout.getGroupId();
            }
            try {
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(12, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
                this._portletImportController.importPortletPreferences(portletDataContext, portletDataContext.getCompanyId(), portletPreferencesGroupId, layout, portletElement, false, ((Boolean)importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_DATA")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_SETUP")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_USER_PREFERENCES")).booleanValue());
                if (((Boolean)importPortletControlsMap.get("PORTLET_DATA")).booleanValue()) {
                    this._portletImportController.importPortletData(portletDataContext, portletDataElement);
                }
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(11, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
            }
            catch (Throwable throwable) {
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(10, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext), throwable});
                throw throwable;
            }
            finally {
                this._portletImportController.resetPortletScope(portletDataContext, portletPreferencesGroupId);
            }
            boolean permissions = MapUtil.getBoolean((Map)parameterMap, (String)"PERMISSIONS");
            if (permissions) {
                this._permissionImporter.importPortletPermissions(portletDataContext.getCompanyId(), portletDataContext.getGroupId(), userId, layout, portletElement, portletId);
            }
            this._portletImportController.importPortletPreferences(portletDataContext, portletDataContext.getCompanyId(), portletDataContext.getGroupId(), null, portletElement, false, ((Boolean)importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_DATA")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_SETUP")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_USER_PREFERENCES")).booleanValue());
        }
        if (_log.isDebugEnabled() && !portletElements.isEmpty()) {
            _log.debug((Object)"Importing services");
        }
        Element rootElement = portletDataContext.getImportDataRootElement();
        Element servicesElement = rootElement.element("services");
        List serviceElements = servicesElement.elements("service");
        for (Element serviceElement : serviceElements) {
            String path = serviceElement.attributeValue("path");
            Document serviceDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(path));
            serviceElement = serviceDocument.getRootElement();
            this._portletImportController.importServicePortletPreferences(portletDataContext, serviceElement);
        }
    }

    protected boolean isValidateMissingReferences() {
        try {
            ExportImportServiceConfiguration configuration = (ExportImportServiceConfiguration)this._configurationProvider.getCompanyConfiguration(ExportImportServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return configuration.validateMissingReferences();
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return true;
        }
    }

    protected void populateDeletionStagedModelTypes(PortletDataContext portletDataContext) throws Exception {
        List<Element> portletElements = this.fetchPortletElements(portletDataContext.getImportDataRootElement());
        for (Element portletElement : portletElements) {
            PortletDataHandler portletDataHandler;
            String portletId = portletElement.attributeValue("portlet-id");
            Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
            if (portlet == null || !portlet.isActive() || portlet.isUndeployedPortlet() || (portletDataHandler = this._portletDataHandlerProvider.provide(portletDataContext.getCompanyId(), portletId)) == null) continue;
            portletDataContext.addDeletionSystemEventStagedModelTypes(portletDataHandler.getDeletionSystemEventStagedModelTypes());
        }
        portletDataContext.addDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(Layout.class)});
        portletDataContext.addDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(SegmentsExperience.class, Layout.class)});
        portletDataContext.addDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(StagedAssetLink.class)});
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    protected void validateFile(long companyId, long groupId, Map<String, String[]> parameterMap, ZipReader zipReader) throws Exception {
        String xml = zipReader.getEntryAsString("/manifest.xml");
        if (xml == null) {
            throw new LARFileException(1);
        }
        Element rootElement = null;
        try {
            Document document = SAXReaderUtil.read((String)xml);
            rootElement = document.getRootElement();
        }
        catch (Exception exception) {
            throw new LARFileException(2, (Throwable)exception);
        }
        Element headerElement = rootElement.element("header");
        int importBuildNumber = GetterUtil.getInteger((String)headerElement.attributeValue("build-number"));
        if (importBuildNumber < 7000) {
            int buildNumber = ReleaseInfo.getBuildNumber();
            if (buildNumber != importBuildNumber) {
                throw new LayoutImportException(1, new Object[]{importBuildNumber, buildNumber});
            }
        } else {
            BiPredicate<Version, Version> majorVersionBiPredicate = (currentVersion, importVersion) -> Objects.equals(currentVersion.getMajor(), importVersion.getMajor());
            BiPredicate<Version, Version> minorVersionBiPredicate = (currentVersion, importVersion) -> {
                int currentMinorVersion = GetterUtil.getInteger((String)currentVersion.getMinor(), (int)-1);
                int importedMinorVersion = GetterUtil.getInteger((String)importVersion.getMinor(), (int)-1);
                return (currentMinorVersion != -1 || importedMinorVersion != -1) && currentMinorVersion >= importedMinorVersion;
            };
            BiPredicate<Version, Version> manifestVersionBiPredicate = (currentVersion, importVersion) -> {
                BiPredicate<Version, Version> versionBiPredicate = majorVersionBiPredicate.and(minorVersionBiPredicate);
                return versionBiPredicate.test((Version)currentVersion, (Version)importVersion);
            };
            String importSchemaVersion = GetterUtil.getString((String)headerElement.attributeValue("schema-version"), (String)"1.0.0");
            if (!manifestVersionBiPredicate.test(Version.getInstance((String)"4.0.0"), Version.getInstance((String)importSchemaVersion))) {
                throw new LayoutImportException(2, new Object[]{importSchemaVersion, "4.0.0"});
            }
        }
        String larType = headerElement.attributeValue("type");
        String[] expectedLARTypes = new String[]{"layout-prototype", "layout-set", "layout-set-prototype"};
        Stream<String> stream = Stream.of(expectedLARTypes);
        if (stream.noneMatch(lt -> lt.equals(larType))) {
            throw new LARTypeException(larType, expectedLARTypes);
        }
        Group group = this._groupLocalService.fetchGroup(groupId);
        String layoutsImportMode = MapUtil.getString(parameterMap, (String)"LAYOUTS_IMPORT_MODE");
        if (larType.equals("layout-prototype") && !group.isLayoutPrototype() && !layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            throw new LARTypeException(1);
        }
        if (larType.equals("layout-set")) {
            if (group.isLayoutPrototype() || group.isLayoutSetPrototype()) {
                throw new LARTypeException(2);
            }
            long sourceCompanyGroupId = GetterUtil.getLong((String)headerElement.attributeValue("company-group-id"));
            long sourceGroupId = GetterUtil.getLong((String)headerElement.attributeValue("group-id"));
            boolean companySourceGroup = false;
            if (sourceCompanyGroupId == sourceGroupId) {
                companySourceGroup = true;
            } else if (!(!ExportImportThreadLocal.isStagingInProcess() || !group.isStaged() && !group.hasStagingGroup() || group.isStagedRemotely() && group.hasRemoteStagingGroup())) {
                Group sourceGroup = this._groupLocalService.fetchGroup(sourceGroupId);
                companySourceGroup = sourceGroup.isCompany();
            }
            if (group.isCompany() ^ companySourceGroup) {
                throw new LARTypeException(5);
            }
        }
        if (larType.equals("layout-set-prototype") && !group.isLayoutSetPrototype() && !layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            throw new LARTypeException(3);
        }
        List<Element> portletElements = this.fetchPortletElements(rootElement);
        for (Element portletElement : portletElements) {
            String schemaVersion;
            PortletDataHandler portletDataHandler;
            String portletId = GetterUtil.getString((String)portletElement.attributeValue("portlet-id"));
            if (Validator.isNull((String)portletId) || (portletDataHandler = this._portletDataHandlerProvider.provide(companyId, portletId)) == null || portletDataHandler.validateSchemaVersion(schemaVersion = GetterUtil.getString((String)portletElement.attributeValue("schema-version")))) continue;
            throw new LayoutImportException(3, new Object[]{schemaVersion, portletId, portletDataHandler.getSchemaVersion()});
        }
        List<Locale> sourceAvailableLocales = Arrays.asList(LocaleUtil.fromLanguageIds((String[])StringUtil.split((String)headerElement.attributeValue("available-locales"))));
        for (Locale sourceAvailableLocale : sourceAvailableLocales) {
            if (LanguageUtil.isAvailableLocale((long)groupId, (Locale)sourceAvailableLocale)) continue;
            LocaleException localeException = new LocaleException(2);
            localeException.setSourceAvailableLocales(sourceAvailableLocales);
            localeException.setTargetAvailableLocales((Collection)LanguageUtil.getAvailableLocales((long)groupId));
            throw localeException;
        }
        Element layoutsElement = rootElement.element(Layout.class.getSimpleName());
        this.validateLayoutPrototypes(companyId, headerElement, layoutsElement);
    }

    protected void validateLayoutPrototypes(long companyId, Element headerElement, Element layoutsElement) throws Exception {
        ArrayList<Tuple> missingLayoutPrototypes = new ArrayList<Tuple>();
        String layoutSetPrototypeUuid = headerElement.attributeValue("layout-set-prototype-uuid");
        if (Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            try {
                this._layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(layoutSetPrototypeUuid, companyId);
            }
            catch (NoSuchLayoutSetPrototypeException noSuchLayoutSetPrototypeException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)noSuchLayoutSetPrototypeException, (Throwable)noSuchLayoutSetPrototypeException);
                }
                String layoutSetPrototypeName = headerElement.attributeValue("layout-set-prototype-name");
                missingLayoutPrototypes.add(new Tuple(new Object[]{LayoutSetPrototype.class.getName(), layoutSetPrototypeUuid, layoutSetPrototypeName}));
            }
        }
        List layoutElements = layoutsElement.elements();
        for (Element layoutElement : layoutElements) {
            LayoutPrototype layoutPrototype;
            String layoutPrototypeUuid;
            boolean layoutPrototypeGlobal;
            String action = layoutElement.attributeValue("action");
            if (action.equals("skip") || !(layoutPrototypeGlobal = GetterUtil.getBoolean((String)layoutElement.attributeValue("layout-prototype-global", "true"))) || Validator.isNull((String)(layoutPrototypeUuid = GetterUtil.getString((String)layoutElement.attributeValue("layout-prototype-uuid"))))) continue;
            String layoutPrototypeName = GetterUtil.getString((String)layoutElement.attributeValue("layout-prototype-name"));
            boolean preloaded = GetterUtil.getBoolean((String)layoutElement.attributeValue("preloaded"));
            if (!preloaded) {
                layoutPrototype = this._layoutPrototypeLocalService.fetchLayoutPrototypeByUuidAndCompanyId(layoutPrototypeUuid, companyId);
                if (layoutPrototype != null) continue;
                missingLayoutPrototypes.add(new Tuple(new Object[]{LayoutPrototype.class.getName(), layoutPrototypeUuid, layoutPrototypeName}));
                continue;
            }
            layoutPrototype = this._layoutPrototypeLocalService.fetchLayoutProtoype(companyId, layoutPrototypeName);
            if (layoutPrototype != null) continue;
            missingLayoutPrototypes.add(new Tuple(new Object[]{LayoutPrototype.class.getName(), layoutPrototypeUuid, layoutPrototypeName}));
        }
        if (!missingLayoutPrototypes.isEmpty()) {
            throw new LayoutPrototypeException(missingLayoutPrototypes);
        }
    }
}

