/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lifecycle;

import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleEvent;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleListener;
import com.liferay.exportimport.kernel.lifecycle.ProcessAwareExportImportLifecycleListener;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ExportImportLifecycleListener.class})
public class NotificationExportImportLifecycleListener
implements ProcessAwareExportImportLifecycleListener {
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public boolean isParallel() {
        return false;
    }

    public void onProcessFailed(ExportImportLifecycleEvent exportImportLifecycleEvent) throws Exception {
        this.sendNotification(2);
    }

    public void onProcessStarted(ExportImportLifecycleEvent exportImportLifecycleEvent) throws Exception {
    }

    public void onProcessSucceeded(ExportImportLifecycleEvent exportImportLifecycleEvent) throws Exception {
        this.sendNotification(3);
    }

    protected JSONObject getPayloadJSONObject(long backgroundTaskId, long exportImportConfigurationId, int status) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        jsonObject.put("backgroundTaskId", backgroundTaskId).put("exportImportConfigurationId", exportImportConfigurationId).put("status", status);
        return jsonObject;
    }

    protected void sendNotification(int status) throws PortalException {
        long backgroundTaskId = BackgroundTaskThreadLocal.getBackgroundTaskId();
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.getBackgroundTask(backgroundTaskId);
        Map taskContextMap = backgroundTask.getTaskContextMap();
        long exportImportConfigurationId = GetterUtil.getLong(taskContextMap.get("exportImportConfigurationId"));
        this._userNotificationEventLocalService.sendUserNotificationEvents(backgroundTask.getUserId(), "com_liferay_exportimport_web_portlet_ExportImportPortlet", 10002, this.getPayloadJSONObject(backgroundTaskId, exportImportConfigurationId, status));
    }
}

