/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.upgrade.v1_0_0;

import com.liferay.exportimport.internal.upgrade.v1_0_0.LayoutsLocalPublisherRequest;
import com.liferay.exportimport.internal.upgrade.v1_0_0.LayoutsRemotePublisherRequest;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactoryUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PublisherRequestUpgradeProcess
extends UpgradeProcess {
    private final ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    private final GroupLocalService _groupLocalService;
    private final SchedulerEngineHelper _schedulerEngineHelper;
    private final UserLocalService _userLocalService;

    public PublisherRequestUpgradeProcess(ExportImportConfigurationLocalService exportImportConfigurationLocalService, GroupLocalService groupLocalService, SchedulerEngineHelper schedulerEngineHelper, UserLocalService userLocalService) {
        this._exportImportConfigurationLocalService = exportImportConfigurationLocalService;
        this._groupLocalService = groupLocalService;
        this._schedulerEngineHelper = schedulerEngineHelper;
        this._userLocalService = userLocalService;
    }

    protected void doUpgrade() throws Exception {
        List groups = this._groupLocalService.getStagedSites();
        for (Group group : groups) {
            this.updateScheduledPublications(group);
        }
    }

    protected List<Group> getGroups() {
        List groups = this._groupLocalService.getGroups(-1, -1);
        ArrayList<Group> filteredGroups = new ArrayList<Group>(groups.size());
        for (Group group : groups) {
            if (!group.isStaged() && !group.hasLocalOrRemoteStagingGroup()) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    protected String getSchedulerGroupName(long groupId, boolean localStaging) throws PortalException {
        String destinationName = "liferay/layouts_local_publisher";
        if (!localStaging) {
            destinationName = "liferay/layouts_remote_publisher";
        }
        return StagingUtil.getSchedulerGroupName((String)destinationName, (long)groupId);
    }

    protected void updateScheduledLocalPublication(SchedulerResponse schedulerResponse) throws PortalException {
        Message message = schedulerResponse.getMessage();
        LayoutsLocalPublisherRequest publisherRequest = (LayoutsLocalPublisherRequest)message.getPayload();
        User user = this._userLocalService.getUser(publisherRequest.getUserId());
        Map publishLayoutLocalSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildPublishLayoutLocalSettingsMap((User)user, (long)publisherRequest.getSourceGroupId(), (long)publisherRequest.getTargetGroupId(), (boolean)publisherRequest.isPrivateLayout(), (long[])ExportImportHelperUtil.getLayoutIds(publisherRequest.getLayoutIdMap()), publisherRequest.getParameterMap());
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), schedulerResponse.getDescription(), 3, publishLayoutLocalSettingsMap);
        this._schedulerEngineHelper.schedule(schedulerResponse.getTrigger(), StorageType.PERSISTED, schedulerResponse.getDescription(), "liferay/layouts_local_publisher", (Object)exportImportConfiguration.getExportImportConfigurationId(), 0);
    }

    protected void updateScheduledPublications(Group group) throws PortalException {
        try (LoggingTimer loggingTimer = new LoggingTimer(String.valueOf(group.getGroupId()));){
            boolean localStaging = true;
            if (group.isStagedRemotely() || group.hasRemoteStagingGroup()) {
                localStaging = false;
            }
            List scheduledJobs = this._schedulerEngineHelper.getScheduledJobs(this.getSchedulerGroupName(group.getGroupId(), localStaging), StorageType.PERSISTED);
            for (SchedulerResponse schedulerResponse : scheduledJobs) {
                if (localStaging) {
                    this.updateScheduledLocalPublication(schedulerResponse);
                    continue;
                }
                this.updateScheduleRemotePublication(schedulerResponse);
            }
        }
    }

    protected void updateScheduleRemotePublication(SchedulerResponse schedulerResponse) throws PortalException {
        Message message = schedulerResponse.getMessage();
        LayoutsRemotePublisherRequest publisherRequest = (LayoutsRemotePublisherRequest)message.getPayload();
        User user = this._userLocalService.getUser(publisherRequest.getUserId());
        Map publishLayoutRemoteSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildPublishLayoutRemoteSettingsMap((User)user, (long)publisherRequest.getSourceGroupId(), (boolean)publisherRequest.isPrivateLayout(), publisherRequest.getLayoutIdMap(), publisherRequest.getParameterMap(), (String)publisherRequest.getRemoteAddress(), (int)publisherRequest.getRemotePort(), (String)publisherRequest.getRemotePathContext(), (boolean)publisherRequest.isSecureConnection(), (long)publisherRequest.getRemoteGroupId(), (boolean)publisherRequest.isRemotePrivateLayout());
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), schedulerResponse.getDescription(), 4, publishLayoutRemoteSettingsMap);
        this._schedulerEngineHelper.schedule(schedulerResponse.getTrigger(), StorageType.PERSISTED, schedulerResponse.getDescription(), "liferay/layouts_remote_publisher", (Object)exportImportConfiguration.getExportImportConfigurationId(), 0);
    }
}

