/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.lifecycle;

import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleEvent;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleEventFactory;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManager;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ExportImportLifecycleManager.class})
public class ExportImportLifecycleManagerImpl
implements ExportImportLifecycleManager {
    private volatile BundleContext _bundleContext;
    private DestinationFactory _destinationFactory;
    private ExportImportLifecycleEventFactory _exportImportLifecycleEventFactory;
    private MessageBus _messageBus;
    private final Set<ServiceRegistration<Destination>> _serviceRegistrations = new HashSet<ServiceRegistration<Destination>>();

    public void fireExportImportLifecycleEvent(int code, int processFlag, String processId, Serializable ... arguments) {
        ExportImportLifecycleEvent exportImportLifecycleEvent = this._exportImportLifecycleEventFactory.create(code, processFlag, processId, arguments);
        this.fireExportImportLifecycleEvent(exportImportLifecycleEvent);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this.registerDestination(bundleContext, "serial", "liferay/export_import_lifecycle_event_async");
        this.registerDestination(bundleContext, "synchronous", "liferay/export_import_lifecycle_event_sync");
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<Destination> serviceRegistration : this._serviceRegistrations) {
            Destination destination = (Destination)this._bundleContext.getService(serviceRegistration.getReference());
            serviceRegistration.unregister();
            destination.destroy();
        }
        this._bundleContext = null;
    }

    protected void fireExportImportLifecycleEvent(ExportImportLifecycleEvent exportImportLifecycleEvent) {
        Message message = new Message();
        message.put("exportImportLifecycleEvent", (Object)exportImportLifecycleEvent);
        this._messageBus.sendMessage("liferay/export_import_lifecycle_event_async", message.clone());
        this._messageBus.sendMessage("liferay/export_import_lifecycle_event_sync", message.clone());
    }

    protected ServiceRegistration<Destination> registerDestination(BundleContext bundleContext, String destinationType, String destinationName) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration(destinationType, destinationName);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary dictionary = HashMapDictionaryBuilder.put((Object)"destination.name", (Object)destination.getName()).build();
        ServiceRegistration serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)dictionary);
        this._serviceRegistrations.add((ServiceRegistration<Destination>)serviceRegistration);
        return serviceRegistration;
    }

    @Reference(unbind="-")
    protected void setDestinationFactory(DestinationFactory destinationFactory) {
        this._destinationFactory = destinationFactory;
    }

    @Reference(unbind="-")
    protected void setExportImportLifecycleEventFactory(ExportImportLifecycleEventFactory exportImportLifecycleEventFactory) {
        this._exportImportLifecycleEventFactory = exportImportLifecycleEventFactory;
    }

    @Reference(unbind="-")
    protected void setMessageBus(MessageBus messageBus) {
        this._messageBus = messageBus;
    }
}

