/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.test.util.internal.exportimport.staged.model.repository;

import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.test.util.model.DummyReference;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.exportimport.test.util.model.DummyReference"}, service={StagedModelRepository.class})
public class DummyReferenceStagedModelRepository
implements StagedModelRepository<DummyReference> {
    @Reference
    protected Portal portal;
    @Reference
    protected SystemEventLocalService systemEventLocalService;
    private final List<DummyReference> _dummyReferences = new ArrayList<DummyReference>();

    public DummyReference addStagedModel(PortletDataContext portletDataContext, DummyReference dummyReference) throws PortalException {
        if (portletDataContext != null && portletDataContext.getUserIdStrategy() != null) {
            dummyReference.setUserId(portletDataContext.getUserId(dummyReference.getUserUuid()));
        }
        this._dummyReferences.add(dummyReference);
        return dummyReference;
    }

    public void deleteStagedModel(DummyReference dummyReference) throws PortalException {
        if (this._dummyReferences.remove(dummyReference)) {
            this.systemEventLocalService.addSystemEvent(0L, dummyReference.getGroupId(), dummyReference.getModelClassName(), dummyReference.getPrimaryKey(), dummyReference.getUuid(), "", 1, "");
        }
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._dummyReferences.removeIf(dummyReference -> Objects.equals(uuid, dummyReference.getUuid()) && groupId == dummyReference.getGroupId());
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
        this._dummyReferences.clear();
    }

    public DummyReference fetchMissingReference(String uuid, long groupId) {
        return this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
    }

    public DummyReference fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        for (DummyReference dummyReference : this._dummyReferences) {
            if (!Objects.equals(uuid, dummyReference.getUuid()) || groupId != dummyReference.getGroupId()) continue;
            return dummyReference;
        }
        return null;
    }

    public List<DummyReference> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return ListUtil.filter(this._dummyReferences, dummyReference -> Objects.equals(uuid, dummyReference.getUuid()) && companyId == dummyReference.getCompanyId());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = DummyReferenceStagedModelRepository.this._dummyReferences.size();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                manifestSummary.addModelDeletionCount(stagedModelType, 0L);
                return modelAdditionCount;
            }

            protected Projection getCountProjection() {
                return ProjectionFactoryUtil.countDistinct((String)"resourcePrimKey");
            }
        };
        exportActionableDynamicQuery.setBaseLocalService((BaseLocalService)new DummyReferenceBaseLocalServiceImpl());
        Class<?> clazz = this.getClass();
        exportActionableDynamicQuery.setClassLoader(clazz.getClassLoader());
        exportActionableDynamicQuery.setModelClass(DummyReference.class);
        exportActionableDynamicQuery.setPrimaryKeyPropertyName("id");
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Disjunction disjunction;
            Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("modifiedDate");
            if (modifiedDateCriterion != null) {
                Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                conjunction.add(modifiedDateCriterion);
                disjunction = RestrictionsFactoryUtil.disjunction();
                disjunction.add(RestrictionsFactoryUtil.gtProperty((String)"modifiedDate", (String)"lastPublishDate"));
                Property lastPublishDateProperty = PropertyFactoryUtil.forName((String)"lastPublishDate");
                disjunction.add(lastPublishDateProperty.isNull());
                conjunction.add((Criterion)disjunction);
                modifiedDateCriterion = conjunction;
            }
            Criterion statusDateCriterion = portletDataContext.getDateRangeCriteria("statusDate");
            if (modifiedDateCriterion != null && statusDateCriterion != null) {
                disjunction = RestrictionsFactoryUtil.disjunction();
                disjunction.add(modifiedDateCriterion);
                disjunction.add(statusDateCriterion);
                dynamicQuery.add((Criterion)disjunction);
            }
            StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
            long referrerClassNameId = stagedModelType.getReferrerClassNameId();
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
                dynamicQuery.add(classNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
            } else if (referrerClassNameId == -2L) {
                dynamicQuery.add(classNameIdProperty.isNotNull());
            }
            Property workflowStatusProperty = PropertyFactoryUtil.forName((String)"status");
            if (portletDataContext.isInitialPublication()) {
                dynamicQuery.add(workflowStatusProperty.ne((Object)8));
            } else {
                StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)DummyReference.class.getName());
                dynamicQuery.add(workflowStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod(dummyReference -> StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)dummyReference));
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(this.portal.getClassNameId(DummyReference.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    public void restoreStagedModel(PortletDataContext portletDataContext, DummyReference stagedModel) throws PortletDataException {
    }

    public DummyReference saveStagedModel(DummyReference dummyReference) throws PortalException {
        this.deleteStagedModel(dummyReference);
        this.addStagedModel(null, dummyReference);
        return dummyReference;
    }

    public DummyReference updateStagedModel(PortletDataContext portletDataContext, DummyReference dummyReference) throws PortalException {
        DummyReference existingDummyReference = this._fetchDummyReference(dummyReference);
        existingDummyReference.setUserId(portletDataContext.getUserId(dummyReference.getUserUuid()));
        return dummyReference;
    }

    private DummyReference _fetchDummyReference(DummyReference dummyReference) throws NoSuchModelException {
        int i = this._dummyReferences.indexOf(dummyReference);
        if (i < 0) {
            throw new NoSuchModelException();
        }
        return this._dummyReferences.get(i);
    }

    public class DummyReferenceBaseLocalServiceImpl
    extends BaseLocalServiceImpl {
        public List<DummyReference> dynamicQuery(DynamicQuery dynamicQuery) {
            try {
                Object detachedCriteria = ReflectionTestUtil.getFieldValue((Object)dynamicQuery, (String)"_detachedCriteria");
                Object criteriaImpl = ReflectionTestUtil.invoke((Object)detachedCriteria, (String)"getCriteriaImpl", (Class[])new Class[0], (Object[])new Object[0]);
                Iterator iterator = (Iterator)ReflectionTestUtil.invoke((Object)criteriaImpl, (String)"iterateExpressionEntries", (Class[])new Class[0], (Object[])new Object[0]);
                if (!iterator.hasNext()) {
                    return DummyReferenceStagedModelRepository.this._dummyReferences;
                }
                Predicate<DummyReference> predicate = this.getPredicate(String.valueOf(iterator.next()));
                while (iterator.hasNext()) {
                    predicate = predicate.and(this.getPredicate(String.valueOf(iterator.next())));
                }
                return ListUtil.filter((List)DummyReferenceStagedModelRepository.this._dummyReferences, predicate);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
            return DummyReferenceStagedModelRepository.this._dummyReferences.size();
        }

        public Predicate<DummyReference> getPredicate(String expression) {
            if (expression.startsWith("groupId=")) {
                return dummyReference -> dummyReference.getGroupId() == Long.valueOf(expression.substring("groupId=".length())).longValue();
            }
            if (expression.contains("id>-1")) {
                return dummyReference -> dummyReference.getId() > -1L;
            }
            if (expression.startsWith("companyId=")) {
                return dummyReference -> dummyReference.getCompanyId() == Long.valueOf(expression.substring("companyId=".length())).longValue();
            }
            return dummyReference -> true;
        }

        protected ClassLoader getClassLoader() {
            return super.getClassLoader();
        }

        protected Map<Locale, String> getLocalizationMap(String value) {
            return super.getLocalizationMap(value);
        }
    }
}

