/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.test.util.internal.exportimport.staged.model.repository;

import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.test.util.model.Dummy;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.exportimport.test.util.model.Dummy"}, service={StagedModelRepository.class})
public class DummyStagedModelRepository
implements StagedModelRepository<Dummy> {
    @Reference
    protected Portal portal;
    @Reference
    protected SystemEventLocalService systemEventLocalService;
    private final List<Dummy> _dummies = new ArrayList<Dummy>();

    public Dummy addStagedModel(PortletDataContext portletDataContext, Dummy dummy1) throws PortalException {
        Dummy dummy2 = new Dummy();
        dummy1.setId(dummy2.getId());
        if (portletDataContext != null && portletDataContext.getUserIdStrategy() != null) {
            dummy1.setUserId(portletDataContext.getUserId(dummy1.getUserUuid()));
        }
        this._dummies.add(dummy1);
        return dummy1;
    }

    public void deleteStagedModel(Dummy dummy) throws PortalException {
        if (this._dummies.remove(dummy)) {
            this.systemEventLocalService.addSystemEvent(0L, dummy.getGroupId(), dummy.getModelClassName(), dummy.getPrimaryKey(), dummy.getUuid(), "", 1, "");
        }
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._dummies.removeIf(dummy -> Objects.equals(dummy.getUuid(), uuid) && dummy.getGroupId() == groupId);
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
        this._dummies.clear();
    }

    public List<Dummy> fetchDummiesByFolderId(long folderId) {
        return ListUtil.filter(this._dummies, dummy -> folderId == dummy.getFolderId());
    }

    public Dummy fetchDummyById(long id) {
        for (Dummy dummy : this._dummies) {
            if (id != dummy.getId()) continue;
            return dummy;
        }
        return null;
    }

    public Dummy fetchMissingReference(String uuid, long groupId) {
        return this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
    }

    public Dummy fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        for (Dummy dummy : this._dummies) {
            if (!Objects.equals(uuid, dummy.getUuid()) || groupId != dummy.getGroupId()) continue;
            return dummy;
        }
        return null;
    }

    public List<Dummy> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return ListUtil.filter(this._dummies, dummy -> Objects.equals(uuid, dummy.getUuid()) && companyId == dummy.getCompanyId());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = DummyStagedModelRepository.this._dummies.size();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                manifestSummary.addModelDeletionCount(stagedModelType, 0L);
                return modelAdditionCount;
            }

            protected Projection getCountProjection() {
                return ProjectionFactoryUtil.countDistinct((String)"resourcePrimKey");
            }
        };
        exportActionableDynamicQuery.setBaseLocalService((BaseLocalService)new DummyBaseLocalServiceImpl());
        Class<?> clazz = this.getClass();
        exportActionableDynamicQuery.setClassLoader(clazz.getClassLoader());
        exportActionableDynamicQuery.setModelClass(Dummy.class);
        exportActionableDynamicQuery.setPrimaryKeyPropertyName("id");
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Disjunction disjunction;
            Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("modifiedDate");
            if (modifiedDateCriterion != null) {
                Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                conjunction.add(modifiedDateCriterion);
                disjunction = RestrictionsFactoryUtil.disjunction();
                disjunction.add(RestrictionsFactoryUtil.gtProperty((String)"modifiedDate", (String)"lastPublishDate"));
                Property lastPublishDateProperty = PropertyFactoryUtil.forName((String)"lastPublishDate");
                disjunction.add(lastPublishDateProperty.isNull());
                conjunction.add((Criterion)disjunction);
                modifiedDateCriterion = conjunction;
            }
            Criterion statusDateCriterion = portletDataContext.getDateRangeCriteria("statusDate");
            if (modifiedDateCriterion != null && statusDateCriterion != null) {
                disjunction = RestrictionsFactoryUtil.disjunction();
                disjunction.add(modifiedDateCriterion);
                disjunction.add(statusDateCriterion);
                dynamicQuery.add((Criterion)disjunction);
            }
            StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
            long referrerClassNameId = stagedModelType.getReferrerClassNameId();
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
                dynamicQuery.add(classNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
            } else if (referrerClassNameId == -2L) {
                dynamicQuery.add(classNameIdProperty.isNotNull());
            }
            Property workflowStatusProperty = PropertyFactoryUtil.forName((String)"status");
            if (portletDataContext.isInitialPublication()) {
                dynamicQuery.add(workflowStatusProperty.ne((Object)8));
            } else {
                StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)Dummy.class.getName());
                dynamicQuery.add(workflowStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod(dummy -> StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)dummy));
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(this.portal.getClassNameId(Dummy.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    public void restoreStagedModel(PortletDataContext portletDataContext, Dummy stagedModel) throws PortletDataException {
    }

    public Dummy saveStagedModel(Dummy dummy) throws PortalException {
        this.deleteStagedModel(dummy);
        this.addStagedModel(null, dummy);
        return dummy;
    }

    public Dummy updateStagedModel(PortletDataContext portletDataContext, Dummy dummy) throws PortalException {
        Dummy existingDummy = this._fetchDummy(dummy);
        existingDummy.setUserId(portletDataContext.getUserId(dummy.getUserUuid()));
        return dummy;
    }

    private Dummy _fetchDummy(Dummy dummy) throws NoSuchModelException {
        int i = this._dummies.indexOf(dummy);
        if (i < 0) {
            throw new NoSuchModelException();
        }
        return this._dummies.get(i);
    }

    public class DummyBaseLocalServiceImpl
    extends BaseLocalServiceImpl {
        public List<Dummy> dynamicQuery(DynamicQuery dynamicQuery) {
            try {
                Object detachedCriteria = ReflectionTestUtil.getFieldValue((Object)dynamicQuery, (String)"_detachedCriteria");
                Object criteriaImpl = ReflectionTestUtil.invoke((Object)detachedCriteria, (String)"getCriteriaImpl", (Class[])new Class[0], (Object[])new Object[0]);
                Iterator iterator = (Iterator)ReflectionTestUtil.invoke((Object)criteriaImpl, (String)"iterateExpressionEntries", (Class[])new Class[0], (Object[])new Object[0]);
                if (!iterator.hasNext()) {
                    return DummyStagedModelRepository.this._dummies;
                }
                Predicate<Dummy> predicate = this.getPredicate(String.valueOf(iterator.next()));
                while (iterator.hasNext()) {
                    predicate = predicate.and(this.getPredicate(String.valueOf(iterator.next())));
                }
                return ListUtil.filter((List)DummyStagedModelRepository.this._dummies, predicate);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
            return DummyStagedModelRepository.this._dummies.size();
        }

        public Predicate<Dummy> getPredicate(String expression) {
            if (expression.startsWith("groupId=")) {
                return dummy -> dummy.getGroupId() == Long.valueOf(expression.substring("groupId=".length())).longValue();
            }
            if (expression.contains("id>-1")) {
                return dummy -> dummy.getId() > -1L;
            }
            if (expression.startsWith("companyId=")) {
                return dummy -> dummy.getCompanyId() == Long.valueOf(expression.substring("companyId=".length())).longValue();
            }
            return dummy -> true;
        }

        protected ClassLoader getClassLoader() {
            return super.getClassLoader();
        }

        protected Map<Locale, String> getLocalizationMap(String value) {
            return super.getLocalizationMap(value);
        }
    }
}

