/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.test.util.lar;

import com.liferay.exportimport.kernel.lar.DataLevel;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactory;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.kernel.zip.ZipReaderFactory;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactory;
import com.liferay.portal.test.rule.Inject;
import com.liferay.portlet.PortletPreferencesImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletPreferences;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public abstract class BasePortletDataHandlerTestCase {
    protected Element missingReferencesElement;
    protected PortletDataContext portletDataContext;
    protected PortletDataHandler portletDataHandler;
    protected String portletId;
    protected Element rootElement;
    @DeleteAfterTestRun
    protected Group stagingGroup;
    protected ZipWriter zipWriter;
    @Inject
    private PortletDataContextFactory _portletDataContextFactory;
    @Inject
    private PortletLocalService _portletLocalService;
    @Inject
    private SAXReader _saxReader;
    @Inject
    private ZipReaderFactory _zipReaderFactory;
    @Inject
    private ZipWriterFactory _zipWriterFactory;

    @Before
    public void setUp() throws Exception {
        this.stagingGroup = GroupTestUtil.addGroup();
        this.portletId = this.getPortletId();
        this.portletDataHandler = this.getPortletDataHandler(this.portletId);
    }

    @Test
    public void testAddDefaultData() throws Exception {
        this.initContext();
        PortletPreferences portletPreferences = this.portletDataHandler.addDefaultData(this.portletDataContext, this.portletId, (PortletPreferences)new PortletPreferencesImpl());
        this.validateDefaultData(portletPreferences);
    }

    @Test
    public void testDataLevel() {
        Assert.assertEquals((Object)this.getDataLevel(), (Object)this.portletDataHandler.getDataLevel());
    }

    @Test
    public void testDeleteData() throws Exception {
        if (!this.isDeleteDataTested()) {
            return;
        }
        this.initContext();
        PortletPreferencesImpl portletPreferences = new PortletPreferencesImpl();
        this.addStagedModels();
        this.portletDataContext.setEndDate(this.getEndDate());
        this.portletDataHandler.deleteData(this.portletDataContext, this.portletId, (PortletPreferences)portletPreferences);
        List<StagedModel> stagedModels = this.getStagedModels();
        Assert.assertEquals((String)stagedModels.toString(), (long)0L, (long)stagedModels.size());
        for (String preferenceKey : this.portletDataHandler.getDataPortletPreferences()) {
            String portletPreference = portletPreferences.getValue(preferenceKey, "");
            Assert.assertEquals((Object)"", (Object)portletPreference);
        }
    }

    @Test
    public void testExportImportData() throws Exception {
        if (!this.isExportImportDataTested()) {
            return;
        }
        this.initContext();
        this.addStagedModels();
        PortletPreferencesImpl portletPreferences = new PortletPreferencesImpl();
        this.portletDataContext.setEndDate(this.getEndDate());
        String exportData = this.portletDataHandler.exportData(this.portletDataContext, this.portletId, (PortletPreferences)portletPreferences);
        Document document = this._saxReader.read(exportData);
        Element rootElement = document.getRootElement();
        List<StagedModel> exportedStagedModels = this.getStagedModels();
        for (StagedModel stagedModel : exportedStagedModels) {
            Class modelClass = stagedModel.getModelClass();
            Element element = rootElement.element(modelClass.getSimpleName());
            List stagedModelNodes = element.content();
            boolean contains = false;
            for (Node node : stagedModelNodes) {
                if (!(node instanceof Element)) continue;
                Element nodeElement = (Element)node;
                Attribute uuidAttribute = nodeElement.attribute("uuid");
                String uuid = uuidAttribute.getValue();
                if (!Objects.equals(stagedModel.getUuid(), uuid)) continue;
                contains = true;
            }
            Assert.assertTrue((boolean)contains);
        }
        ZipWriter exportZipWriter = this.portletDataContext.getZipWriter();
        this.initContext();
        Group cleanGroup = GroupTestUtil.addGroup();
        this.portletDataContext.setDataStrategy("DATA_STRATEGY_MIRROR");
        this.portletDataContext.setGroupId(cleanGroup.getGroupId());
        this.portletDataContext.setScopeGroupId(cleanGroup.getGroupId());
        this.portletDataContext.setUserIdStrategy(userUuid -> {
            try {
                return TestPropsValues.getUserId();
            }
            catch (Exception exception) {
                return 0L;
            }
        });
        this.portletDataContext.setZipReader(this._zipReaderFactory.getZipReader(exportZipWriter.getFile()));
        this.portletDataContext.clearScopedPrimaryKeys();
        this.portletDataHandler.importData(this.portletDataContext, this.portletId, (PortletPreferences)portletPreferences, exportData);
        List<StagedModel> importedStagedModels = this.getStagedModels();
        HashSet<String> exportedUuidSet = new HashSet<String>();
        HashSet<String> importedUuidSet = new HashSet<String>();
        for (StagedModel stagedModel : exportedStagedModels) {
            exportedUuidSet.add(stagedModel.getUuid());
        }
        for (StagedModel stagedModel : importedStagedModels) {
            importedUuidSet.add(stagedModel.getUuid());
        }
        Assert.assertEquals(exportedUuidSet, importedUuidSet);
    }

    @Test
    public void testGetDataPortletPreferences() {
        Assert.assertArrayEquals((Object[])this.getDataPortletPreferences(), (Object[])this.portletDataHandler.getDataPortletPreferences());
    }

    @Test
    public void testGetExportConfigurationControls() throws Exception {
        if (!this.isGetExportConfigurationControlsTested()) {
            return;
        }
        Portlet portlet = this._portletLocalService.getPortletById(this.portletId);
        this.initContext();
        PortletDataHandlerControl[] portletDataHandlerControls = null;
        if (this.portletDataHandler.isDisplayPortlet()) {
            portletDataHandlerControls = this.portletDataHandler.getExportControls();
        }
        this._assertControls(this.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portletDataHandlerControls, -1L, false), this.portletDataHandler.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portlet, false));
        this._assertControls(this.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portletDataHandlerControls, -1L, true), this.portletDataHandler.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portlet, true));
        this._assertControls(this.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portletDataHandlerControls, this.portletDataContext.getPlid(), false), this.portletDataHandler.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portlet, this.portletDataContext.getPlid(), false));
        this._assertControls(this.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portletDataHandlerControls, this.portletDataContext.getPlid(), true), this.portletDataHandler.getExportConfigurationControls(this.portletDataContext.getCompanyId(), this.portletDataContext.getGroupId(), portlet, this.portletDataContext.getPlid(), true));
    }

    @Test
    public void testGetExportControls() throws Exception {
        this._assertControls(this.getExportControls(), this.portletDataHandler.getExportControls());
    }

    @Test
    public void testGetExportMetadataControls() throws Exception {
        this._assertControls(this.getExportMetadataControls(), this.portletDataHandler.getExportMetadataControls());
    }

    @Test
    public void testGetExportModelCount() throws Exception {
        if (!this.isGetExportModelCountTested()) {
            return;
        }
        this.initContext();
        this.addStagedModels();
        this.portletDataContext.setEndDate(this.getEndDate());
        this.portletDataHandler.prepareManifestSummary(this.portletDataContext);
        Assert.assertEquals((long)this.getExportModelCount(), (long)this.portletDataHandler.getExportModelCount(this.portletDataContext.getManifestSummary()));
    }

    @Test
    public void testGetImportConfigurationControls() {
        this._assertControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(null, "PORTLET_SETUP", "setup", true, false, null, null, null)}, this.portletDataHandler.getImportConfigurationControls(new String[]{"setup"}));
        this._assertControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(null, "PORTLET_ARCHIVED_SETUPS", "configuration-templates", true, false, null, null, null)}, this.portletDataHandler.getImportConfigurationControls(new String[]{"archived-setups"}));
        this._assertControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(null, "PORTLET_USER_PREFERENCES", "user-preferences", true, false, null, null, null)}, this.portletDataHandler.getImportConfigurationControls(new String[]{"user-preferences"}));
    }

    @Test
    public void testGetImportControls() throws Exception {
        this._assertControls(this.getImportControls(), this.portletDataHandler.getImportControls());
    }

    @Test
    public void testGetImportMetadataControls() throws Exception {
        this._assertControls(this.getImportMetadataControls(), this.portletDataHandler.getImportMetadataControls());
    }

    @Test
    public void testGetStagingControls() {
        this._assertControls(this.getStagingControls(), this.portletDataHandler.getStagingControls());
    }

    @Test
    public void testIsDataPortalLevel() {
        Assert.assertEquals((Object)this.isDataPortalLevel(), (Object)this.portletDataHandler.isDataPortalLevel());
    }

    @Test
    public void testIsDataPortletInstanceLevel() {
        Assert.assertEquals((Object)this.isDataPortletInstanceLevel(), (Object)this.portletDataHandler.isDataPortletInstanceLevel());
    }

    @Test
    public void testIsDataSiteLevel() {
        Assert.assertEquals((Object)this.isDataSiteLevel(), (Object)this.portletDataHandler.isDataSiteLevel());
    }

    @Test
    public void testIsDisplayPortlet() {
        Assert.assertEquals((Object)this.isDisplayPortlet(), (Object)this.portletDataHandler.isDisplayPortlet());
    }

    @Test
    public void testPrepareManifestSummary() throws Exception {
        this.initContext();
        this.addStagedModels();
        this.portletDataContext.setEndDate(this.getEndDate());
        this.portletDataHandler.prepareManifestSummary(this.portletDataContext);
        ManifestSummary manifestSummary = this.portletDataContext.getManifestSummary();
        ManifestSummary expectedManifestSummary = (ManifestSummary)manifestSummary.clone();
        manifestSummary.resetCounters();
        this.portletDataHandler.exportData(this.portletDataContext, this.portletId, (PortletPreferences)new PortletPreferencesImpl());
        this.checkManifestSummary(expectedManifestSummary);
    }

    @Test
    public void testValidateSchemaVersion() {
        Assert.assertTrue((boolean)this.portletDataHandler.validateSchemaVersion(this.getSchemaVersion()));
    }

    protected void addBooleanParameter(Map<String, String[]> parameterMap, String namespace, String name, boolean value) {
        PortletDataHandlerBoolean portletDataHandlerBoolean = new PortletDataHandlerBoolean(namespace, name);
        parameterMap.put(portletDataHandlerBoolean.getNamespacedControlName(), new String[]{String.valueOf(value)});
    }

    protected void addParameters(Map<String, String[]> parameterMap) {
    }

    protected abstract void addStagedModels() throws Exception;

    protected void checkManifestSummary(ManifestSummary expectedManifestSummary) {
        ManifestSummary manifestSummary = this.portletDataContext.getManifestSummary();
        this.checkManifestSummaryReferrerClassNames(manifestSummary);
        for (String manifestSummaryKey : expectedManifestSummary.getManifestSummaryKeys()) {
            String[] keyParts = StringUtil.split((String)manifestSummaryKey, (String)"#");
            long expectedModelAdditionCount = expectedManifestSummary.getModelAdditionCount(manifestSummaryKey);
            StagedModelType stagedModelType = new StagedModelType(keyParts[0]);
            if (keyParts.length > 1) {
                stagedModelType = new StagedModelType(keyParts[0], keyParts[1]);
            }
            long modelAdditionCount = manifestSummary.getModelAdditionCount(stagedModelType);
            if (expectedModelAdditionCount == 0L) {
                Assert.assertFalse((modelAdditionCount > 0L ? 1 : 0) != 0);
                continue;
            }
            Assert.assertEquals((long)expectedModelAdditionCount, (long)modelAdditionCount);
        }
    }

    protected void checkManifestSummaryReferrerClassNames(ManifestSummary manifestSummary) {
        for (String manifestSummaryKey : manifestSummary.getManifestSummaryKeys()) {
            Assert.assertFalse((boolean)manifestSummaryKey.endsWith("referrer-class-name-all"));
            Assert.assertFalse((boolean)manifestSummaryKey.endsWith("referrer-class-name-any"));
        }
    }

    protected DataLevel getDataLevel() {
        return DataLevel.SITE;
    }

    protected String[] getDataPortletPreferences() {
        return StringPool.EMPTY_ARRAY;
    }

    protected Date getEndDate() {
        return new Date();
    }

    protected PortletDataHandlerControl[] getExportConfigurationControls(long companyId, long groupId, PortletDataHandlerControl[] portletDataHandlerControls, long plid, boolean privateLayout) {
        if (plid < 0L) {
            return new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(null, "PORTLET_SETUP", "setup", true, false, portletDataHandlerControls, null, null)};
        }
        return new PortletDataHandlerControl[0];
    }

    protected PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[0];
    }

    protected PortletDataHandlerControl[] getExportMetadataControls() {
        return new PortletDataHandlerControl[0];
    }

    protected long getExportModelCount() {
        List<StagedModel> stagedModels = this.getStagedModels();
        return stagedModels.size();
    }

    protected PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[0];
    }

    protected PortletDataHandlerControl[] getImportMetadataControls() {
        return new PortletDataHandlerControl[0];
    }

    protected PortletDataHandler getPortletDataHandler(String portletId) {
        try {
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            BundleContext bundleContext = bundle.getBundleContext();
            Collection portletDataHandlerReferences = bundleContext.getServiceReferences(PortletDataHandler.class, "(javax.portlet.name=" + portletId + ")");
            Iterator iterator = portletDataHandlerReferences.iterator();
            return (PortletDataHandler)bundleContext.getService((ServiceReference)iterator.next());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected abstract String getPortletId();

    protected String getSchemaVersion() {
        return "4.0.0";
    }

    protected List<StagedModel> getStagedModels() {
        return new ArrayList<StagedModel>();
    }

    protected PortletDataHandlerControl[] getStagingControls() {
        return new PortletDataHandlerControl[0];
    }

    protected Date getStartDate() {
        return new Date(System.currentTimeMillis() - 3600000L);
    }

    protected void initContext() throws Exception {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        this.addParameters(parameterMap);
        this.zipWriter = this._zipWriterFactory.getZipWriter();
        this.portletDataContext = this._portletDataContextFactory.createExportPortletDataContext(this.stagingGroup.getCompanyId(), this.stagingGroup.getGroupId(), parameterMap, this.getStartDate(), this.getEndDate(), this.zipWriter);
        this.rootElement = this._saxReader.createElement("root");
        this.portletDataContext.setExportDataRootElement(this.rootElement);
        this.missingReferencesElement = this._saxReader.createElement("missing-references");
        this.portletDataContext.setMissingReferencesElement(this.missingReferencesElement);
        this.portletDataContext.setPortletId(this.portletId);
    }

    protected boolean isDataPortalLevel() {
        DataLevel dataLevel = this.getDataLevel();
        return dataLevel.equals((Object)DataLevel.PORTAL);
    }

    protected boolean isDataPortletInstanceLevel() {
        DataLevel dataLevel = this.getDataLevel();
        return dataLevel.equals((Object)DataLevel.PORTLET_INSTANCE);
    }

    protected boolean isDataSiteLevel() {
        DataLevel dataLevel = this.getDataLevel();
        return dataLevel.equals((Object)DataLevel.SITE);
    }

    protected boolean isDeleteDataTested() {
        return false;
    }

    protected boolean isDisplayPortlet() {
        return this.isDataPortletInstanceLevel() && !ArrayUtil.isEmpty((Object[])this.portletDataHandler.getDataPortletPreferences());
    }

    protected boolean isExportImportDataTested() {
        return false;
    }

    protected boolean isGetExportConfigurationControlsTested() {
        return false;
    }

    protected boolean isGetExportModelCountTested() {
        return false;
    }

    protected void validateDefaultData(PortletPreferences portletPreferences) {
    }

    private void _assertControls(PortletDataHandlerControl[] expectedControls, PortletDataHandlerControl[] actualControls) {
        for (PortletDataHandlerControl expectedControl : expectedControls) {
            boolean contains = false;
            for (PortletDataHandlerControl actualControl : actualControls) {
                if (!Objects.equals(expectedControl.getControlName(), actualControl.getControlName()) || !Objects.equals(expectedControl.getControlLabel(), actualControl.getControlLabel()) || expectedControl.isDisabled() != actualControl.isDisabled()) continue;
                contains = true;
                break;
            }
            Assert.assertTrue((boolean)contains);
        }
    }
}

