/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.forms.apio.internal.architect.resource;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.content.space.apio.architect.identifier.ContentSpaceIdentifier;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureModel;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.forms.apio.architect.identifier.StructureIdentifier;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.service.ClassNameService;
import com.liferay.structure.apio.architect.util.StructureRepresentorBuilderHelper;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class FormStructureNestedCollectionResource
implements NestedCollectionResource<DDMStructure, Long, StructureIdentifier, Long, ContentSpaceIdentifier> {
    @Reference
    private ClassNameService _classNameService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private StructureRepresentorBuilderHelper _structureRepresentorBuilderHelper;

    public NestedCollectionRoutes<DDMStructure, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<DDMStructure, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems).build();
    }

    public String getName() {
        return "form-structures";
    }

    public ItemRoutes<DDMStructure, Long> itemRoutes(ItemRoutes.Builder<DDMStructure, Long> builder) {
        return builder.addGetter(this::_getItem).build();
    }

    public Representor<DDMStructure> representor(Representor.Builder<DDMStructure, Long> builder) {
        Representor.FirstStep ddmStructureFirstStep = this._structureRepresentorBuilderHelper.buildDDMStructureFirstStep(builder);
        Representor.FirstStep bidirectionalModelStep = ddmStructureFirstStep.addBidirectionalModel("interactionService", "formStructures", ContentSpaceIdentifier.class, DDMStructureModel::getGroupId);
        return (Representor)bidirectionalModelStep.build();
    }

    private DDMStructure _getItem(Long structureId) throws PortalException {
        return this._ddmStructureLocalService.getStructure(structureId.longValue());
    }

    private PageItems<DDMStructure> _getPageItems(Pagination pagination, Long groupId) {
        ClassName className = this._classNameService.fetchClassName(DDLRecordSet.class.getName());
        Long classNameId = className.getClassNameId();
        List ddmStructures = this._ddmStructureLocalService.getStructures(groupId.longValue(), classNameId.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int count = this._ddmStructureLocalService.getStructuresCount(groupId.longValue(), classNameId.longValue());
        return new PageItems((Collection)ddmStructures, count);
    }
}

