/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.forms.apio.internal.helper;

import com.google.gson.Gson;
import com.liferay.apio.architect.functional.Try;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.forms.apio.internal.model.FileEntryValue;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UploadFileHelper.class})
public class UploadFileHelper {
    @Reference
    private DLAppService _dlAppService;

    public void linkFiles(List<DDMFormField> ddmFormFields, List<DDMFormFieldValue> ddmFormFieldValues) {
        Stream ddmFormFieldsStream = ddmFormFields.stream();
        ddmFormFieldsStream.filter(formField -> formField.getType().equals("document_library")).map(field -> this._findField((DDMFormField)field, ddmFormFieldValues)).forEach(optional -> optional.ifPresent(this::_setFileEntryAsFormFieldValue));
    }

    private Long _extractFileEntryId(DDMFormFieldValue ddmFormFieldValue) {
        return (Long)Try.fromFallible(() -> ddmFormFieldValue.getValue()).map(Value::getValues).map(Map::values).map(Collection::stream).mapOptional(Stream::findFirst).map(fileEntryUrl -> fileEntryUrl.substring(fileEntryUrl.lastIndexOf("/") + 1)).map(Long::valueOf).orElse(null);
    }

    private Optional<DDMFormFieldValue> _findField(DDMFormField formField, List<DDMFormFieldValue> ddmFormFieldValues) {
        Stream ddmFormFieldValuesStream = ddmFormFieldValues.stream();
        return ddmFormFieldValuesStream.filter(value -> value.getName().equals(formField.getName())).findFirst();
    }

    private void _setFileEntryAsFormFieldValue(DDMFormFieldValue ddmFormFieldValue) {
        Gson gson = new Gson();
        Try.fromFallible(() -> this._extractFileEntryId(ddmFormFieldValue)).map(arg_0 -> ((DLAppService)this._dlAppService).getFileEntry(arg_0)).map(fileEntry -> new FileEntryValue(fileEntry.getGroupId(), fileEntry.getUuid())).map(arg_0 -> ((Gson)gson).toJson(arg_0)).map(UnlocalizedValue::new).ifSuccess(arg_0 -> ((DDMFormFieldValue)ddmFormFieldValue).setValue(arg_0));
    }
}

