/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.forms.apio.internal.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.forms.apio.internal.model.FormFieldValue;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public final class FormValuesUtil {
    private static final Value _EMPTY_VALUE = new UnlocalizedValue((String)null);

    public static DDMFormValues getDDMFormValues(String fieldValues, DDMForm ddmForm, Locale locale) {
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        FormFieldValueListToken formFieldValueListToken = new FormFieldValueListToken();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        Type listType = formFieldValueListToken.getType();
        Gson gson = new Gson();
        List formFieldValues = (List)gson.fromJson(fieldValues, listType);
        for (FormFieldValue formFieldValue : formFieldValues) {
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
            ddmFormFieldValue.setName(formFieldValue.name);
            DDMFormField ddmFormField = (DDMFormField)ddmFormFieldsMap.get(formFieldValue.name);
            Value value = _EMPTY_VALUE;
            if (ddmFormField != null && !ddmFormField.isTransient()) {
                value = Optional.ofNullable(formFieldValue.value).map(JsonElement::toString).map(stringValue -> FormValuesUtil._getValue(stringValue, ddmFormField, locale)).orElse(_EMPTY_VALUE);
            }
            FormValuesUtil._setFieldValue(value, ddmFormValues, ddmFormFieldValue);
        }
        return ddmFormValues;
    }

    private static Value _getValue(String stringValue, DDMFormField ddmFormField, Locale locale) {
        LocalizedValue value;
        if (ddmFormField.isLocalizable()) {
            value = new LocalizedValue();
            value.addString(locale, stringValue);
        } else {
            value = new UnlocalizedValue(stringValue);
        }
        return value;
    }

    private static void _setFieldValue(Value value, DDMFormValues ddmFormValues, DDMFormFieldValue ddmFormFieldValue) {
        ddmFormFieldValue.setValue(value);
        ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
    }

    private static class FormFieldValueListToken
    extends TypeToken<ArrayList<FormFieldValue>> {
        private FormFieldValueListToken() {
        }
    }
}

