/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.forms.apio.internal.model;

import com.liferay.apio.architect.functional.Try;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BaseFormContextWrapper {
    private final Map<String, Object> _wrappedMap;

    public BaseFormContextWrapper(Map<String, Object> wrappedMap) {
        this._wrappedMap = wrappedMap;
    }

    public <T extends BaseFormContextWrapper> List<T> getListFromMap(Map<String, Object> map, String key, Function<Map<String, Object>, T> parseItemFunction) {
        return ((Stream)Try.fromFallible(() -> (List)map.get(key)).map(Collection::stream).orElseGet(Stream::empty)).map(parseItemFunction).collect(Collectors.toList());
    }

    public <T> T getValue(String key, Class<T> type) {
        return this.getValueOrDefault(key, type::cast, null);
    }

    public <T> T getValue(String key, Function<Object, T> parseFunction) {
        return this.getValueOrDefault(key, parseFunction, null);
    }

    public <T> T getValueOrDefault(String key, Class<T> type, T defaultValue) {
        return (T)this.getValueOrDefault(key, type::cast, defaultValue);
    }

    public <T> T getValueOrDefault(String key, Function<Object, T> parseFunction, T defaultValue) {
        return Optional.ofNullable(this._wrappedMap.get(key)).map(parseFunction).orElse(defaultValue);
    }

    public <T extends BaseFormContextWrapper> List<T> getWrappedList(String key, Function<Map<String, Object>, T> parseItemFunction) {
        return this.getListFromMap(this._wrappedMap, key, parseItemFunction);
    }

    public Map<String, Object> getWrappedMap() {
        return this._wrappedMap;
    }
}

