/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.drop.zone.listener;

import com.liferay.fragment.listener.FragmentEntryLinkListener;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.DefaultFragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.structure.DeletedLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentEntryLinkListener.class})
public class DropZoneFragmentEntryLinkListener
implements FragmentEntryLinkListener {
    private static final Log _log = LogFactoryUtil.getLog(DropZoneFragmentEntryLinkListener.class);
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;

    public void onAddFragmentEntryLink(FragmentEntryLink fragmentEntryLink) {
        block2: {
            try {
                this._updateLayoutPageTemplateStructure(fragmentEntryLink);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)"Unable to update layout page template structure", (Throwable)exception);
            }
        }
    }

    public void onDeleteFragmentEntryLink(FragmentEntryLink fragmentEntryLink) {
    }

    public void onUpdateFragmentEntryLink(FragmentEntryLink fragmentEntryLink) {
    }

    public void onUpdateFragmentEntryLinkConfigurationValues(FragmentEntryLink fragmentEntryLink) {
        block2: {
            try {
                this._updateLayoutPageTemplateStructure(fragmentEntryLink);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)"Unable to update layout page template structure", (Throwable)exception);
            }
        }
    }

    private void _addOrRestoreDropZoneLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItem parentLayoutStructureItem) {
        LayoutStructureItem existingLayoutStructureItem = null;
        List deletedLayoutStructureItems = layoutStructure.getDeletedLayoutStructureItems();
        for (DeletedLayoutStructureItem deletedLayoutStructureItem : deletedLayoutStructureItems) {
            LayoutStructureItem layoutStructureItem = layoutStructure.getLayoutStructureItem(deletedLayoutStructureItem.getItemId());
            if (!Objects.equals(layoutStructureItem.getParentItemId(), parentLayoutStructureItem.getItemId())) continue;
            existingLayoutStructureItem = layoutStructureItem;
            break;
        }
        if (existingLayoutStructureItem != null) {
            layoutStructure.unmarkLayoutStructureItemForDeletion(existingLayoutStructureItem.getItemId());
        } else {
            layoutStructure.addFragmentDropZoneLayoutStructureItem(parentLayoutStructureItem.getItemId(), -1);
        }
    }

    private Document _getDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }

    private LayoutStructure _getLayoutStructure(FragmentEntryLink fragmentEntryLink) {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(fragmentEntryLink.getGroupId(), fragmentEntryLink.getPlid());
        if (layoutPageTemplateStructure == null) {
            return null;
        }
        String data = layoutPageTemplateStructure.getData(fragmentEntryLink.getSegmentsExperienceId());
        if (Validator.isNull((String)data)) {
            return null;
        }
        return LayoutStructure.of((String)data);
    }

    private void _updateLayoutPageTemplateStructure(FragmentEntryLink fragmentEntryLink) throws PortalException {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        String processedHTML = this._fragmentEntryProcessorRegistry.processFragmentEntryLinkHTML(fragmentEntryLink, (FragmentEntryProcessorContext)new DefaultFragmentEntryProcessorContext(serviceContext.getRequest(), serviceContext.getResponse(), "EDIT", serviceContext.getLocale()));
        Document document = this._getDocument(processedHTML);
        Elements elements = document.select("lfr-drop-zone");
        if (elements.size() <= 0) {
            return;
        }
        LayoutStructure layoutStructure = this._getLayoutStructure(fragmentEntryLink);
        if (layoutStructure == null) {
            return;
        }
        LayoutStructureItem parentLayoutStructureItem = layoutStructure.getLayoutStructureItemByFragmentEntryLinkId(fragmentEntryLink.getFragmentEntryLinkId());
        if (parentLayoutStructureItem == null) {
            return;
        }
        List childrenItemIds = parentLayoutStructureItem.getChildrenItemIds();
        if (childrenItemIds.size() == elements.size()) {
            return;
        }
        if (childrenItemIds.size() > elements.size()) {
            List childrenItemIdsToRemove = childrenItemIds.subList(elements.size(), childrenItemIds.size());
            childrenItemIdsToRemove.forEach(itemId -> layoutStructure.markLayoutStructureItemForDeletion(itemId, Collections.emptyList()));
        } else {
            for (int i = childrenItemIds.size(); i < elements.size(); ++i) {
                this._addOrRestoreDropZoneLayoutStructureItem(layoutStructure, parentLayoutStructureItem);
            }
        }
        this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(fragmentEntryLink.getGroupId(), fragmentEntryLink.getPlid(), fragmentEntryLink.getSegmentsExperienceId(), layoutStructure.toString());
    }
}

