/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.freemarker;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.fragment.entry.processor.freemarker.internal.configuration.FreeMarkerFragmentEntryProcessorConfiguration;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.helper.FragmentEntryLinkHelper;
import com.liferay.fragment.input.template.parser.FragmentEntryInputTemplateNodeContextHelper;
import com.liferay.fragment.input.template.parser.InputTemplateNode;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.item.selector.ItemSelector;
import com.liferay.petra.io.DummyWriter;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.servlet.DummyHttpServletResponse;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Writer;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fragment.entry.processor.priority:Integer=1"}, service={FragmentEntryProcessor.class})
public class FreeMarkerFragmentEntryProcessor
implements FragmentEntryProcessor {
    private static final Log _log = LogFactoryUtil.getLog(FreeMarkerFragmentEntryProcessor.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private FragmentEntryLinkHelper _fragmentEntryLinkHelper;
    @Reference
    private ItemSelector _itemSelector;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public JSONObject getDefaultEditableValuesJSONObject(String html, String configuration) {
        return this._fragmentEntryConfigurationParser.getConfigurationDefaultValuesJSONObject(configuration);
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        if (Validator.isNull((String)html)) {
            return html;
        }
        FreeMarkerFragmentEntryProcessorConfiguration freeMarkerFragmentEntryProcessorConfiguration = (FreeMarkerFragmentEntryProcessorConfiguration)this._configurationProvider.getCompanyConfiguration(FreeMarkerFragmentEntryProcessorConfiguration.class, fragmentEntryLink.getCompanyId());
        if (!freeMarkerFragmentEntryProcessorConfiguration.enable() && Validator.isNull((String)fragmentEntryLink.getRendererKey()) && !fragmentEntryLink.isSystem()) {
            return html;
        }
        if (fragmentEntryProcessorContext.getHttpServletRequest() == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"HTTP servlet request is not set in the fragment entry processor context");
            }
            return html;
        }
        if (fragmentEntryProcessorContext.getHttpServletResponse() == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"HTTP servlet response is not set in the fragment entry processor context");
            }
            return html;
        }
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new StringTemplateResource("template_id", "[#ftl] " + html), (boolean)true);
        template.put((Object)"writer", (Object)unsyncStringWriter);
        JSONObject configurationValuesJSONObject = this._fragmentEntryConfigurationParser.getConfigurationJSONObject(fragmentEntryLink.getConfiguration(), fragmentEntryLink.getEditableValues(), fragmentEntryProcessorContext.getLocale());
        template.putAll((Map)HashMapBuilder.put((Object)"configuration", (Object)configurationValuesJSONObject).put((Object)"fragmentElementId", (Object)fragmentEntryProcessorContext.getFragmentElementId()).put((Object)"fragmentEntryLinkNamespace", (Object)fragmentEntryLink.getNamespace()).put((Object)"layoutMode", (Object)this._getLayoutMode(fragmentEntryProcessorContext.getHttpServletRequest())).putAll(this._fragmentEntryConfigurationParser.getContextObjects(configurationValuesJSONObject, fragmentEntryLink.getConfiguration(), fragmentEntryProcessorContext.getSegmentsEntryIds())).build());
        if (fragmentEntryLink.isTypeInput()) {
            FragmentEntryInputTemplateNodeContextHelper fragmentEntryInputTemplateNodeContextHelper = new FragmentEntryInputTemplateNodeContextHelper(this._fragmentEntryLinkHelper.getFragmentEntryName(fragmentEntryLink, fragmentEntryProcessorContext.getLocale()), this._dlAppLocalService, this._fragmentEntryConfigurationParser, this._itemSelector);
            template.put((Object)"input", (Object)fragmentEntryInputTemplateNodeContextHelper.toInputTemplateNode(fragmentEntryLink, fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getInfoFormOptional(), fragmentEntryProcessorContext.getLocale()));
        }
        template.prepareTaglib(fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse());
        template.prepare(fragmentEntryProcessorContext.getHttpServletRequest());
        try {
            template.processTemplate((Writer)unsyncStringWriter);
        }
        catch (TemplateException templateException) {
            throw new FragmentEntryContentException(this._getMessage(templateException), (Throwable)templateException);
        }
        return unsyncStringWriter.toString();
    }

    public void validateFragmentEntryHTML(String html, String configuration) throws PortalException {
        FreeMarkerFragmentEntryProcessorConfiguration freeMarkerFragmentEntryProcessorConfiguration = (FreeMarkerFragmentEntryProcessorConfiguration)this._configurationProvider.getCompanyConfiguration(FreeMarkerFragmentEntryProcessorConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
        if (!freeMarkerFragmentEntryProcessorConfiguration.enable() || !this._isFreemarkerTemplate(html)) {
            return;
        }
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new StringTemplateResource("template_id", "[#ftl] " + html), (boolean)true);
        try {
            HttpServletRequest httpServletRequest = null;
            HttpServletResponse httpServletResponse = null;
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            if (serviceContext != null) {
                httpServletRequest = serviceContext.getRequest();
                httpServletResponse = serviceContext.getResponse();
            }
            if (httpServletResponse == null) {
                httpServletResponse = new DummyHttpServletResponse();
            }
            if (httpServletRequest != null && httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY") != null) {
                JSONObject configurationDefaultValuesJSONObject = this._fragmentEntryConfigurationParser.getConfigurationDefaultValuesJSONObject(configuration);
                template.putAll((Map)HashMapBuilder.put((Object)"configuration", (Object)configurationDefaultValuesJSONObject).put((Object)"fragmentElementId", (Object)"").put((Object)"fragmentEntryLinkNamespace", (Object)"").put((Object)"input", (Object)new InputTemplateNode("", "", "", "name", false, false, false, "type", "value")).put((Object)"layoutMode", (Object)"view").putAll(this._fragmentEntryConfigurationParser.getContextObjects(configurationDefaultValuesJSONObject, configuration, new long[0])).build());
                template.prepareTaglib(httpServletRequest, httpServletResponse);
                template.prepare(httpServletRequest);
                template.processTemplate((Writer)new DummyWriter());
            }
        }
        catch (TemplateException templateException) {
            throw new FragmentEntryContentException(this._getMessage(templateException), (Throwable)templateException);
        }
    }

    private String _getLayoutMode(HttpServletRequest httpServletRequest) {
        return ParamUtil.getString((HttpServletRequest)this._portal.getOriginalServletRequest(httpServletRequest), (String)"p_l_mode", (String)"view");
    }

    private String _getMessage(TemplateException templateException) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
        String message = this._language.get(resourceBundle, "freemarker-syntax-is-invalid");
        Throwable causeThrowable = templateException.getCause();
        String causeThrowableMessage = causeThrowable.getLocalizedMessage();
        if (Validator.isNotNull((String)causeThrowableMessage)) {
            message = message + "\n\n" + causeThrowableMessage;
        }
        return message;
    }

    private boolean _isFreemarkerTemplate(String html) {
        return html.contains("${") || html.contains("<#") || html.contains("<@");
    }
}

