/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.freemarker;

import com.liferay.fragment.entry.processor.freemarker.internal.configuration.FreeMarkerFragmentEntryProcessorConfiguration;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.servlet.DummyHttpServletResponse;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Writer;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fragment.entry.processor.priority:Integer=1"}, service={FragmentEntryProcessor.class})
public class FreeMarkerFragmentEntryProcessor
implements FragmentEntryProcessor {
    private static final Log _log = LogFactoryUtil.getLog(FreeMarkerFragmentEntryProcessor.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;

    public JSONObject getDefaultEditableValuesJSONObject(String html, String configuration) {
        return this._fragmentEntryConfigurationParser.getConfigurationDefaultValuesJSONObject(configuration);
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        FreeMarkerFragmentEntryProcessorConfiguration freeMarkerFragmentEntryProcessorConfiguration = (FreeMarkerFragmentEntryProcessorConfiguration)this._configurationProvider.getCompanyConfiguration(FreeMarkerFragmentEntryProcessorConfiguration.class, fragmentEntryLink.getCompanyId());
        if (!freeMarkerFragmentEntryProcessorConfiguration.enable() && Validator.isNull((String)fragmentEntryLink.getRendererKey()) && !fragmentEntryLink.isSystem()) {
            return html;
        }
        if (fragmentEntryProcessorContext.getHttpServletRequest() == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"HTTP servlet request is not set in the fragment entry processor context");
            }
            return html;
        }
        if (fragmentEntryProcessorContext.getHttpServletResponse() == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"HTTP servlet response is not set in the fragment entry processor context");
            }
            return html;
        }
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new StringTemplateResource("template_id", "[#ftl] " + html), (boolean)true);
        template.put((Object)"writer", (Object)unsyncStringWriter);
        JSONObject configurationValuesJSONObject = this._fragmentEntryConfigurationParser.getConfigurationJSONObject(fragmentEntryLink.getConfiguration(), fragmentEntryLink.getEditableValues(), fragmentEntryProcessorContext.getLocale());
        String fragmentEntryLinkNamespace = this._getFragmentEntryLinkNamespace(fragmentEntryLink);
        template.putAll((Map)HashMapBuilder.put((Object)"configuration", (Object)configurationValuesJSONObject).put((Object)"fragmentElementId", () -> {
            StringBundler sb = new StringBundler(4);
            sb.append("fragment-");
            sb.append(fragmentEntryLink.getFragmentEntryId());
            sb.append("-");
            sb.append(fragmentEntryLinkNamespace);
            return sb.toString();
        }).put((Object)"fragmentEntryLinkNamespace", (Object)fragmentEntryLinkNamespace).putAll(this._fragmentEntryConfigurationParser.getContextObjects(configurationValuesJSONObject, fragmentEntryLink.getConfiguration())).build());
        template.prepareTaglib(fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse());
        template.prepare(fragmentEntryProcessorContext.getHttpServletRequest());
        try {
            template.processTemplate((Writer)unsyncStringWriter);
        }
        catch (TemplateException templateException) {
            throw new FragmentEntryContentException(this._getMessage(templateException), (Throwable)templateException);
        }
        return unsyncStringWriter.toString();
    }

    public void validateFragmentEntryHTML(String html, String configuration) throws PortalException {
        FreeMarkerFragmentEntryProcessorConfiguration freeMarkerFragmentEntryProcessorConfiguration = (FreeMarkerFragmentEntryProcessorConfiguration)this._configurationProvider.getCompanyConfiguration(FreeMarkerFragmentEntryProcessorConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
        if (!freeMarkerFragmentEntryProcessorConfiguration.enable()) {
            return;
        }
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new StringTemplateResource("template_id", "[#ftl] " + html), (boolean)true);
        try {
            HttpServletRequest httpServletRequest = null;
            HttpServletResponse httpServletResponse = null;
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            if (serviceContext != null) {
                httpServletRequest = serviceContext.getRequest();
                httpServletResponse = serviceContext.getResponse();
            }
            if (httpServletResponse == null) {
                httpServletResponse = new DummyHttpServletResponse();
            }
            if (httpServletRequest != null && httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY") != null) {
                JSONObject configurationDefaultValuesJSONObject = this._fragmentEntryConfigurationParser.getConfigurationDefaultValuesJSONObject(configuration);
                template.putAll((Map)HashMapBuilder.put((Object)"configuration", (Object)configurationDefaultValuesJSONObject).put((Object)"fragmentElementId", (Object)"").put((Object)"fragmentEntryLinkNamespace", (Object)"").putAll(this._fragmentEntryConfigurationParser.getContextObjects(configurationDefaultValuesJSONObject, configuration)).build());
                template.prepareTaglib(httpServletRequest, httpServletResponse);
                template.prepare(httpServletRequest);
                template.processTemplate((Writer)new UnsyncStringWriter());
            }
        }
        catch (TemplateException templateException) {
            throw new FragmentEntryContentException(this._getMessage(templateException), (Throwable)templateException);
        }
    }

    private String _getFragmentEntryLinkNamespace(FragmentEntryLink fragmentEntryLink) {
        FragmentEntryLink originalFragmentEntryLink = this._getOriginalFragmentEntryLink(fragmentEntryLink);
        return originalFragmentEntryLink.getNamespace();
    }

    private String _getMessage(TemplateException templateException) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
        String message = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"freemarker-syntax-is-invalid");
        Throwable causeThrowable = templateException.getCause();
        String causeThrowableMessage = causeThrowable.getLocalizedMessage();
        if (Validator.isNotNull((String)causeThrowableMessage)) {
            message = message + "\n\n" + causeThrowableMessage;
        }
        return message;
    }

    private FragmentEntryLink _getOriginalFragmentEntryLink(FragmentEntryLink fragmentEntryLink) {
        if (fragmentEntryLink.getOriginalFragmentEntryLinkId() <= 0L) {
            return fragmentEntryLink;
        }
        return Optional.ofNullable(this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(fragmentEntryLink.getOriginalFragmentEntryLinkId())).filter(originalFragmentEntryLink -> this._isRelated(this._layoutLocalService.fetchLayout(fragmentEntryLink.getPlid()), originalFragmentEntryLink.getPlid())).map(this::_getOriginalFragmentEntryLink).orElse(fragmentEntryLink);
    }

    private boolean _isRelated(Layout layout, long plid) {
        if (layout == null) {
            return false;
        }
        if (layout.getClassPK() == plid || layout.getPlid() == plid) {
            return true;
        }
        Layout draftLayout = layout.fetchDraftLayout();
        return draftLayout != null && draftLayout.getPlid() == plid;
    }
}

