/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.internal.util;

import com.liferay.asset.info.display.contributor.util.ContentAccessor;
import com.liferay.asset.info.display.contributor.util.ContentAccessorUtil;
import com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper;
import com.liferay.fragment.entry.processor.internal.util.CommaSeparatedInfoCollectionTextFormatter;
import com.liferay.fragment.processor.DefaultFragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.formatter.InfoCollectionTextFormatter;
import com.liferay.info.formatter.InfoTextFormatter;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.info.type.Labeled;
import com.liferay.info.type.WebImage;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FragmentEntryProcessorHelper.class})
public class FragmentEntryProcessorHelperImpl
implements FragmentEntryProcessorHelper {
    private static final InfoCollectionTextFormatter<Object> _INFO_COLLECTION_TEXT_FORMATTER = new CommaSeparatedInfoCollectionTextFormatter();
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryProcessorHelperImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public String formatMappedValue(Object fieldValue, Locale locale) {
        String formattedFieldValue;
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof Collection) {
            Collection collection = (Collection)fieldValue;
            if (collection.isEmpty()) {
                return "";
            }
            Iterator iterator = collection.iterator();
            Object firstItem = iterator.next();
            Class<?> firstItemClass = firstItem.getClass();
            String itemClassName = firstItemClass.getName();
            InfoCollectionTextFormatter<Object> infoCollectionTextFormatter = this._getInfoCollectionTextFormatter(itemClassName);
            formattedFieldValue = infoCollectionTextFormatter.format(collection, locale);
        } else if (fieldValue instanceof String) {
            formattedFieldValue = (String)fieldValue;
        } else if (fieldValue instanceof Labeled) {
            Labeled labeledFieldValue = (Labeled)fieldValue;
            formattedFieldValue = labeledFieldValue.getLabel(locale);
        } else {
            Class<?> fieldValueClass = fieldValue.getClass();
            String itemClassName = fieldValueClass.getName();
            InfoTextFormatter infoTextFormatter = (InfoTextFormatter)this._infoItemServiceTracker.getFirstInfoItemService(InfoTextFormatter.class, itemClassName);
            formattedFieldValue = infoTextFormatter == null ? fieldValue.toString() : infoTextFormatter.format(fieldValue, locale);
        }
        return formattedFieldValue;
    }

    public String getEditableValue(JSONObject jsonObject, Locale locale) {
        return this._getEditableValueByLocale(jsonObject, locale);
    }

    @Deprecated
    public String getEditableValue(JSONObject jsonObject, Locale locale, long[] segmentsExperienceIds) {
        return this._getEditableValueByLocale(jsonObject, locale);
    }

    public long getFileEntryId(long classNameId, long classPK, String fieldId, Locale locale) throws PortalException {
        if (classNameId == 0L) {
            return 0L;
        }
        ClassPKInfoItemIdentifier infoItemIdentifier = new ClassPKInfoItemIdentifier(classPK);
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemObjectProvider.class, this._portal.getClassName(classNameId), infoItemIdentifier.getInfoItemServiceFilter());
        if (infoItemObjectProvider == null) {
            return 0L;
        }
        Object object = infoItemObjectProvider.getInfoItem((InfoItemIdentifier)infoItemIdentifier);
        if (object == null) {
            return 0L;
        }
        return this._getFileEntryId(this._portal.getClassName(classNameId), object, fieldId, locale);
    }

    public long getFileEntryId(Object displayObject, String fieldId, Locale locale) {
        if (Validator.isNull((String)fieldId) || !(displayObject instanceof ClassedModel)) {
            return 0L;
        }
        ClassedModel classedModel = (ClassedModel)displayObject;
        return this._getFileEntryId(classedModel.getModelClassName(), displayObject, fieldId, locale);
    }

    public long getFileEntryId(String className, long classPK) {
        if (!Objects.equals(className, FileEntry.class.getName())) {
            return 0L;
        }
        return classPK;
    }

    public long getFileEntryId(WebImage webImage) {
        InfoItemReference infoItemReference = webImage.getInfoItemReference();
        if (infoItemReference == null || !Objects.equals(infoItemReference.getClassName(), FileEntry.class.getName())) {
            return 0L;
        }
        InfoItemIdentifier fileEntryInfoItemIdentifier = infoItemReference.getInfoItemIdentifier();
        if (!(fileEntryInfoItemIdentifier instanceof ClassPKInfoItemIdentifier)) {
            return 0L;
        }
        ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)fileEntryInfoItemIdentifier;
        return classPKInfoItemIdentifier.getClassPK();
    }

    public Object getMappedCollectionValue(JSONObject jsonObject, FragmentEntryProcessorContext fragmentEntryProcessorContext) {
        InfoItemFieldValuesProvider infoItemFieldValuesProvider;
        if (!this.isMappedCollection(jsonObject)) {
            return JSONFactoryUtil.createJSONObject();
        }
        Optional displayObjectOptional = fragmentEntryProcessorContext.getDisplayObjectOptional();
        if (!displayObjectOptional.isPresent()) {
            return null;
        }
        Object displayObject = displayObjectOptional.get();
        if (!(displayObject instanceof ClassedModel)) {
            return null;
        }
        ClassedModel classedModel = (ClassedModel)displayObject;
        String className = classedModel.getModelClassName();
        if (classedModel instanceof FileEntry) {
            className = FileEntry.class.getName();
        }
        if ((infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemFieldValuesProvider.class, className)) == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get info item form provider for class " + className));
            }
            return null;
        }
        InfoFieldValue infoFieldValue = infoItemFieldValuesProvider.getInfoFieldValue(displayObjectOptional.get(), jsonObject.getString("collectionFieldId"));
        if (infoFieldValue == null) {
            return null;
        }
        Object value = infoFieldValue.getValue(fragmentEntryProcessorContext.getLocale());
        if (value instanceof ContentAccessor) {
            ContentAccessor contentAccessor = (ContentAccessor)infoFieldValue;
            value = contentAccessor.getContent();
        } else if (value instanceof WebImage) {
            WebImage webImage = (WebImage)value;
            return webImage.toJSONObject();
        }
        return this.formatMappedValue(value, fragmentEntryProcessorContext.getLocale());
    }

    public Object getMappedInfoItemFieldValue(JSONObject jsonObject, Map<Long, InfoItemFieldValues> infoItemFieldValuesMap, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        String fieldId;
        InfoFieldValue infoFieldValue;
        Object object;
        long classPK;
        ClassPKInfoItemIdentifier infoItemIdentifier;
        if (!this.isMapped(jsonObject) && !this.isAssetDisplayPage(fragmentEntryProcessorContext.getMode())) {
            return JSONFactoryUtil.createJSONObject();
        }
        long classNameId = jsonObject.getLong("classNameId");
        String className = this._portal.getClassName(classNameId);
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemObjectProvider.class, className, (infoItemIdentifier = new ClassPKInfoItemIdentifier(classPK = jsonObject.getLong("classPK"))).getInfoItemServiceFilter());
        if (infoItemObjectProvider == null) {
            return null;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        if (trashHandler != null && trashHandler.isInTrash(classPK)) {
            return null;
        }
        if (fragmentEntryProcessorContext.getPreviewClassPK() > 0L) {
            infoItemIdentifier = new ClassPKInfoItemIdentifier(fragmentEntryProcessorContext.getPreviewClassPK());
            if (Validator.isNotNull((String)fragmentEntryProcessorContext.getPreviewVersion())) {
                infoItemIdentifier.setVersion(fragmentEntryProcessorContext.getPreviewVersion());
            }
        }
        if ((object = infoItemObjectProvider.getInfoItem((InfoItemIdentifier)infoItemIdentifier)) == null) {
            return null;
        }
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemFieldValuesProvider.class, className);
        if (infoItemFieldValuesProvider == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get info item form provider for class " + className));
            }
            return null;
        }
        InfoItemFieldValues infoItemFieldValues = infoItemFieldValuesMap.get(classPK);
        if (infoItemFieldValues == null) {
            infoItemFieldValues = infoItemFieldValuesProvider.getInfoItemFieldValues(object);
            infoItemFieldValuesMap.put(classPK, infoItemFieldValues);
        }
        if ((infoFieldValue = infoItemFieldValues.getInfoFieldValue(fieldId = jsonObject.getString("fieldId"))) == null) {
            return null;
        }
        Object fieldValue = infoFieldValue.getValue(fragmentEntryProcessorContext.getLocale());
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof ContentAccessor) {
            ContentAccessor contentAccessor = (ContentAccessor)fieldValue;
            fieldValue = contentAccessor.getContent();
        }
        if (fieldValue instanceof WebImage) {
            WebImage webImage = (WebImage)fieldValue;
            fieldValue = webImage.toJSONObject();
        } else {
            fieldValue = this.formatMappedValue(fieldValue, fragmentEntryProcessorContext.getLocale());
        }
        return fieldValue;
    }

    public Object getMappedInfoItemFieldValue(JSONObject jsonObject, Map<Long, InfoItemFieldValues> infoDisplaysFieldValues, String mode, Locale locale, long previewClassPK, long previewClassNameId, int previewType) throws PortalException {
        DefaultFragmentEntryProcessorContext defaultFragmentEntryProcessorContext = new DefaultFragmentEntryProcessorContext(null, null, mode, locale);
        defaultFragmentEntryProcessorContext.setPreviewClassNameId(previewClassNameId);
        defaultFragmentEntryProcessorContext.setPreviewClassPK(previewClassPK);
        defaultFragmentEntryProcessorContext.setPreviewType(previewType);
        return this.getMappedInfoItemFieldValue(jsonObject, infoDisplaysFieldValues, (FragmentEntryProcessorContext)defaultFragmentEntryProcessorContext);
    }

    public Object getMappedLayoutValue(JSONObject jsonObject, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        if (!this.isMappedLayout(jsonObject)) {
            return "";
        }
        HttpServletRequest httpServletRequest = fragmentEntryProcessorContext.getHttpServletRequest();
        if (httpServletRequest == null) {
            return "";
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay == null) {
            return "";
        }
        JSONObject layoutJSONObject = jsonObject.getJSONObject("layout");
        long groupId = layoutJSONObject.getLong("groupId");
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return "#";
        }
        Layout layout = this._layoutLocalService.fetchLayout(groupId, layoutJSONObject.getBoolean("privateLayout"), layoutJSONObject.getLong("layoutId"));
        if (layout == null) {
            return "#";
        }
        return this._portal.getLayoutFullURL(layout, themeDisplay);
    }

    @Deprecated
    public Object getMappedValue(JSONObject jsonObject, Map<Long, Map<String, Object>> infoDisplaysFieldValues, FragmentEntryProcessorContext fragmentEntryProcessorContext) {
        throw new UnsupportedOperationException("This method is deprecated and replaced by com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper.getMappedInfoItemFieldValue");
    }

    @Deprecated
    public Object getMappedValue(JSONObject jsonObject, Map<Long, Map<String, Object>> infoDisplaysFieldValues, String mode, Locale locale, long previewClassPK, long previewClassNameId, int previewType) {
        throw new UnsupportedOperationException("This method is deprecated and replaced by com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper.getMappedInfoItemFieldValue");
    }

    public boolean isAssetDisplayPage(String mode) {
        return Objects.equals(mode, "ASSET_DISPLAY_PAGE");
    }

    public boolean isMapped(JSONObject jsonObject) {
        long classNameId = jsonObject.getLong("classNameId");
        long classPK = jsonObject.getLong("classPK");
        String fieldId = jsonObject.getString("fieldId");
        return classNameId > 0L && classPK > 0L && Validator.isNotNull((String)fieldId);
    }

    public boolean isMappedCollection(JSONObject jsonObject) {
        return jsonObject.has("collectionFieldId");
    }

    public boolean isMappedLayout(JSONObject jsonObject) {
        return jsonObject.has("layout");
    }

    public String processTemplate(String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new StringTemplateResource("template_id", "[#ftl] " + html), (boolean)true);
        template.prepareTaglib(fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse());
        template.put((Object)"writer", (Object)unsyncStringWriter);
        template.put((Object)"contentAccessorUtil", (Object)ContentAccessorUtil.getInstance());
        Optional fieldValuesOptional = fragmentEntryProcessorContext.getFieldValuesOptional();
        if (fieldValuesOptional.isPresent() && MapUtil.isNotEmpty((Map)((Map)fieldValuesOptional.get()))) {
            template.putAll((Map)fieldValuesOptional.get());
        }
        template.prepare(fragmentEntryProcessorContext.getHttpServletRequest());
        template.processTemplate((Writer)unsyncStringWriter);
        return unsyncStringWriter.toString();
    }

    private String _getEditableValueByLocale(JSONObject jsonObject, Locale locale) {
        String value = jsonObject.getString(LanguageUtil.getLanguageId((Locale)locale), null);
        if (value != null) {
            return value;
        }
        value = jsonObject.getString(LanguageUtil.getLanguageId((Locale)LocaleUtil.getSiteDefault()));
        if (Validator.isNull((String)value)) {
            value = jsonObject.getString("defaultValue");
        }
        return value;
    }

    private long _getFileEntryId(String className, Object displayObject, String fieldId, Locale locale) {
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemFieldValuesProvider.class, className);
        if (infoItemFieldValuesProvider == null) {
            return 0L;
        }
        InfoFieldValue infoFieldValue = infoItemFieldValuesProvider.getInfoFieldValue(displayObject, fieldId);
        Object value = "";
        if (infoFieldValue != null) {
            value = infoFieldValue.getValue(locale);
        }
        if (!(value instanceof WebImage)) {
            return 0L;
        }
        WebImage webImage = (WebImage)value;
        return this.getFileEntryId(webImage);
    }

    private InfoCollectionTextFormatter<Object> _getInfoCollectionTextFormatter(String itemClassName) {
        if (itemClassName.equals(String.class.getName())) {
            return _INFO_COLLECTION_TEXT_FORMATTER;
        }
        InfoCollectionTextFormatter<Object> infoCollectionTextFormatter = (InfoCollectionTextFormatter<Object>)this._infoItemServiceTracker.getFirstInfoItemService(InfoCollectionTextFormatter.class, itemClassName);
        if (infoCollectionTextFormatter == null) {
            infoCollectionTextFormatter = _INFO_COLLECTION_TEXT_FORMATTER;
        }
        return infoCollectionTextFormatter;
    }
}

