/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.styles;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.DocumentFragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import javax.servlet.http.HttpServletRequest;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"fragment.entry.processor.priority:Integer=7"}, service={DocumentFragmentEntryProcessor.class})
public class StylesDocumentFragmentEntryProcessor
implements DocumentFragmentEntryProcessor {
    private static final Log _log = LogFactoryUtil.getLog(StylesDocumentFragmentEntryProcessor.class);
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;

    public void processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, Document document, FragmentEntryProcessorContext fragmentEntryProcessorContext) {
        Elements elements = document.select("[data-lfr-styles]");
        if (elements.isEmpty()) {
            return;
        }
        FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem = this._getLayoutStructureItem(fragmentEntryLink, fragmentEntryProcessorContext.getHttpServletRequest());
        if (fragmentStyledLayoutStructureItem == null) {
            return;
        }
        String fragmentEntryLinkCssClass = fragmentStyledLayoutStructureItem.getFragmentEntryLinkCssClass(fragmentEntryLink);
        String layoutStructureItemUniqueCssClass = fragmentStyledLayoutStructureItem.getUniqueCssClass();
        String styledLayoutStructureItemCssClasses = fragmentStyledLayoutStructureItem.getStyledCssClasses();
        for (Element element : elements) {
            element.addClass(fragmentEntryLinkCssClass);
            element.addClass(layoutStructureItemUniqueCssClass);
            element.addClass(styledLayoutStructureItemCssClasses);
        }
    }

    private FragmentStyledLayoutStructureItem _getLayoutStructureItem(FragmentEntryLink fragmentEntryLink, HttpServletRequest httpServletRequest) {
        LayoutStructure layoutStructure = null;
        if (httpServletRequest != null) {
            layoutStructure = (LayoutStructure)httpServletRequest.getAttribute("LAYOUT_STRUCTURE");
        }
        if (layoutStructure == null) {
            try {
                LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(fragmentEntryLink.getGroupId(), fragmentEntryLink.getPlid());
                layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(fragmentEntryLink.getSegmentsExperienceId()));
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                return null;
            }
        }
        return (FragmentStyledLayoutStructureItem)layoutStructure.getLayoutStructureItemByFragmentEntryLinkId(fragmentEntryLink.getFragmentEntryLinkId());
    }
}

