/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.importer;

import com.liferay.fragment.constants.FragmentConstants;
import com.liferay.fragment.exception.DuplicateFragmentCollectionKeyException;
import com.liferay.fragment.exception.DuplicateFragmentCompositionKeyException;
import com.liferay.fragment.exception.DuplicateFragmentEntryKeyException;
import com.liferay.fragment.exception.FragmentCollectionNameException;
import com.liferay.fragment.exception.FragmentEntryConfigurationException;
import com.liferay.fragment.importer.FragmentsImporter;
import com.liferay.fragment.importer.FragmentsImporterResultEntry;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentComposition;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.service.FragmentCollectionLocalService;
import com.liferay.fragment.service.FragmentCollectionService;
import com.liferay.fragment.service.FragmentCompositionLocalService;
import com.liferay.fragment.service.FragmentCompositionService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.fragment.service.FragmentEntryService;
import com.liferay.fragment.validator.FragmentEntryValidator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FragmentsImporter.class})
public class FragmentsImporterImpl
implements FragmentsImporter {
    private static final String _FRAGMENT_COLLECTION_KEY_DEFAULT = "imported";
    private static final Log _log = LogFactoryUtil.getLog(FragmentsImporterImpl.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private FragmentCollectionLocalService _fragmentCollectionLocalService;
    @Reference
    private FragmentCollectionService _fragmentCollectionService;
    @Reference
    private FragmentCompositionLocalService _fragmentCompositionLocalService;
    @Reference
    private FragmentCompositionService _fragmentCompositionService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private FragmentEntryService _fragmentEntryService;
    @Reference
    private FragmentEntryValidator _fragmentEntryValidator;
    private List<FragmentsImporterResultEntry> _fragmentsImporterResultEntries;
    @Reference
    private Portal _portal;

    public List<String> importFile(long userId, long groupId, long fragmentCollectionId, File file, boolean overwrite) throws Exception {
        List<FragmentsImporterResultEntry> fragmentsImporterResultEntries = this.importFragmentEntries(userId, groupId, fragmentCollectionId, file, overwrite);
        Stream stream = fragmentsImporterResultEntries.stream();
        return stream.map(FragmentsImporterResultEntry::getName).collect(Collectors.toList());
    }

    public List<FragmentsImporterResultEntry> importFragmentEntries(long userId, long groupId, long fragmentCollectionId, File file, boolean overwrite) throws Exception {
        this._fragmentsImporterResultEntries = new ArrayList<FragmentsImporterResultEntry>();
        try (ZipFile zipFile = new ZipFile(file);){
            HashMap<String, String> orphanFragmentCompositions = new HashMap<String, String>();
            HashMap<String, String> orphanFragmentEntries = new HashMap<String, String>();
            Map<String, FragmentCollectionFolder> fragmentCollectionFolderMap = this._getFragmentCollectionFolderMap(zipFile, groupId, orphanFragmentCompositions, orphanFragmentEntries);
            for (Map.Entry<String, FragmentCollectionFolder> entry : fragmentCollectionFolderMap.entrySet()) {
                FragmentCollectionFolder fragmentCollectionFolder = entry.getValue();
                String name = entry.getKey();
                String description = "";
                String collectionJSON = this._getContent(zipFile, fragmentCollectionFolder.getFileName());
                if (Validator.isNotNull((String)collectionJSON)) {
                    JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)collectionJSON);
                    name = jsonObject.getString("name");
                    description = jsonObject.getString("description");
                }
                if (Validator.isNull((String)name)) {
                    throw new FragmentCollectionNameException();
                }
                FragmentCollection fragmentCollection = this._addFragmentCollection(groupId, entry.getKey(), name, description, overwrite);
                this._importResources(userId, groupId, fragmentCollection.getFragmentCollectionId(), fragmentCollection.getResourcesFolderId(), zipFile);
                this._importFragmentCompositions(userId, groupId, zipFile, fragmentCollection.getFragmentCollectionId(), fragmentCollectionFolder.getFragmentCompositions(), overwrite);
                this._importFragmentEntries(userId, groupId, zipFile, fragmentCollection.getFragmentCollectionId(), fragmentCollectionFolder.getFragmentEntries(), overwrite);
            }
            if (MapUtil.isNotEmpty(orphanFragmentCompositions) || MapUtil.isNotEmpty(orphanFragmentEntries)) {
                FragmentCollection fragmentCollection = this._fragmentCollectionService.fetchFragmentCollection(fragmentCollectionId);
                if (fragmentCollection == null) {
                    fragmentCollection = this._fragmentCollectionLocalService.fetchFragmentCollection(groupId, _FRAGMENT_COLLECTION_KEY_DEFAULT);
                    if (fragmentCollection == null) {
                        Locale locale = this._portal.getSiteDefaultLocale(groupId);
                        fragmentCollection = this._fragmentCollectionService.addFragmentCollection(groupId, _FRAGMENT_COLLECTION_KEY_DEFAULT, LanguageUtil.get((Locale)locale, (String)_FRAGMENT_COLLECTION_KEY_DEFAULT), "", ServiceContextThreadLocal.getServiceContext());
                    }
                    fragmentCollectionId = fragmentCollection.getFragmentCollectionId();
                }
                this._importFragmentCompositions(userId, groupId, zipFile, fragmentCollectionId, orphanFragmentCompositions, overwrite);
                this._importFragmentEntries(userId, groupId, zipFile, fragmentCollectionId, orphanFragmentEntries, overwrite);
            }
        }
        return this._fragmentsImporterResultEntries;
    }

    private FragmentCollection _addFragmentCollection(long groupId, String fragmentCollectionKey, String name, String description, boolean overwrite) throws Exception {
        FragmentCollection fragmentCollection = this._fragmentCollectionLocalService.fetchFragmentCollection(groupId, fragmentCollectionKey);
        if (fragmentCollection == null) {
            fragmentCollection = this._fragmentCollectionService.addFragmentCollection(groupId, fragmentCollectionKey, name, description, ServiceContextThreadLocal.getServiceContext());
        } else if (overwrite) {
            fragmentCollection = this._fragmentCollectionService.updateFragmentCollection(fragmentCollection.getFragmentCollectionId(), name, description);
        } else {
            throw new DuplicateFragmentCollectionKeyException(fragmentCollectionKey);
        }
        return fragmentCollection;
    }

    private FragmentEntry _addFragmentEntry(long fragmentCollectionId, String fragmentEntryKey, String name, String css, String html, String js, boolean cacheable, String configuration, boolean readOnly, String typeLabel, boolean overwrite) throws Exception {
        FragmentCollection fragmentCollection = this._fragmentCollectionLocalService.getFragmentCollection(fragmentCollectionId);
        FragmentEntry fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(fragmentCollection.getGroupId(), fragmentEntryKey);
        if (fragmentEntry != null && !overwrite) {
            throw new DuplicateFragmentEntryKeyException(fragmentEntryKey);
        }
        int status = 0;
        String errorMessage = null;
        try {
            this._fragmentEntryProcessorRegistry.validateFragmentEntryHTML(html, configuration);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            status = 2;
            errorMessage = portalException.getLocalizedMessage();
        }
        try {
            this._fragmentEntryValidator.validateConfiguration(configuration);
        }
        catch (FragmentEntryConfigurationException fragmentEntryConfigurationException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)fragmentEntryConfigurationException, (Throwable)fragmentEntryConfigurationException);
            }
            status = 2;
            errorMessage = fragmentEntryConfigurationException.getLocalizedMessage();
        }
        int type = FragmentConstants.getTypeFromLabel((String)StringUtil.toLowerCase((String)StringUtil.trim((String)typeLabel)));
        try {
            fragmentEntry = fragmentEntry == null ? this._fragmentEntryService.addFragmentEntry(fragmentCollection.getGroupId(), fragmentCollectionId, fragmentEntryKey, name, css, html, js, cacheable, configuration, 0L, type, status, ServiceContextThreadLocal.getServiceContext()) : this._fragmentEntryService.updateFragmentEntry(fragmentEntry.getFragmentEntryId(), fragmentCollectionId, name, css, html, js, cacheable, configuration, fragmentEntry.getPreviewFileEntryId(), status);
            fragmentEntry.setReadOnly(readOnly);
            fragmentEntry = this._fragmentEntryLocalService.updateFragmentEntry(fragmentEntry);
            FragmentsImporterResultEntry.Status fragmentsImporterResultEntryStatus = FragmentsImporterResultEntry.Status.IMPORTED;
            if (fragmentEntry.getStatus() == 2) {
                fragmentsImporterResultEntryStatus = FragmentsImporterResultEntry.Status.IMPORTED_DRAFT;
            }
            fragmentEntry = this._fragmentEntryLocalService.updateFragmentEntry(fragmentEntry);
            this._fragmentsImporterResultEntries.add(new FragmentsImporterResultEntry(name, fragmentsImporterResultEntryStatus, errorMessage));
            return fragmentEntry;
        }
        catch (PortalException portalException) {
            this._fragmentsImporterResultEntries.add(new FragmentsImporterResultEntry(name, FragmentsImporterResultEntry.Status.INVALID, portalException.getMessage()));
            return null;
        }
    }

    private String _getContent(ZipFile zipFile, String fileName) throws Exception {
        ZipEntry zipEntry = zipFile.getEntry(fileName);
        if (zipEntry == null) {
            return "";
        }
        return StringUtil.read((InputStream)zipFile.getInputStream(zipEntry));
    }

    private String _getFileName(String path) {
        int pos = path.lastIndexOf(47);
        if (pos > 0) {
            return path.substring(pos + 1);
        }
        return path;
    }

    private Map<String, FragmentCollectionFolder> _getFragmentCollectionFolderMap(ZipFile zipFile, long groupId, Map<String, String> orphanFragmentCompositions, Map<String, String> orphanFragmentEntries) throws Exception {
        String fileName;
        ZipEntry zipEntry;
        HashMap<String, FragmentCollectionFolder> fragmentCollectionFolderMap = new HashMap<String, FragmentCollectionFolder>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !this._isFragmentCollection(fileName = zipEntry.getName())) continue;
            fragmentCollectionFolderMap.put(this._getKey(zipFile, groupId, fileName), new FragmentCollectionFolder(fileName));
        }
        enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !this._isFragmentComposition(fileName = zipEntry.getName()) && !this._isFragmentEntry(fileName)) continue;
            String fragmentCollectionPath = fileName;
            String fragmentCollectionKey = "";
            while (fragmentCollectionPath.length() > 0) {
                String fragmentCollectionFileName = (fragmentCollectionPath = fragmentCollectionPath.substring(0, fragmentCollectionPath.lastIndexOf("/") + 1)) + "collection.json";
                ZipEntry fragmentCollectionZipEntry = zipFile.getEntry(fragmentCollectionFileName);
                if (fragmentCollectionZipEntry != null) {
                    fragmentCollectionKey = this._getKey(zipFile, groupId, fragmentCollectionFileName);
                    break;
                }
                if (Validator.isNull((String)fragmentCollectionPath)) break;
                fragmentCollectionPath = fragmentCollectionPath.substring(0, fragmentCollectionPath.lastIndexOf("/"));
            }
            if (Validator.isNull((String)fragmentCollectionKey) && this._isFragmentComposition(fileName)) {
                orphanFragmentCompositions.put(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            if (Validator.isNull((String)fragmentCollectionKey) && this._isFragmentEntry(fileName)) {
                orphanFragmentEntries.put(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            FragmentCollectionFolder fragmentCollectionFolder = (FragmentCollectionFolder)fragmentCollectionFolderMap.get(fragmentCollectionKey);
            if (fragmentCollectionFolder == null && this._isFragmentComposition(fileName)) {
                orphanFragmentCompositions.put(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            if (fragmentCollectionFolder == null && this._isFragmentEntry(fileName)) {
                orphanFragmentEntries.put(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            if (this._isFragmentComposition(fileName)) {
                fragmentCollectionFolder.addFragmentComposition(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            fragmentCollectionFolder.addFragmentEntry(this._getKey(zipFile, groupId, fileName), fileName);
        }
        return fragmentCollectionFolderMap;
    }

    private String _getFragmentEntryContent(ZipFile zipFile, String fileName, String contentPath) throws Exception {
        InputStream inputStream = this._getFragmentEntryInputStream(zipFile, fileName, contentPath);
        if (inputStream == null) {
            return "";
        }
        return StringUtil.read((InputStream)inputStream);
    }

    private InputStream _getFragmentEntryInputStream(ZipFile zipFile, String fileName, String contentPath) throws Exception {
        if (contentPath.startsWith("/")) {
            return this._getInputStream(zipFile, contentPath.substring(1));
        }
        if (contentPath.startsWith("./")) {
            contentPath = contentPath.substring(2);
        }
        String path = fileName.substring(0, fileName.lastIndexOf("/"));
        return this._getInputStream(zipFile, path + "/" + contentPath);
    }

    private InputStream _getInputStream(ZipFile zipFile, String fileName) throws Exception {
        ZipEntry zipEntry = zipFile.getEntry(fileName);
        if (zipEntry == null) {
            return null;
        }
        return zipFile.getInputStream(zipEntry);
    }

    private String _getKey(ZipFile zipFile, long groupId, String fileName) throws Exception {
        String key = "";
        if (fileName.lastIndexOf(47) != -1) {
            String path = fileName.substring(0, fileName.lastIndexOf(47));
            key = path.substring(path.lastIndexOf(47) + 1);
        } else if (fileName.equals("collection.json")) {
            JSONObject collectionJSONObject = JSONFactoryUtil.createJSONObject((String)StringUtil.read((InputStream)zipFile.getInputStream(zipFile.getEntry(fileName))));
            key = this._fragmentCollectionLocalService.generateFragmentCollectionKey(groupId, collectionJSONObject.getString("name"));
        } else if (fileName.equals("fragment.json")) {
            JSONObject fragmentJSONObject = JSONFactoryUtil.createJSONObject((String)StringUtil.read((InputStream)zipFile.getInputStream(zipFile.getEntry(fileName))));
            key = this._fragmentEntryLocalService.generateFragmentEntryKey(groupId, fragmentJSONObject.getString("name"));
        }
        if (Validator.isNotNull((String)key)) {
            return key;
        }
        throw new IllegalArgumentException("Incorrect file name " + fileName);
    }

    private long _getPreviewFileEntryId(long userId, long groupId, ZipFile zipFile, String className, long classPK, String fileName, String contentPath) throws Exception {
        InputStream inputStream = this._getFragmentEntryInputStream(zipFile, fileName, contentPath);
        if (inputStream == null) {
            return 0L;
        }
        Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet");
        if (repository == null) {
            if (groupId == 0L && Objects.equals(className, FragmentEntry.class.getName())) {
                FragmentEntry fragmentEntry = this._fragmentEntryLocalService.getFragmentEntry(classPK);
                Company company = this._companyLocalService.getCompany(fragmentEntry.getCompanyId());
                groupId = company.getGroupId();
            } else if (groupId == 0L && Objects.equals(className, FragmentComposition.class.getName())) {
                FragmentComposition fragmentComposition = this._fragmentCompositionLocalService.getFragmentComposition(classPK);
                Company company = this._companyLocalService.getCompany(fragmentComposition.getCompanyId());
                groupId = company.getGroupId();
            }
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (ServiceContext)serviceContext);
        }
        FileEntry fileEntry = PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)className, (long)classPK, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (long)repository.getDlFolderId(), (InputStream)inputStream, (String)(classPK + "_preview." + FileUtil.getExtension((String)contentPath)), (String)MimeTypesUtil.getContentType((String)contentPath), (boolean)false);
        return fileEntry.getFileEntryId();
    }

    private void _importFragmentCompositions(long userId, long groupId, ZipFile zipFile, long fragmentCollectionId, Map<String, String> fragmentCompositions, boolean overwrite) throws Exception {
        for (Map.Entry<String, String> entry : fragmentCompositions.entrySet()) {
            String thumbnailPath;
            String compositionJSON = this._getContent(zipFile, entry.getValue());
            if (Validator.isNull((String)compositionJSON)) continue;
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)compositionJSON);
            String name = jsonObject.getString("name", entry.getKey());
            String description = jsonObject.getString("description");
            String definitionData = this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject.getString("fragmentCompositionDefinitionPath"));
            FragmentComposition fragmentComposition = this._fragmentCompositionService.fetchFragmentComposition(groupId, entry.getKey());
            if (fragmentComposition == null) {
                fragmentComposition = this._fragmentCompositionService.addFragmentComposition(groupId, fragmentCollectionId, entry.getKey(), name, description, definitionData, 0L, 0, ServiceContextThreadLocal.getServiceContext());
            } else {
                if (!overwrite) {
                    throw new DuplicateFragmentCompositionKeyException();
                }
                fragmentComposition = this._fragmentCompositionService.updateFragmentComposition(fragmentComposition.getFragmentCompositionId(), fragmentCollectionId, name, description, definitionData, fragmentComposition.getPreviewFileEntryId(), fragmentComposition.getStatus());
            }
            if (fragmentComposition.getPreviewFileEntryId() > 0L) {
                PortletFileRepositoryUtil.deletePortletFileEntry((long)fragmentComposition.getPreviewFileEntryId());
            }
            if (!Validator.isNotNull((String)(thumbnailPath = jsonObject.getString("thumbnailPath")))) continue;
            long previewFileEntryId = this._getPreviewFileEntryId(userId, groupId, zipFile, FragmentComposition.class.getName(), fragmentComposition.getFragmentCompositionId(), entry.getValue(), thumbnailPath);
            this._fragmentCompositionService.updateFragmentComposition(fragmentComposition.getFragmentCompositionId(), previewFileEntryId);
        }
    }

    private void _importFragmentEntries(long userId, long groupId, ZipFile zipFile, long fragmentCollectionId, Map<String, String> fragmentEntries, boolean overwrite) throws Exception {
        for (Map.Entry<String, String> entry : fragmentEntries.entrySet()) {
            JSONObject jsonObject;
            String thumbnailPath;
            FragmentEntry fragmentEntry;
            String name = entry.getKey();
            String css = "";
            String html = "";
            String js = "";
            boolean cacheable = false;
            String configuration = "";
            boolean readOnly = false;
            String typeLabel = "";
            String fragmentJSON = this._getContent(zipFile, entry.getValue());
            if (Validator.isNotNull((String)fragmentJSON)) {
                JSONObject jsonObject2 = JSONFactoryUtil.createJSONObject((String)fragmentJSON);
                name = jsonObject2.getString("name");
                css = this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject2.getString("cssPath"));
                html = this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject2.getString("htmlPath"));
                js = this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject2.getString("jsPath"));
                cacheable = jsonObject2.getBoolean("cacheable");
                configuration = this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject2.getString("configurationPath"));
                readOnly = jsonObject2.getBoolean("readOnly");
                typeLabel = jsonObject2.getString("type");
            }
            if ((fragmentEntry = this._addFragmentEntry(fragmentCollectionId, entry.getKey(), name, css, html, js, cacheable, configuration, readOnly, typeLabel, overwrite)) == null || !Validator.isNotNull((String)fragmentJSON)) continue;
            if (fragmentEntry.getPreviewFileEntryId() > 0L) {
                PortletFileRepositoryUtil.deletePortletFileEntry((long)fragmentEntry.getPreviewFileEntryId());
            }
            if (!Validator.isNotNull((String)(thumbnailPath = (jsonObject = JSONFactoryUtil.createJSONObject((String)fragmentJSON)).getString("thumbnailPath")))) continue;
            long previewFileEntryId = this._getPreviewFileEntryId(userId, groupId, zipFile, FragmentEntry.class.getName(), fragmentEntry.getFragmentEntryId(), entry.getValue(), thumbnailPath);
            this._fragmentEntryLocalService.updateFragmentEntry(fragmentEntry.getFragmentEntryId(), previewFileEntryId);
        }
    }

    private void _importResources(long userId, long groupId, long fragmentCollectionId, long folderId, ZipFile zipFile) throws Exception {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ArrayList<? extends ZipEntry> zipEntries = Collections.list(enumeration);
        Stream stream = zipEntries.stream();
        Set excludePaths = stream.filter(zipEntry -> {
            String name = zipEntry.getName();
            return name.endsWith("collection.json") || name.endsWith("fragment.json");
        }).flatMap(zipEntry -> {
            String name = zipEntry.getName();
            String path = name.substring(0, name.lastIndexOf("/") + 1);
            if (name.endsWith("collection.json")) {
                return Arrays.stream(new String[]{name});
            }
            try {
                String fragmentJSON = StringUtil.read((InputStream)zipFile.getInputStream((ZipEntry)zipEntry));
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fragmentJSON);
                return Arrays.stream(new String[]{path + "fragment.json", path + jsonObject.getString("configuration"), path + jsonObject.getString("cssPath"), path + jsonObject.getString("htmlPath"), path + jsonObject.getString("jsPath"), path + jsonObject.getString("thumbnailPath")});
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to read fragments.json file " + name), (Throwable)exception);
                return Arrays.stream(new String[0]);
            }
        }).collect(Collectors.toSet());
        for (ZipEntry zipEntry2 : zipEntries) {
            Object[] paths = StringUtil.split((String)zipEntry2.getName(), (String)"/");
            if (!ArrayUtil.contains((Object[])paths, (Object)"resources") || excludePaths.contains(zipEntry2.getName())) continue;
            String fileName = this._getFileName(zipEntry2.getName());
            InputStream inputStream = this._getInputStream(zipFile, zipEntry2.getName());
            FileEntry fileEntry = PortletFileRepositoryUtil.fetchPortletFileEntry((long)groupId, (long)folderId, (String)fileName);
            if (fileEntry != null) {
                PortletFileRepositoryUtil.deletePortletFileEntry((long)fileEntry.getFileEntryId());
            }
            PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)FragmentCollection.class.getName(), (long)fragmentCollectionId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (long)folderId, (InputStream)inputStream, (String)fileName, (String)MimeTypesUtil.getContentType((String)fileName), (boolean)false);
        }
    }

    private boolean _isFragmentCollection(String fileName) {
        return Objects.equals(this._getFileName(fileName), "collection.json");
    }

    private boolean _isFragmentComposition(String fileName) {
        return Objects.equals(this._getFileName(fileName), "fragment-composition.json");
    }

    private boolean _isFragmentEntry(String fileName) {
        return Objects.equals(this._getFileName(fileName), "fragment.json");
    }

    private class FragmentCollectionFolder {
        private final String _fileName;
        private final Map<String, String> _fragmentCompositions;
        private final Map<String, String> _fragmentEntries;

        public FragmentCollectionFolder(String fileName) {
            this._fileName = fileName;
            this._fragmentCompositions = new HashMap<String, String>();
            this._fragmentEntries = new HashMap<String, String>();
        }

        public void addFragmentComposition(String key, String fileName) {
            this._fragmentCompositions.put(key, fileName);
        }

        public void addFragmentEntry(String key, String fileName) {
            this._fragmentEntries.put(key, fileName);
        }

        public String getFileName() {
            return this._fileName;
        }

        public Map<String, String> getFragmentCompositions() {
            return this._fragmentCompositions;
        }

        public Map<String, String> getFragmentEntries() {
            return this._fragmentEntries;
        }
    }
}

