/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.Tuple;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseContentFragmentRenderer
implements FragmentRenderer {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected FragmentEntryConfigurationParser fragmentEntryConfigurationParser;
    @Reference
    protected Portal portal;
    @Reference(target="(bundle.symbolic.name=com.liferay.fragment.impl)")
    protected ResourceBundleLoader resourceBundleLoader;

    protected Tuple getDisplayObject(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest) {
        AssetEntry assetEntry;
        Object displayObject;
        FragmentEntryLink fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink();
        JSONObject jsonObject = (JSONObject)this.fragmentEntryConfigurationParser.getFieldValue(this.getConfiguration(fragmentRendererContext), fragmentEntryLink.getEditableValues(), "itemSelector");
        if (jsonObject != null && jsonObject.has("className") && jsonObject.has("classPK")) {
            return new Tuple(new Object[]{jsonObject.getString("className"), jsonObject.getLong("classPK")});
        }
        Optional displayObjectOptional = fragmentRendererContext.getDisplayObjectOptional();
        if (displayObjectOptional.isPresent() && (displayObject = displayObjectOptional.get()) instanceof ClassedModel) {
            ClassedModel classedModel = (ClassedModel)displayObject;
            String modelClassName = classedModel.getModelClassName();
            Serializable primaryKeyObj = classedModel.getPrimaryKeyObj();
            if (!Objects.equals(modelClassName, AssetEntry.class.getName())) {
                return new Tuple(new Object[]{modelClassName, primaryKeyObj});
            }
            AssetEntry assetEntry2 = this.assetEntryLocalService.fetchAssetEntry(((Long)primaryKeyObj).longValue());
            if (assetEntry2 != null) {
                return new Tuple(new Object[]{this.portal.getClassName(assetEntry2.getClassNameId()), assetEntry2.getClassPK()});
            }
        }
        if ((assetEntry = (AssetEntry)httpServletRequest.getAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY")) != null) {
            return new Tuple(new Object[]{assetEntry.getClassName(), assetEntry.getClassPK()});
        }
        return new Tuple(new Object[]{fragmentEntryLink.getClassName(), fragmentEntryLink.getClassPK()});
    }
}

