/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.fragment.internal.renderer.FragmentRendererUtil;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.info.item.renderer.InfoItemRenderer;
import com.liferay.info.item.renderer.InfoItemRendererTracker;
import com.liferay.info.item.renderer.InfoItemTemplatedRenderer;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Tuple;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentRenderer.class})
public class ContentObjectFragmentRenderer
implements FragmentRenderer {
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private InfoItemRendererTracker _infoItemRendererTracker;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;

    public String getCollectionKey() {
        return "content-display";
    }

    public String getConfiguration(FragmentRendererContext fragmentRendererContext) {
        return JSONUtil.put((String)"fieldSets", (Object)JSONUtil.putAll((Object[])new Object[]{JSONUtil.put((String)"fields", (Object)JSONUtil.putAll((Object[])new Object[]{JSONUtil.put((String)"label", (Object)"content-display").put("name", "itemSelector").put("type", "itemSelector").put("typeOptions", JSONUtil.put((String)"enableSelectTemplate", (Object)true))}))})).toString();
    }

    public String getIcon() {
        return "web-content";
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"content-display");
    }

    public void render(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        JSONObject jsonObject = this._getFieldValueJSONObject(fragmentRendererContext);
        Optional displayObjectOptional = fragmentRendererContext.getDisplayObjectOptional();
        if (!(displayObjectOptional.isPresent() || jsonObject != null && jsonObject.length() != 0)) {
            if (FragmentRendererUtil.isEditMode(httpServletRequest)) {
                FragmentRendererUtil.printPortletMessageInfo(httpServletRequest, httpServletResponse, "the-selected-content-will-be-shown-here");
            }
            return;
        }
        Object displayObject = null;
        displayObject = jsonObject != null ? this._getDisplayObject(jsonObject.getString("className"), jsonObject.getLong("classPK"), displayObjectOptional) : displayObjectOptional.orElse(null);
        if (displayObject == null) {
            if (FragmentRendererUtil.isEditMode(httpServletRequest)) {
                FragmentRendererUtil.printPortletMessageInfo(httpServletRequest, httpServletResponse, "the-selected-content-is-no-longer-available.-please-select-another");
            }
            return;
        }
        Tuple tuple = this._getTuple(displayObject.getClass(), fragmentRendererContext);
        InfoItemRenderer infoItemRenderer = (InfoItemRenderer)tuple.getObject(0);
        if (infoItemRenderer == null) {
            if (FragmentRendererUtil.isEditMode(httpServletRequest)) {
                FragmentRendererUtil.printPortletMessageInfo(httpServletRequest, httpServletResponse, "there-are-no-available-renderers-for-the-selected-content");
            }
            return;
        }
        if (infoItemRenderer instanceof InfoItemTemplatedRenderer) {
            InfoItemTemplatedRenderer infoItemTemplatedRenderer = (InfoItemTemplatedRenderer)infoItemRenderer;
            if (tuple.getSize() > 1) {
                infoItemTemplatedRenderer.render(displayObject, (String)tuple.getObject(1), httpServletRequest, httpServletResponse);
            } else {
                infoItemTemplatedRenderer.render(displayObject, httpServletRequest, httpServletResponse);
            }
        } else {
            infoItemRenderer.render(displayObject, httpServletRequest, httpServletResponse);
        }
    }

    private Object _getDisplayObject(String className, long classPK, Optional<Object> displayObjectOptional) {
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemObjectProvider.class, className);
        if (infoItemObjectProvider == null) {
            return displayObjectOptional.orElse(null);
        }
        try {
            Object infoItem = infoItemObjectProvider.getInfoItem((InfoItemIdentifier)new ClassPKInfoItemIdentifier(classPK));
            if (infoItem == null) {
                return displayObjectOptional.orElse(null);
            }
            return infoItem;
        }
        catch (Exception exception) {
            return displayObjectOptional.orElse(null);
        }
    }

    private JSONObject _getFieldValueJSONObject(FragmentRendererContext fragmentRendererContext) {
        FragmentEntryLink fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink();
        return (JSONObject)this._fragmentEntryConfigurationParser.getFieldValue(this.getConfiguration(fragmentRendererContext), fragmentEntryLink.getEditableValues(), "itemSelector");
    }

    private Tuple _getTuple(Class<?> displayObjectClass, FragmentRendererContext fragmentRendererContext) {
        List<InfoItemRenderer<?>> infoItemRenderers = FragmentRendererUtil.getInfoItemRenderers(displayObjectClass, this._infoItemRendererTracker);
        if (infoItemRenderers == null) {
            return null;
        }
        InfoItemRenderer<?> defaultInfoItemRenderer = infoItemRenderers.get(0);
        JSONObject jsonObject = this._getFieldValueJSONObject(fragmentRendererContext);
        if (jsonObject == null) {
            return new Tuple(new Object[]{defaultInfoItemRenderer});
        }
        JSONObject templateJSONObject = jsonObject.getJSONObject("template");
        if (templateJSONObject == null) {
            return new Tuple(new Object[]{defaultInfoItemRenderer});
        }
        String infoItemRendererKey = templateJSONObject.getString("infoItemRendererKey");
        InfoItemRenderer infoItemRenderer = this._infoItemRendererTracker.getInfoItemRenderer(infoItemRendererKey);
        if (infoItemRenderer != null) {
            return new Tuple(new Object[]{infoItemRenderer, templateJSONObject.getString("templateKey")});
        }
        return new Tuple(new Object[]{defaultInfoItemRenderer});
    }
}

