/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.contributor;

import com.liferay.fragment.contributor.FragmentCollectionContributor;
import com.liferay.fragment.contributor.FragmentCollectionContributorRegistration;
import com.liferay.fragment.contributor.FragmentCollectionContributorTracker;
import com.liferay.fragment.model.FragmentComposition;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.model.FragmentEntryModel;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.validator.FragmentEntryValidator;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={FragmentCollectionContributorTracker.class})
public class FragmentCollectionContributorTrackerImpl
implements FragmentCollectionContributorTracker {
    @Reference
    protected FragmentEntryProcessorRegistry fragmentEntryProcessorRegistry;
    @Reference
    protected FragmentEntryValidator fragmentEntryValidator;
    private static final int[] _SUPPORTED_FRAGMENT_TYPES = new int[]{1, 0};
    private static final Log _log = LogFactoryUtil.getLog(FragmentCollectionContributorTrackerImpl.class);
    private volatile Map<String, FragmentComposition> _fragmentCompositions = new ConcurrentHashMap<String, FragmentComposition>();
    private volatile Map<String, FragmentEntry> _fragmentEntries = new ConcurrentHashMap<String, FragmentEntry>();
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    private ServiceTrackerMap<String, FragmentCollectionContributor> _serviceTrackerMap;

    public FragmentCollectionContributor getFragmentCollectionContributor(String fragmentCollectionKey) {
        return (FragmentCollectionContributor)this._serviceTrackerMap.getService((Object)fragmentCollectionKey);
    }

    @Deprecated
    public Map<String, FragmentEntry> getFragmentCollectionContributorEntries() {
        return this.getFragmentEntries();
    }

    public List<FragmentCollectionContributor> getFragmentCollectionContributors() {
        ArrayList fragmentCollectionContributors = new ArrayList(this._serviceTrackerMap.values());
        return ListUtil.filter(fragmentCollectionContributors, fragmentCollectionContributor -> MapUtil.isNotEmpty((Map)fragmentCollectionContributor.getNames()));
    }

    public FragmentComposition getFragmentComposition(String fragmentCompositionKey) {
        Map<String, FragmentComposition> fragmentCompositionsMap = this._getFragmentCompositions();
        return fragmentCompositionsMap.get(fragmentCompositionKey);
    }

    public Map<String, FragmentEntry> getFragmentEntries() {
        return new HashMap<String, FragmentEntry>(this._getFragmentEntries());
    }

    public Map<String, FragmentEntry> getFragmentEntries(Locale locale) {
        Collection fragmentCollectionContributors = this._serviceTrackerMap.values();
        Stream stream = fragmentCollectionContributors.stream();
        return stream.map(fragmentCollectionContributor -> {
            HashMap<String, FragmentEntry> fragmentEntries = new HashMap<String, FragmentEntry>();
            for (int type : _SUPPORTED_FRAGMENT_TYPES) {
                for (FragmentEntry fragmentEntry : fragmentCollectionContributor.getFragmentEntries(type, locale)) {
                    fragmentEntries.put(fragmentEntry.getFragmentEntryKey(), fragmentEntry);
                }
            }
            return fragmentEntries;
        }).flatMap(fragmentEntriesMap -> {
            Collection fragmentEntries = fragmentEntriesMap.values();
            return fragmentEntries.stream();
        }).collect(Collectors.toMap(FragmentEntryModel::getFragmentEntryKey, fragmentEntry -> fragmentEntry));
    }

    public FragmentEntry getFragmentEntry(String fragmentEntryKey) {
        Map<String, FragmentEntry> fragmentEntriesMap = this._getFragmentEntries();
        return fragmentEntriesMap.get(fragmentEntryKey);
    }

    public ResourceBundleLoader getResourceBundleLoader() {
        Collection fragmentCollectionContributors = this._serviceTrackerMap.values();
        Stream stream = fragmentCollectionContributors.stream();
        return new AggregateResourceBundleLoader((ResourceBundleLoader[])stream.map(FragmentCollectionContributor::getResourceBundleLoader).filter(Objects::nonNull).toArray(ResourceBundleLoader[]::new));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, FragmentCollectionContributor.class, null, (serviceReference, emitter) -> {
            FragmentCollectionContributor fragmentCollectionContributor = (FragmentCollectionContributor)bundleContext.getService(serviceReference);
            emitter.emit((Object)fragmentCollectionContributor.getFragmentCollectionKey());
        }, (ServiceTrackerCustomizer)new FragmentCollectionContributorTrackerServiceTrackerCustomizer(bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private synchronized Map<String, FragmentComposition> _getFragmentCompositions() {
        Map<String, FragmentComposition> fragmentCompositions = this._fragmentCompositions;
        if (fragmentCompositions == null) {
            fragmentCompositions = new HashMap<String, FragmentComposition>();
            for (FragmentCollectionContributor fragmentCollectionContributor : this._serviceTrackerMap.values()) {
                fragmentCompositions.putAll(this._getFragmentCompositions(fragmentCollectionContributor));
            }
            this._fragmentCompositions = fragmentCompositions;
        }
        return new HashMap<String, FragmentComposition>(fragmentCompositions);
    }

    private Map<String, FragmentComposition> _getFragmentCompositions(FragmentCollectionContributor fragmentCollectionContributor) {
        HashMap<String, FragmentComposition> fragmentCompositions = new HashMap<String, FragmentComposition>();
        for (FragmentComposition fragmentComposition : fragmentCollectionContributor.getFragmentCompositions()) {
            fragmentCompositions.put(fragmentComposition.getFragmentCompositionKey(), fragmentComposition);
        }
        return fragmentCompositions;
    }

    private synchronized Map<String, FragmentEntry> _getFragmentEntries() {
        Map<String, FragmentEntry> fragmentEntries = this._fragmentEntries;
        if (fragmentEntries == null) {
            fragmentEntries = new HashMap<String, FragmentEntry>();
            for (FragmentCollectionContributor fragmentCollectionContributor : this._serviceTrackerMap.values()) {
                fragmentEntries.putAll(this._getFragmentEntries(fragmentCollectionContributor));
            }
            this._fragmentEntries = fragmentEntries;
        }
        return new HashMap<String, FragmentEntry>(fragmentEntries);
    }

    private Map<String, FragmentEntry> _getFragmentEntries(FragmentCollectionContributor fragmentCollectionContributor) {
        HashMap<String, FragmentEntry> fragmentEntries = new HashMap<String, FragmentEntry>();
        for (int type : _SUPPORTED_FRAGMENT_TYPES) {
            for (FragmentEntry fragmentEntry : fragmentCollectionContributor.getFragmentEntries(type)) {
                if (!this._validateFragmentEntry(fragmentEntry)) continue;
                fragmentEntries.put(fragmentEntry.getFragmentEntryKey(), fragmentEntry);
                this._updateFragmentEntryLinks(fragmentEntry);
            }
        }
        return fragmentEntries;
    }

    private void _updateFragmentEntryLinks(FragmentEntry fragmentEntry) {
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(fragmentEntry.getFragmentEntryKey());
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            boolean modified = false;
            if (!Objects.equals(fragmentEntryLink.getCss(), fragmentEntry.getCss())) {
                fragmentEntryLink.setCss(fragmentEntry.getCss());
                modified = true;
            }
            if (!Objects.equals(fragmentEntryLink.getHtml(), fragmentEntry.getHtml())) {
                fragmentEntryLink.setHtml(fragmentEntry.getHtml());
                modified = true;
            }
            if (!Objects.equals(fragmentEntryLink.getJs(), fragmentEntry.getJs())) {
                fragmentEntryLink.setJs(fragmentEntry.getJs());
                modified = true;
            }
            if (!Objects.equals(fragmentEntryLink.getConfiguration(), fragmentEntry.getConfiguration())) {
                fragmentEntryLink.setConfiguration(fragmentEntry.getConfiguration());
                modified = true;
            }
            if (!modified) continue;
            this._fragmentEntryLinkLocalService.updateFragmentEntryLink(fragmentEntryLink);
        }
    }

    private boolean _validateFragmentEntry(FragmentEntry fragmentEntry) {
        try {
            this.fragmentEntryValidator.validateConfiguration(fragmentEntry.getConfiguration());
            this.fragmentEntryProcessorRegistry.validateFragmentEntryHTML(fragmentEntry.getHtml(), fragmentEntry.getConfiguration());
            return true;
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to validate fragment entry", (Throwable)portalException);
            return false;
        }
    }

    private class FragmentCollectionContributorTrackerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<FragmentCollectionContributor, FragmentCollectionContributor> {
        private final BundleContext _bundleContext;

        public FragmentCollectionContributorTrackerServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        public FragmentCollectionContributor addingService(ServiceReference<FragmentCollectionContributor> serviceReference) {
            FragmentCollectionContributor fragmentCollectionContributor = (FragmentCollectionContributor)this._bundleContext.getService(serviceReference);
            if (FragmentCollectionContributorTrackerImpl.this._fragmentCompositions == null) {
                FragmentCollectionContributorTrackerImpl.this._fragmentCompositions = new ConcurrentHashMap();
            }
            FragmentCollectionContributorTrackerImpl.this._fragmentCompositions.putAll(FragmentCollectionContributorTrackerImpl.this._getFragmentCompositions(fragmentCollectionContributor));
            if (FragmentCollectionContributorTrackerImpl.this._fragmentEntries == null) {
                FragmentCollectionContributorTrackerImpl.this._fragmentEntries = new ConcurrentHashMap();
            }
            FragmentCollectionContributorTrackerImpl.this._fragmentEntries.putAll(FragmentCollectionContributorTrackerImpl.this._getFragmentEntries(fragmentCollectionContributor));
            this._bundleContext.registerService(FragmentCollectionContributorRegistration.class, (Object)new FragmentCollectionContributorRegistration(){}, (Dictionary)HashMapDictionaryBuilder.put((Object)"fragment.collection.key", (Object)serviceReference.getProperty("fragment.collection.key")).build());
            return fragmentCollectionContributor;
        }

        public void modifiedService(ServiceReference<FragmentCollectionContributor> serviceReference, FragmentCollectionContributor fragmentCollectionContributor) {
        }

        public void removedService(ServiceReference<FragmentCollectionContributor> serviceReference, FragmentCollectionContributor fragmentCollectionContributor) {
            for (FragmentComposition fragmentComposition : fragmentCollectionContributor.getFragmentCompositions()) {
                FragmentCollectionContributorTrackerImpl.this._fragmentCompositions.remove(fragmentComposition.getFragmentCompositionKey());
            }
            for (FragmentEntry fragmentEntry : fragmentCollectionContributor.getFragmentEntries()) {
                FragmentCollectionContributorTrackerImpl.this._fragmentEntries.remove(fragmentEntry.getFragmentEntryKey());
            }
            this._bundleContext.ungetService(serviceReference);
        }
    }
}

