/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.fragment.contributor.FragmentCollectionContributorTracker;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.DefaultFragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.servlet.taglib.util.OutputData;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentRenderer.class})
public class FragmentEntryFragmentRenderer
implements FragmentRenderer {
    private static PortalCache<String, String> _portalCache;
    @Reference
    private FragmentCollectionContributorTracker _fragmentCollectionContributorTracker;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private MultiVMPool _multiVMPool;
    @Reference
    private PortletRegistry _portletRegistry;

    public String getCollectionKey() {
        return "";
    }

    public String getConfiguration(FragmentRendererContext fragmentRendererContext) {
        FragmentEntryLink fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink();
        return fragmentEntryLink.getConfiguration();
    }

    public String getKey() {
        return "FRAGMENT_ENTRY_FRAGMENT_RENDERER_KEY";
    }

    public boolean isSelectable(HttpServletRequest httpServletRequest) {
        return false;
    }

    public void render(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.write(this._renderFragmentEntryLink(fragmentRendererContext, httpServletRequest, httpServletResponse));
        }
        catch (PortalException portalException) {
            throw new IOException(portalException);
        }
    }

    @Activate
    protected void activate() {
        _portalCache = this._multiVMPool.getPortalCache(FragmentEntryLink.class.getName());
    }

    private FragmentEntry _getContributedFragmentEntry(FragmentEntryLink fragmentEntryLink) {
        Map fragmentCollectionContributorEntries = this._fragmentCollectionContributorTracker.getFragmentEntries();
        return (FragmentEntry)fragmentCollectionContributorEntries.get(fragmentEntryLink.getRendererKey());
    }

    private FragmentEntryLink _getFragmentEntryLink(FragmentRendererContext fragmentRendererContext) {
        FragmentEntryLink fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink();
        FragmentEntry fragmentEntry = this._getContributedFragmentEntry(fragmentEntryLink);
        if (fragmentEntry != null) {
            fragmentEntryLink.setCss(fragmentEntry.getCss());
            fragmentEntryLink.setHtml(fragmentEntry.getHtml());
            fragmentEntryLink.setJs(fragmentEntry.getJs());
        }
        return fragmentEntryLink;
    }

    private boolean _isCacheable(FragmentEntryLink fragmentEntryLink) {
        if (Validator.isNull((String)fragmentEntryLink.getRendererKey())) {
            return fragmentEntryLink.isCacheable();
        }
        FragmentEntry fragmentEntry = this._fragmentCollectionContributorTracker.getFragmentEntry(fragmentEntryLink.getRendererKey());
        if (fragmentEntry == null) {
            return false;
        }
        return fragmentEntry.isCacheable();
    }

    private String _renderFragmentEntry(long fragmentEntryId, String css, String html, String js, String configuration, String namespace, HttpServletRequest httpServletRequest) {
        StringBundler sb = new StringBundler(18);
        sb.append("<div id=\"");
        StringBundler fragmentIdSB = new StringBundler(4);
        fragmentIdSB.append("fragment-");
        fragmentIdSB.append(fragmentEntryId);
        fragmentIdSB.append("-");
        fragmentIdSB.append(namespace);
        sb.append(fragmentIdSB.toString());
        sb.append("\" >");
        sb.append(html);
        sb.append("</div>");
        if (Validator.isNotNull((String)css)) {
            String outputKey = fragmentEntryId + "_CSS";
            OutputData outputData = (OutputData)httpServletRequest.getAttribute("LIFERAY_SHARED_OUTPUT_DATA");
            boolean cssLoaded = false;
            if (outputData != null) {
                Set outputKeys = outputData.getOutputKeys();
                cssLoaded = outputKeys.contains(outputKey);
                StringBundler cssSB = outputData.getDataSB(outputKey, "");
                if (cssSB != null) {
                    cssLoaded = Objects.equals(cssSB.toString(), css);
                }
            } else {
                outputData = new OutputData();
            }
            if (!cssLoaded) {
                sb.append("<style>");
                sb.append(css);
                sb.append("</style>");
                outputData.addOutputKey(outputKey);
                outputData.setDataSB(outputKey, "", new StringBundler(css));
                httpServletRequest.setAttribute("LIFERAY_SHARED_OUTPUT_DATA", (Object)outputData);
            }
        }
        if (Validator.isNotNull((String)js)) {
            sb.append("<script>(function() {");
            sb.append("var configuration = ");
            sb.append(configuration);
            sb.append("; var fragmentElement = document.querySelector('#");
            sb.append(fragmentIdSB.toString());
            sb.append("'); var fragmentNamespace = '");
            sb.append(namespace);
            sb.append("';");
            sb.append(js);
            sb.append(";}());</script>");
        }
        return sb.toString();
    }

    private String _renderFragmentEntryLink(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        FragmentEntryLink fragmentEntryLink = this._getFragmentEntryLink(fragmentRendererContext);
        StringBundler cacheKeySB = new StringBundler(5);
        cacheKeySB.append(fragmentEntryLink.getFragmentEntryLinkId());
        cacheKeySB.append("-");
        cacheKeySB.append((Object)fragmentRendererContext.getLocale());
        cacheKeySB.append("-");
        cacheKeySB.append(StringUtil.merge((long[])fragmentRendererContext.getSegmentsExperienceIds(), (String)";"));
        String content = "";
        if (Objects.equals(fragmentRendererContext.getMode(), "VIEW") && fragmentRendererContext.getPreviewClassPK() <= 0L && fragmentRendererContext.isUseCachedContent() && this._isCacheable(fragmentEntryLink) && Validator.isNotNull((String)(content = (String)_portalCache.get((Serializable)((Object)cacheKeySB.toString()))))) {
            return content;
        }
        DefaultFragmentEntryProcessorContext defaultFragmentEntryProcessorContext = new DefaultFragmentEntryProcessorContext(httpServletRequest, httpServletResponse, fragmentRendererContext.getMode(), fragmentRendererContext.getLocale());
        Optional displayObjectOptional = fragmentRendererContext.getDisplayObjectOptional();
        defaultFragmentEntryProcessorContext.setDisplayObject(displayObjectOptional.orElse(null));
        Optional fieldValuesOptional = fragmentRendererContext.getFieldValuesOptional();
        defaultFragmentEntryProcessorContext.setFieldValues((Map)fieldValuesOptional.orElse(null));
        defaultFragmentEntryProcessorContext.setPreviewClassNameId(fragmentRendererContext.getPreviewClassNameId());
        defaultFragmentEntryProcessorContext.setPreviewClassPK(fragmentRendererContext.getPreviewClassPK());
        defaultFragmentEntryProcessorContext.setPreviewType(fragmentRendererContext.getPreviewType());
        defaultFragmentEntryProcessorContext.setPreviewVersion(fragmentRendererContext.getPreviewVersion());
        defaultFragmentEntryProcessorContext.setSegmentsExperienceIds(fragmentRendererContext.getSegmentsExperienceIds());
        String css = "";
        if (Validator.isNotNull((String)fragmentEntryLink.getCss())) {
            css = this._fragmentEntryProcessorRegistry.processFragmentEntryLinkCSS(fragmentEntryLink, (FragmentEntryProcessorContext)defaultFragmentEntryProcessorContext);
        }
        String html = "";
        if (Validator.isNotNull((String)fragmentEntryLink.getHtml()) || Validator.isNotNull((String)fragmentEntryLink.getEditableValues())) {
            html = this._fragmentEntryProcessorRegistry.processFragmentEntryLinkHTML(fragmentEntryLink, (FragmentEntryProcessorContext)defaultFragmentEntryProcessorContext);
        }
        if (Objects.equals(defaultFragmentEntryProcessorContext.getMode(), "EDIT")) {
            html = this._writePortletPaths(fragmentEntryLink, html, httpServletRequest, httpServletResponse);
        }
        JSONObject configurationJSONObject = JSONFactoryUtil.createJSONObject();
        if (Validator.isNotNull((String)fragmentEntryLink.getConfiguration())) {
            configurationJSONObject = this._fragmentEntryConfigurationParser.getConfigurationJSONObject(fragmentEntryLink.getConfiguration(), fragmentEntryLink.getEditableValues());
        }
        content = this._renderFragmentEntry(fragmentEntryLink.getFragmentEntryId(), css, html, fragmentEntryLink.getJs(), configurationJSONObject.toString(), fragmentEntryLink.getNamespace(), httpServletRequest);
        if (Objects.equals(fragmentRendererContext.getMode(), "VIEW") && this._isCacheable(fragmentEntryLink)) {
            _portalCache.put((Serializable)((Object)cacheKeySB.toString()), (Object)content);
        }
        return content;
    }

    private String _writePortletPaths(FragmentEntryLink fragmentEntryLink, String html, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        this._portletRegistry.writePortletPaths(fragmentEntryLink, httpServletRequest, (HttpServletResponse)new PipingServletResponse(httpServletResponse, (Writer)unsyncStringWriter));
        unsyncStringWriter.append((CharSequence)html);
        return unsyncStringWriter.toString();
    }
}

