/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.util.configuration;

import com.liferay.fragment.constants.FragmentConfigurationFieldDataType;
import com.liferay.fragment.util.configuration.FragmentConfigurationField;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.frontend.token.definition.FrontendToken;
import com.liferay.frontend.token.definition.FrontendTokenDefinition;
import com.liferay.frontend.token.definition.FrontendTokenDefinitionRegistry;
import com.liferay.frontend.token.definition.FrontendTokenMapping;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.layout.list.retriever.DefaultLayoutListRetrieverContext;
import com.liferay.layout.list.retriever.LayoutListRetriever;
import com.liferay.layout.list.retriever.LayoutListRetrieverContext;
import com.liferay.layout.list.retriever.LayoutListRetrieverTracker;
import com.liferay.layout.list.retriever.ListObjectReferenceFactory;
import com.liferay.layout.list.retriever.ListObjectReferenceFactoryTracker;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentEntryConfigurationParser.class})
public class FragmentEntryConfigurationParserImpl
implements FragmentEntryConfigurationParser {
    private static final String _CONTEXT_OBJECT_LIST_SUFFIX = "ObjectList";
    private static final String _CONTEXT_OBJECT_SUFFIX = "Object";
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryConfigurationParserImpl.class);
    @Reference
    private FrontendTokenDefinitionRegistry _frontendTokenDefinitionRegistry;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private LayoutListRetrieverTracker _layoutListRetrieverTracker;
    @Reference
    private ListObjectReferenceFactoryTracker _listObjectReferenceFactoryTracker;

    public JSONObject getConfigurationDefaultValuesJSONObject(String configuration) {
        List<FragmentConfigurationField> fragmentConfigurationFields = this.getFragmentConfigurationFields(configuration);
        JSONObject defaultValuesJSONObject = JSONFactoryUtil.createJSONObject();
        for (FragmentConfigurationField fragmentConfigurationField : fragmentConfigurationFields) {
            defaultValuesJSONObject.put(fragmentConfigurationField.getName(), this.getFieldValue(fragmentConfigurationField, LocaleUtil.getMostRelevantLocale(), null));
        }
        return defaultValuesJSONObject;
    }

    public Object getConfigurationFieldValue(String editableValues, String fieldName, FragmentConfigurationFieldDataType fragmentConfigurationFieldDataType) {
        try {
            JSONObject editableValuesJSONObject = JSONFactoryUtil.createJSONObject((String)editableValues);
            JSONObject configurationValuesJSONObject = editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor");
            if (configurationValuesJSONObject == null) {
                return null;
            }
            return this._getFieldValue(fragmentConfigurationFieldDataType, configurationValuesJSONObject.getString(fieldName));
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to parse configuration JSON: " + editableValues), (Throwable)jsonException);
            }
            return null;
        }
    }

    public JSONObject getConfigurationJSONObject(String configuration, String editableValues, Locale locale) throws JSONException {
        JSONObject configurationDefaultValuesJSONObject = this.getConfigurationDefaultValuesJSONObject(configuration);
        if (configurationDefaultValuesJSONObject == null) {
            return JSONFactoryUtil.createJSONObject();
        }
        JSONObject editableValuesJSONObject = JSONFactoryUtil.createJSONObject((String)editableValues);
        JSONObject configurationValuesJSONObject = editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor");
        if (configurationValuesJSONObject == null) {
            return configurationDefaultValuesJSONObject;
        }
        List<FragmentConfigurationField> configurationFields = this.getFragmentConfigurationFields(configuration);
        for (FragmentConfigurationField configurationField : configurationFields) {
            String name = configurationField.getName();
            Object object = configurationValuesJSONObject.get(name);
            if (Validator.isNull((Object)object)) continue;
            configurationDefaultValuesJSONObject.put(name, this.getFieldValue(configurationField, locale, configurationValuesJSONObject.getString(name)));
        }
        return configurationDefaultValuesJSONObject;
    }

    public Map<String, Object> getContextObjects(JSONObject configurationValuesJSONObject, String configuration, long[] segmentsEntryIds) {
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        List<FragmentConfigurationField> fragmentConfigurationFields = this.getFragmentConfigurationFields(configuration);
        for (FragmentConfigurationField fragmentConfigurationField : fragmentConfigurationFields) {
            Object contextListObject;
            String name = fragmentConfigurationField.getName();
            if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"itemSelector")) {
                Object contextObject = this._getInfoDisplayObjectEntry(configurationValuesJSONObject.getString(name));
                if (contextObject == null) continue;
                contextObjects.put(name + _CONTEXT_OBJECT_SUFFIX, contextObject);
                continue;
            }
            if (!StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"collectionSelector") || (contextListObject = this._getInfoListObjectEntry(configurationValuesJSONObject.getString(name), segmentsEntryIds)) == null) continue;
            contextObjects.put(name + _CONTEXT_OBJECT_LIST_SUFFIX, contextListObject);
        }
        return contextObjects;
    }

    public Object getFieldValue(FragmentConfigurationField fragmentConfigurationField, Locale locale, String value) {
        value = GetterUtil.getString((String)value);
        if (fragmentConfigurationField.isLocalizable() && JSONUtil.isValid((String)value)) {
            try {
                JSONObject valueJSONObject = JSONFactoryUtil.createJSONObject((String)value);
                value = valueJSONObject.getString(LocaleUtil.toLanguageId((Locale)locale), valueJSONObject.getString(LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), fragmentConfigurationField.getDefaultValue()));
            }
            catch (JSONException jsonException) {
                _log.error((Object)"Unable to parse configuration value JSON", (Throwable)jsonException);
            }
        } else if (Validator.isNull((String)value)) {
            value = fragmentConfigurationField.getDefaultValue();
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"checkbox")) {
            return this._getFieldValue(FragmentConfigurationFieldDataType.BOOLEAN, value);
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"collectionSelector")) {
            return this._getInfoListObjectEntryJSONObject(value);
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"colorPalette")) {
            JSONObject jsonObject = (JSONObject)this._getFieldValue(FragmentConfigurationFieldDataType.OBJECT, value);
            if (jsonObject.isNull("color") && !jsonObject.isNull("cssClass")) {
                jsonObject.put("color", jsonObject.getString("cssClass"));
            }
            return jsonObject;
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"colorPicker")) {
            String fieldValue = (String)this._getFieldValue(FragmentConfigurationFieldDataType.STRING, value);
            return this._getColorPickerCssVariable(fieldValue);
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"itemSelector")) {
            return this._getInfoDisplayObjectEntryJSONObject(value);
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"select") || StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"text")) {
            FragmentConfigurationFieldDataType fragmentConfigurationFieldDataType = fragmentConfigurationField.getFragmentConfigurationFieldDataType();
            if (fragmentConfigurationFieldDataType == null) {
                fragmentConfigurationFieldDataType = FragmentConfigurationFieldDataType.STRING;
            }
            return this._getFieldValue(fragmentConfigurationFieldDataType, value);
        }
        return this._getFieldValue(FragmentConfigurationFieldDataType.STRING, value);
    }

    public Object getFieldValue(String editableValues, FragmentConfigurationField fragmentConfigurationField, Locale locale) {
        try {
            JSONObject editableValuesJSONObject = JSONFactoryUtil.createJSONObject((String)editableValues);
            JSONObject configurationValuesJSONObject = editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor");
            if (configurationValuesJSONObject == null) {
                return fragmentConfigurationField.getDefaultValue();
            }
            return this.getFieldValue(fragmentConfigurationField, locale, configurationValuesJSONObject.getString(fragmentConfigurationField.getName()));
        }
        catch (Exception exception) {
            return fragmentConfigurationField.getDefaultValue();
        }
    }

    public Object getFieldValue(String configuration, String editableValues, Locale locale, String name) {
        JSONObject editableValuesJSONObject = null;
        try {
            editableValuesJSONObject = JSONFactoryUtil.createJSONObject((String)editableValues);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
        JSONObject configurationValuesJSONObject = editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor");
        if (configurationValuesJSONObject == null) {
            return null;
        }
        List<FragmentConfigurationField> fragmentConfigurationFields = this.getFragmentConfigurationFields(configuration);
        for (FragmentConfigurationField fragmentConfigurationField : fragmentConfigurationFields) {
            if (!Objects.equals(fragmentConfigurationField.getName(), name)) continue;
            return this.getFieldValue(fragmentConfigurationField, locale, configurationValuesJSONObject.getString(name));
        }
        return null;
    }

    public List<FragmentConfigurationField> getFragmentConfigurationFields(String configuration) {
        JSONArray fieldSetsJSONArray = this._getFieldSetsJSONArray(configuration);
        if (fieldSetsJSONArray == null) {
            return Collections.emptyList();
        }
        ArrayList<FragmentConfigurationField> fragmentConfigurationFields = new ArrayList<FragmentConfigurationField>();
        Iterator iterator1 = fieldSetsJSONArray.iterator();
        iterator1.forEachRemaining(fieldSetJSONObject -> {
            JSONArray fieldSetFieldsJSONArray = fieldSetJSONObject.getJSONArray("fields");
            Iterator iterator2 = fieldSetFieldsJSONArray.iterator();
            iterator2.forEachRemaining(fieldSetFieldsJSONObject -> fragmentConfigurationFields.add(new FragmentConfigurationField(fieldSetFieldsJSONObject)));
        });
        return fragmentConfigurationFields;
    }

    public String translateConfiguration(JSONObject jsonObject, ResourceBundle resourceBundle) {
        JSONArray fieldSetsJSONArray = jsonObject.getJSONArray("fieldSets");
        if (fieldSetsJSONArray == null) {
            return "";
        }
        Iterator iterator = fieldSetsJSONArray.iterator();
        iterator.forEachRemaining(fieldSetJSONObject -> {
            String fieldSetLabel = fieldSetJSONObject.getString("label");
            fieldSetJSONObject.put("label", LanguageUtil.get((ResourceBundle)resourceBundle, (String)fieldSetLabel, (String)fieldSetLabel));
            JSONArray fieldsJSONArray = fieldSetJSONObject.getJSONArray("fields");
            Iterator fieldsIterator = fieldsJSONArray.iterator();
            fieldsIterator.forEachRemaining(fieldJSONObject -> this._translateConfigurationField((JSONObject)fieldJSONObject, resourceBundle));
        });
        return jsonObject.toString();
    }

    private String _getColorPickerCssVariable(String fieldValue) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null || Validator.isNull((String)fieldValue)) {
            return fieldValue;
        }
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        FrontendTokenDefinition frontendTokenDefinition = this._frontendTokenDefinitionRegistry.getFrontendTokenDefinition(themeDisplay.getThemeId());
        if (frontendTokenDefinition == null) {
            return fieldValue;
        }
        Collection frontendTokens = frontendTokenDefinition.getFrontendTokens();
        for (FrontendToken frontendToken : frontendTokens) {
            JSONObject jsonObject = frontendToken.getJSONObject(LocaleUtil.getMostRelevantLocale());
            if (!Objects.equals(jsonObject.getString("name"), fieldValue)) continue;
            ArrayList frontendTokenMappings = new ArrayList(frontendToken.getFrontendTokenMappings("cssVariable"));
            if (frontendTokenMappings.isEmpty()) {
                return fieldValue;
            }
            FrontendTokenMapping frontendTokenMapping = (FrontendTokenMapping)frontendTokenMappings.get(0);
            return "var(--" + frontendTokenMapping.getValue() + ")";
        }
        return fieldValue;
    }

    private JSONArray _getFieldSetsJSONArray(String configuration) {
        try {
            JSONObject configurationJSONObject = JSONFactoryUtil.createJSONObject((String)configuration);
            return configurationJSONObject.getJSONArray("fieldSets");
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to parse configuration JSON: " + configuration), (Throwable)jsonException);
            }
            return null;
        }
    }

    private Object _getFieldValue(FragmentConfigurationFieldDataType fragmentConfigurationFieldDataType, String value) {
        if (fragmentConfigurationFieldDataType == FragmentConfigurationFieldDataType.ARRAY) {
            try {
                return JSONFactoryUtil.createJSONArray((String)value);
            }
            catch (JSONException jsonException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to parse configuration JSON: " + value), (Throwable)jsonException);
                }
            }
        } else {
            if (fragmentConfigurationFieldDataType == FragmentConfigurationFieldDataType.BOOLEAN) {
                return GetterUtil.getBoolean((String)value);
            }
            if (fragmentConfigurationFieldDataType == FragmentConfigurationFieldDataType.DOUBLE) {
                return GetterUtil.getDouble((String)value);
            }
            if (fragmentConfigurationFieldDataType == FragmentConfigurationFieldDataType.INTEGER) {
                return GetterUtil.getInteger((String)value);
            }
            if (fragmentConfigurationFieldDataType == FragmentConfigurationFieldDataType.OBJECT) {
                try {
                    return JSONFactoryUtil.createJSONObject((String)value);
                }
                catch (JSONException jsonException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Unable to parse configuration JSON: " + value), (Throwable)jsonException);
                    }
                }
            } else if (fragmentConfigurationFieldDataType == FragmentConfigurationFieldDataType.STRING) {
                return value;
            }
        }
        return null;
    }

    private Object _getInfoDisplayObjectEntry(String value) {
        if (Validator.isNull((String)value)) {
            return null;
        }
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)value);
            String className = GetterUtil.getString((String)jsonObject.getString("className"));
            InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemObjectProvider.class, className);
            if (infoItemObjectProvider == null) {
                return null;
            }
            long classPK = GetterUtil.getLong((String)jsonObject.getString("classPK"));
            return infoItemObjectProvider.getInfoItem((InfoItemIdentifier)new ClassPKInfoItemIdentifier(classPK));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get entry: " + value), (Throwable)exception);
            }
            return null;
        }
    }

    private JSONObject _getInfoDisplayObjectEntryJSONObject(String value) {
        if (Validator.isNull((String)value) || Objects.equals(value, JSONFactoryUtil.getNullJSON())) {
            return JSONFactoryUtil.createJSONObject();
        }
        try {
            JSONObject configurationValueJSONObject = JSONFactoryUtil.createJSONObject((String)value);
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)this._getInfoDisplayObjectEntry(value)));
            jsonObject.put("className", GetterUtil.getString((String)configurationValueJSONObject.getString("className"))).put("classNameId", GetterUtil.getString((String)configurationValueJSONObject.getString("classNameId"))).put("classPK", GetterUtil.getLong((String)configurationValueJSONObject.getString("classPK"))).put("template", configurationValueJSONObject.get("template")).put("title", configurationValueJSONObject.getString("title"));
            return jsonObject;
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to serialize info display object entry to JSON: " + value), (Throwable)jsonException);
            }
            return null;
        }
    }

    private Object _getInfoListObjectEntry(String value, long[] segmentsEntryIds) {
        if (Validator.isNull((String)value)) {
            return Collections.emptyList();
        }
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)value);
            if (jsonObject.length() <= 0) {
                return Collections.emptyList();
            }
            String type = jsonObject.getString("type");
            LayoutListRetriever layoutListRetriever = this._layoutListRetrieverTracker.getLayoutListRetriever(type);
            if (layoutListRetriever == null) {
                return Collections.emptyList();
            }
            ListObjectReferenceFactory listObjectReferenceFactory = this._listObjectReferenceFactoryTracker.getListObjectReference(type);
            if (listObjectReferenceFactory == null) {
                return Collections.emptyList();
            }
            DefaultLayoutListRetrieverContext defaultLayoutListRetrieverContext = new DefaultLayoutListRetrieverContext();
            defaultLayoutListRetrieverContext.setSegmentsEntryIds(segmentsEntryIds);
            return layoutListRetriever.getList(listObjectReferenceFactory.getListObjectReference(jsonObject), (LayoutListRetrieverContext)defaultLayoutListRetrieverContext);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get collection: " + value), (Throwable)exception);
            }
            return Collections.emptyList();
        }
    }

    private JSONObject _getInfoListObjectEntryJSONObject(String value) {
        if (Validator.isNull((String)value)) {
            return JSONFactoryUtil.createJSONObject();
        }
        try {
            return JSONFactoryUtil.createJSONObject((String)value);
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to serialize info list object entry to JSON: " + value), (Throwable)jsonException);
            }
            return null;
        }
    }

    private void _translateConfigurationField(JSONObject fieldJSONObject, ResourceBundle resourceBundle) {
        String fieldDescription = fieldJSONObject.getString("description");
        fieldJSONObject.put("description", LanguageUtil.get((ResourceBundle)resourceBundle, (String)fieldDescription, (String)fieldDescription));
        String fieldLabel = fieldJSONObject.getString("label");
        fieldJSONObject.put("label", LanguageUtil.get((ResourceBundle)resourceBundle, (String)fieldLabel, (String)fieldLabel));
        String type = fieldJSONObject.getString("type");
        if (!Objects.equals(type, "select") && !Objects.equals(type, "text")) {
            return;
        }
        JSONObject typeOptionsJSONObject = fieldJSONObject.getJSONObject("typeOptions");
        if (typeOptionsJSONObject == null) {
            return;
        }
        if (Objects.equals(type, "select")) {
            JSONArray validValuesJSONArray = typeOptionsJSONObject.getJSONArray("validValues");
            Iterator validValuesIterator = validValuesJSONArray.iterator();
            validValuesIterator.forEachRemaining(validValueJSONObject -> {
                String value = validValueJSONObject.getString("value");
                String label = validValueJSONObject.getString("label", value);
                validValueJSONObject.put("label", LanguageUtil.get((ResourceBundle)resourceBundle, (String)label, (String)label));
            });
        } else {
            JSONObject validationJSONObject = typeOptionsJSONObject.getJSONObject("validation");
            if (validationJSONObject != null && validationJSONObject.has("errorMessage")) {
                String errorMessage = validationJSONObject.getString("errorMessage");
                validationJSONObject.put("errorMessage", LanguageUtil.get((ResourceBundle)resourceBundle, (String)errorMessage, (String)errorMessage));
            }
        }
    }
}

