/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.helper;

import com.liferay.fragment.contributor.FragmentCollectionContributorTracker;
import com.liferay.fragment.helper.FragmentEntryLinkHelper;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererTracker;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FragmentEntryLinkHelper.class})
public class FragmentEntryLinkHelperImpl
implements FragmentEntryLinkHelper {
    @Reference
    private FragmentCollectionContributorTracker _fragmentCollectionContributorTracker;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private FragmentRendererTracker _fragmentRendererTracker;

    public String getFragmentEntryName(FragmentEntryLink fragmentEntryLink, Locale locale) {
        FragmentEntry fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(fragmentEntryLink.getFragmentEntryId());
        if (fragmentEntry != null) {
            return fragmentEntry.getName();
        }
        String rendererKey = fragmentEntryLink.getRendererKey();
        if (Validator.isNull((String)rendererKey)) {
            return "";
        }
        Map fragmentEntries = this._fragmentCollectionContributorTracker.getFragmentEntries(locale);
        FragmentEntry contributedFragmentEntry = (FragmentEntry)fragmentEntries.get(rendererKey);
        if (contributedFragmentEntry != null) {
            return contributedFragmentEntry.getName();
        }
        FragmentRenderer fragmentRenderer = this._fragmentRendererTracker.getFragmentRenderer(fragmentEntryLink.getRendererKey());
        if (fragmentRenderer != null) {
            return fragmentRenderer.getLabel(locale);
        }
        return "";
    }
}

