/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.processor;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FragmentEntryProcessorRegistry.class})
public class FragmentEntryProcessorRegistryImpl
implements FragmentEntryProcessorRegistry {
    private static final ThreadLocal<Set<String>> _validHTMLsThreadLocal = new CentralizedThreadLocal(FragmentEntryProcessorRegistryImpl.class.getName() + "._validHTMLsThreadLocal", HashSet::new);
    @Reference
    private JSONFactory _jsonFactory;
    private ServiceTrackerList<FragmentEntryProcessor> _serviceTrackerList;

    public JSONArray getAvailableTagsJSONArray() {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (FragmentEntryProcessor fragmentEntryProcessor : this._serviceTrackerList) {
            JSONArray availableTagsJSONArray = fragmentEntryProcessor.getAvailableTagsJSONArray();
            if (availableTagsJSONArray == null) continue;
            for (int i = 0; i < availableTagsJSONArray.length(); ++i) {
                jsonArray.put(availableTagsJSONArray.getJSONObject(i));
            }
        }
        return jsonArray;
    }

    public JSONArray getDataAttributesJSONArray() {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (FragmentEntryProcessor fragmentEntryProcessor : this._serviceTrackerList) {
            JSONArray dataAttributesJSONArray = fragmentEntryProcessor.getDataAttributesJSONArray();
            if (dataAttributesJSONArray == null) continue;
            for (int i = 0; i < dataAttributesJSONArray.length(); ++i) {
                jsonArray.put(dataAttributesJSONArray.getString(i));
            }
        }
        return jsonArray;
    }

    public JSONObject getDefaultEditableValuesJSONObject(String html, String configuration) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        for (FragmentEntryProcessor fragmentEntryProcessor : this._serviceTrackerList) {
            JSONObject defaultEditableValuesJSONObject = fragmentEntryProcessor.getDefaultEditableValuesJSONObject(html, configuration);
            if (defaultEditableValuesJSONObject == null || defaultEditableValuesJSONObject.length() <= 0) continue;
            Class<?> clazz = fragmentEntryProcessor.getClass();
            jsonObject.put(clazz.getName(), defaultEditableValuesJSONObject);
        }
        return jsonObject;
    }

    public String processFragmentEntryLinkCSS(FragmentEntryLink fragmentEntryLink, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        String css = fragmentEntryLink.getCss();
        for (FragmentEntryProcessor fragmentEntryProcessor : this._serviceTrackerList) {
            css = fragmentEntryProcessor.processFragmentEntryLinkCSS(fragmentEntryLink, css, fragmentEntryProcessorContext);
        }
        return css;
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        String html = fragmentEntryLink.getHtml();
        for (FragmentEntryProcessor fragmentEntryProcessor : this._serviceTrackerList) {
            html = fragmentEntryProcessor.processFragmentEntryLinkHTML(fragmentEntryLink, html, fragmentEntryProcessorContext);
        }
        return html;
    }

    public void validateFragmentEntryHTML(String html, String configuration) throws PortalException {
        if (CompanyThreadLocal.isInitializingPortalInstance()) {
            return;
        }
        Set<String> validHTMLs = _validHTMLsThreadLocal.get();
        if (validHTMLs.contains(html)) {
            return;
        }
        for (FragmentEntryProcessor fragmentEntryProcessor : this._serviceTrackerList) {
            fragmentEntryProcessor.validateFragmentEntryHTML(html, configuration);
        }
        validHTMLs.add(html);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, FragmentEntryProcessor.class, Collections.reverseOrder(new PropertyServiceReferenceComparator("fragment.entry.processor.priority")));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }
}

