/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.fragment.contributor.FragmentCollectionContributorTracker;
import com.liferay.fragment.input.template.parser.FragmentEntryInputTemplateNodeContextHelper;
import com.liferay.fragment.input.template.parser.InputTemplateNode;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.DefaultFragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.info.form.InfoForm;
import com.liferay.item.selector.ItemSelector;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.servlet.taglib.util.OutputData;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentRenderer.class})
public class FragmentEntryFragmentRenderer
implements FragmentRenderer {
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private FragmentCollectionContributorTracker _fragmentCollectionContributorTracker;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private ItemSelector _itemSelector;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private MultiVMPool _multiVMPool;
    @Reference
    private Portal _portal;
    @Reference
    private PortletRegistry _portletRegistry;

    public String getCollectionKey() {
        return "";
    }

    public String getConfiguration(FragmentRendererContext fragmentRendererContext) {
        FragmentEntryLink fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink();
        return fragmentEntryLink.getConfiguration();
    }

    public String getKey() {
        return "FRAGMENT_ENTRY_FRAGMENT_RENDERER_KEY";
    }

    public boolean isSelectable(HttpServletRequest httpServletRequest) {
        return false;
    }

    public void render(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.write(this._renderFragmentEntryLink(fragmentRendererContext, httpServletRequest, httpServletResponse));
        }
        catch (PortalException portalException) {
            throw new IOException(portalException);
        }
    }

    private FragmentEntry _getContributedFragmentEntry(FragmentEntryLink fragmentEntryLink) {
        Map fragmentCollectionContributorEntries = this._fragmentCollectionContributorTracker.getFragmentEntries();
        return (FragmentEntry)fragmentCollectionContributorEntries.get(fragmentEntryLink.getRendererKey());
    }

    private FragmentEntryLink _getFragmentEntryLink(FragmentRendererContext fragmentRendererContext) {
        FragmentEntryLink fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink();
        FragmentEntry fragmentEntry = this._getContributedFragmentEntry(fragmentEntryLink);
        if (fragmentEntry != null) {
            fragmentEntryLink.setCss(fragmentEntry.getCss());
            fragmentEntryLink.setHtml(fragmentEntry.getHtml());
            fragmentEntryLink.setJs(fragmentEntry.getJs());
            fragmentEntryLink.setType(fragmentEntry.getType());
        }
        return fragmentEntryLink;
    }

    private String _getFragmentEntryName(FragmentEntryLink fragmentEntryLink) {
        FragmentEntry fragmentEntry = null;
        if (Validator.isNotNull((String)fragmentEntryLink.getRendererKey())) {
            fragmentEntry = this._fragmentCollectionContributorTracker.getFragmentEntry(fragmentEntryLink.getRendererKey());
        }
        if (fragmentEntry == null) {
            fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(fragmentEntryLink.getFragmentEntryId());
        }
        if (fragmentEntry == null) {
            return "";
        }
        return fragmentEntry.getName();
    }

    private JSONObject _getInputJSONObject(FragmentEntryLink fragmentEntryLink, HttpServletRequest httpServletRequest, Optional<InfoForm> infoFormOptional, Locale locale) {
        FragmentEntryInputTemplateNodeContextHelper fragmentEntryInputTemplateNodeContextHelper = new FragmentEntryInputTemplateNodeContextHelper(this._getFragmentEntryName(fragmentEntryLink), this._dlAppLocalService, this._fragmentEntryConfigurationParser, this._itemSelector);
        InputTemplateNode inputTemplateNode = fragmentEntryInputTemplateNodeContextHelper.toInputTemplateNode(fragmentEntryLink, httpServletRequest, infoFormOptional, locale);
        return inputTemplateNode.toJSONObject();
    }

    private boolean _isCacheable(FragmentEntryLink fragmentEntryLink, FragmentRendererContext fragmentRendererContext) {
        Layout layout;
        if (fragmentEntryLink.isTypeInput() || !Objects.equals(fragmentRendererContext.getMode(), "VIEW") || fragmentRendererContext.getPreviewClassPK() > 0L || !fragmentRendererContext.isUseCachedContent()) {
            return false;
        }
        if (fragmentEntryLink.getPlid() > 0L && (layout = this._layoutLocalService.fetchLayout(fragmentEntryLink.getPlid())).isDraftLayout()) {
            return false;
        }
        FragmentEntry fragmentEntry = null;
        if (Validator.isNotNull((String)fragmentEntryLink.getRendererKey()) && (fragmentEntry = this._fragmentCollectionContributorTracker.getFragmentEntry(fragmentEntryLink.getRendererKey())) == null) {
            return false;
        }
        if (fragmentEntry == null) {
            fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(fragmentEntryLink.getFragmentEntryId());
        }
        if (fragmentEntry == null) {
            return fragmentEntryLink.isCacheable();
        }
        return fragmentEntry.isCacheable();
    }

    private String _renderFragmentEntry(String configuration, String css, FragmentRendererContext fragmentRendererContext, String html, HttpServletRequest httpServletRequest) {
        FragmentEntryLink fragmentEntryLink;
        StringBundler sb = new StringBundler(23);
        sb.append("<div id=\"");
        sb.append(fragmentRendererContext.getFragmentElementId());
        sb.append("\" >");
        sb.append(html);
        sb.append("</div>");
        if (Validator.isNotNull((String)css)) {
            String outputKey = fragmentRendererContext.getFragmentElementId() + "_CSS";
            OutputData outputData = (OutputData)httpServletRequest.getAttribute("LIFERAY_SHARED_OUTPUT_DATA");
            boolean cssLoaded = false;
            if (outputData != null) {
                Set outputKeys = outputData.getOutputKeys();
                cssLoaded = outputKeys.contains(outputKey);
                StringBundler cssSB = outputData.getDataSB(outputKey, "");
                if (cssSB != null) {
                    cssLoaded = Objects.equals(cssSB.toString(), css);
                }
            } else {
                outputData = new OutputData();
            }
            if (!cssLoaded || Objects.equals(fragmentRendererContext.getMode(), "EDIT")) {
                sb.append("<style>");
                sb.append(css);
                sb.append("</style>");
                outputData.addOutputKey(outputKey);
                outputData.setDataSB(outputKey, "", new StringBundler(css));
                httpServletRequest.setAttribute("LIFERAY_SHARED_OUTPUT_DATA", (Object)outputData);
            }
        }
        if (Validator.isNotNull((String)(fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink()).getJs())) {
            sb.append("<script>(function() {");
            sb.append("var configuration = ");
            sb.append(configuration);
            sb.append("; var fragmentElement = document.querySelector('#");
            sb.append(fragmentRendererContext.getFragmentElementId());
            sb.append("'); var fragmentNamespace = '");
            sb.append(fragmentEntryLink.getNamespace());
            sb.append("'");
            if (fragmentEntryLink.isTypeInput()) {
                sb.append("; var input = ");
                sb.append(JSONUtil.toString((JSONObject)this._getInputJSONObject(fragmentEntryLink, httpServletRequest, fragmentRendererContext.getInfoFormOptional(), fragmentRendererContext.getLocale())));
            }
            sb.append("; var layoutMode = '");
            sb.append(HtmlUtil.escapeJS((String)ParamUtil.getString((HttpServletRequest)this._portal.getOriginalServletRequest(httpServletRequest), (String)"p_l_mode", (String)"view")));
            sb.append("';");
            sb.append(fragmentEntryLink.getJs());
            sb.append(";}());</script>");
        }
        return sb.toString();
    }

    private String _renderFragmentEntryLink(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        PortalCache portalCache = this._multiVMPool.getPortalCache(FragmentEntryLink.class.getName());
        FragmentEntryLink fragmentEntryLink = this._getFragmentEntryLink(fragmentRendererContext);
        StringBundler cacheKeySB = new StringBundler(5);
        cacheKeySB.append(fragmentEntryLink.getFragmentEntryLinkId());
        cacheKeySB.append("-");
        cacheKeySB.append((Object)fragmentRendererContext.getLocale());
        cacheKeySB.append("-");
        cacheKeySB.append(StringUtil.merge((long[])fragmentRendererContext.getSegmentsEntryIds(), (String)";"));
        String content = "";
        if (this._isCacheable(fragmentEntryLink, fragmentRendererContext) && Validator.isNotNull((String)(content = (String)portalCache.get((Serializable)((Object)cacheKeySB.toString()))))) {
            return content;
        }
        DefaultFragmentEntryProcessorContext defaultFragmentEntryProcessorContext = new DefaultFragmentEntryProcessorContext(httpServletRequest, httpServletResponse, fragmentRendererContext.getMode(), fragmentRendererContext.getLocale());
        Optional displayObjectOptional = fragmentRendererContext.getDisplayObjectOptional();
        defaultFragmentEntryProcessorContext.setDisplayObject(displayObjectOptional.orElse(null));
        defaultFragmentEntryProcessorContext.setFragmentElementId(fragmentRendererContext.getFragmentElementId());
        Optional infoFormOptional = fragmentRendererContext.getInfoFormOptional();
        defaultFragmentEntryProcessorContext.setInfoForm((InfoForm)infoFormOptional.orElse(null));
        defaultFragmentEntryProcessorContext.setPreviewClassNameId(fragmentRendererContext.getPreviewClassNameId());
        defaultFragmentEntryProcessorContext.setPreviewClassPK(fragmentRendererContext.getPreviewClassPK());
        defaultFragmentEntryProcessorContext.setPreviewType(fragmentRendererContext.getPreviewType());
        defaultFragmentEntryProcessorContext.setPreviewVersion(fragmentRendererContext.getPreviewVersion());
        defaultFragmentEntryProcessorContext.setSegmentsEntryIds(fragmentRendererContext.getSegmentsEntryIds());
        String css = "";
        if (Validator.isNotNull((String)fragmentEntryLink.getCss())) {
            css = this._fragmentEntryProcessorRegistry.processFragmentEntryLinkCSS(fragmentEntryLink, (FragmentEntryProcessorContext)defaultFragmentEntryProcessorContext);
        }
        String html = "";
        if (Validator.isNotNull((String)fragmentEntryLink.getHtml()) || Validator.isNotNull((String)fragmentEntryLink.getEditableValues())) {
            html = this._fragmentEntryProcessorRegistry.processFragmentEntryLinkHTML(fragmentEntryLink, (FragmentEntryProcessorContext)defaultFragmentEntryProcessorContext);
        }
        if (Objects.equals(defaultFragmentEntryProcessorContext.getMode(), "EDIT")) {
            html = this._writePortletPaths(fragmentEntryLink, html, httpServletRequest, httpServletResponse);
        }
        JSONObject configurationJSONObject = JSONFactoryUtil.createJSONObject();
        if (Validator.isNotNull((String)fragmentEntryLink.getConfiguration())) {
            configurationJSONObject = this._fragmentEntryConfigurationParser.getConfigurationJSONObject(fragmentEntryLink.getConfiguration(), fragmentEntryLink.getEditableValues(), fragmentRendererContext.getLocale());
        }
        content = this._renderFragmentEntry(configurationJSONObject.toString(), css, fragmentRendererContext, html, httpServletRequest);
        if (this._isCacheable(fragmentEntryLink, fragmentRendererContext)) {
            portalCache.put((Serializable)((Object)cacheKeySB.toString()), (Object)content);
        }
        return content;
    }

    private String _writePortletPaths(FragmentEntryLink fragmentEntryLink, String html, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        this._portletRegistry.writePortletPaths(fragmentEntryLink, httpServletRequest, (HttpServletResponse)new PipingServletResponse(httpServletResponse, (Writer)unsyncStringWriter));
        unsyncStringWriter.append((CharSequence)html);
        return unsyncStringWriter.toString();
    }
}

