/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.contributor;

import com.liferay.fragment.configuration.FragmentServiceConfiguration;
import com.liferay.fragment.contributor.FragmentCollectionContributor;
import com.liferay.fragment.contributor.FragmentCollectionContributorRegistry;
import com.liferay.fragment.model.FragmentComposition;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.validator.FragmentEntryValidator;
import com.liferay.layout.util.LayoutServiceContextHelper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.resource.bundle.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.PortalPreferencesLocalService;
import com.liferay.portal.kernel.util.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletPreferences;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={FragmentCollectionContributorRegistry.class})
public class FragmentCollectionContributorRegistryImpl
implements FragmentCollectionContributorRegistry {
    @Reference
    protected FragmentEntryProcessorRegistry fragmentEntryProcessorRegistry;
    @Reference
    protected FragmentEntryValidator fragmentEntryValidator;
    private static final int[] _SUPPORTED_FRAGMENT_TYPES = new int[]{1, 3, 0};
    private static final Log _log = LogFactoryUtil.getLog(FragmentCollectionContributorRegistryImpl.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private LayoutServiceContextHelper _layoutServiceContextHelper;
    @Reference
    private PortalPreferencesLocalService _portalPreferencesLocalService;
    private ServiceTrackerMap<String, FragmentCollectionBag> _serviceTrackerMap;

    public FragmentCollectionContributor getFragmentCollectionContributor(String fragmentCollectionKey) {
        FragmentCollectionBag fragmentCollectionBag = (FragmentCollectionBag)this._serviceTrackerMap.getService((Object)fragmentCollectionKey);
        if (fragmentCollectionBag == null) {
            return null;
        }
        return fragmentCollectionBag._fragmentCollectionContributor;
    }

    public List<FragmentCollectionContributor> getFragmentCollectionContributors() {
        ArrayList<FragmentCollectionContributor> fragmentCollectionContributors = new ArrayList<FragmentCollectionContributor>();
        for (FragmentCollectionBag fragmentCollectionBag : this._serviceTrackerMap.values()) {
            FragmentCollectionContributor fragmentCollectionContributor = fragmentCollectionBag._fragmentCollectionContributor;
            if (!MapUtil.isNotEmpty((Map)fragmentCollectionContributor.getNames())) continue;
            fragmentCollectionContributors.add(fragmentCollectionContributor);
        }
        return fragmentCollectionContributors;
    }

    public FragmentComposition getFragmentComposition(String fragmentCompositionKey) {
        int index = fragmentCompositionKey.indexOf("-composition-");
        if (index == -1) {
            return null;
        }
        FragmentCollectionBag fragmentCollectionBag = (FragmentCollectionBag)this._serviceTrackerMap.getService((Object)fragmentCompositionKey.substring(0, index));
        if (fragmentCollectionBag == null) {
            return null;
        }
        Map fragmentCompostions = fragmentCollectionBag._fragmentCompostions;
        return (FragmentComposition)fragmentCompostions.get(fragmentCompositionKey);
    }

    public Map<String, FragmentEntry> getFragmentEntries() {
        HashMap<String, FragmentEntry> fragmentEntries = new HashMap<String, FragmentEntry>();
        for (FragmentCollectionBag fragmentCollectionBag : this._serviceTrackerMap.values()) {
            fragmentEntries.putAll(fragmentCollectionBag._fragmentEntries);
        }
        return fragmentEntries;
    }

    public Map<String, FragmentEntry> getFragmentEntries(Locale locale) {
        HashMap<String, FragmentEntry> fragmentEntries = new HashMap<String, FragmentEntry>();
        for (FragmentCollectionBag fragmentCollectionBag : this._serviceTrackerMap.values()) {
            FragmentCollectionContributor fragmentCollectionContributor = fragmentCollectionBag._fragmentCollectionContributor;
            for (FragmentEntry fragmentEntry : fragmentCollectionContributor.getFragmentEntries(_SUPPORTED_FRAGMENT_TYPES, locale)) {
                fragmentEntries.put(fragmentEntry.getFragmentEntryKey(), fragmentEntry);
            }
        }
        return fragmentEntries;
    }

    public FragmentEntry getFragmentEntry(String fragmentEntryKey) {
        if (fragmentEntryKey == null) {
            return null;
        }
        int index = fragmentEntryKey.indexOf(45);
        if (index == -1) {
            return null;
        }
        FragmentCollectionBag fragmentCollectionBag = (FragmentCollectionBag)this._serviceTrackerMap.getService((Object)fragmentEntryKey.substring(0, index));
        if (fragmentCollectionBag == null) {
            return null;
        }
        Map fragmentEntries = fragmentCollectionBag._fragmentEntries;
        return (FragmentEntry)fragmentEntries.get(fragmentEntryKey);
    }

    public ResourceBundleLoader getResourceBundleLoader() {
        ArrayList<ResourceBundleLoader> resourceBundleLoaders = new ArrayList<ResourceBundleLoader>();
        for (FragmentCollectionBag fragmentCollectionBag : this._serviceTrackerMap.values()) {
            FragmentCollectionContributor fragmentCollectionContributor = fragmentCollectionBag._fragmentCollectionContributor;
            ResourceBundleLoader resourceBundleLoader = fragmentCollectionContributor.getResourceBundleLoader();
            if (resourceBundleLoader == null) continue;
            resourceBundleLoaders.add(resourceBundleLoader);
        }
        return new AggregateResourceBundleLoader(resourceBundleLoaders.toArray(new ResourceBundleLoader[0]));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, FragmentCollectionContributor.class, (String)"fragment.collection.key", (ServiceTrackerCustomizer)new FragmentCollectionContributorServiceTrackerCustomizer(bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private Configuration _getFragmentServiceCompanyConfiguration(long companyId) throws ConfigurationException {
        try {
            String filterString = StringBundler.concat((Object[])new Object[]{"(&(", "service.factoryPid", "=", FragmentServiceConfiguration.class.getName(), ".scoped", ")(companyId=", companyId, "))"});
            Configuration[] configurations = this._configurationAdmin.listConfigurations(filterString);
            if (configurations != null) {
                return configurations[0];
            }
            return null;
        }
        catch (IOException | InvalidSyntaxException exception) {
            throw new ConfigurationException(exception);
        }
    }

    private boolean _isPropagateContributedFragmentChanges(long companyId) throws ConfigurationException {
        if (this._getFragmentServiceCompanyConfiguration(companyId) != null) {
            FragmentServiceConfiguration companyFragmentServiceConfiguration = (FragmentServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(FragmentServiceConfiguration.class, (long)companyId);
            return companyFragmentServiceConfiguration.propagateContributedFragmentChanges();
        }
        FragmentServiceConfiguration systemFragmentServiceConfiguration = (FragmentServiceConfiguration)ConfigurationProviderUtil.getSystemConfiguration(FragmentServiceConfiguration.class);
        return systemFragmentServiceConfiguration.propagateContributedFragmentChanges();
    }

    private void _updateFragmentEntryLinks(Map<String, FragmentEntry> fragmentEntries) {
        this._companyLocalService.forEachCompany(company -> {
            try {
                if (!this._isPropagateContributedFragmentChanges(company.getCompanyId())) {
                    PortletPreferences portletPreferences = this._portalPreferencesLocalService.getPreferences(company.getCompanyId(), 1);
                    portletPreferences.setValue("alreadyPropagateContributedFragmentChanges", Boolean.FALSE.toString());
                    portletPreferences.store();
                    return;
                }
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
                return;
            }
            try (AutoCloseable autoCloseable = this._layoutServiceContextHelper.getServiceContextAutoCloseable(company);){
                Set fragmentEntriesSet = fragmentEntries.keySet();
                List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(company.getCompanyId(), fragmentEntriesSet.toArray(new String[0]));
                for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
                    FragmentEntry fragmentEntry = (FragmentEntry)fragmentEntries.get(fragmentEntryLink.getRendererKey());
                    if (fragmentEntry == null) continue;
                    try {
                        this._fragmentEntryLinkLocalService.updateLatestChanges(fragmentEntry, fragmentEntryLink);
                    }
                    catch (PortalException portalException) {
                        _log.error((Throwable)portalException);
                    }
                }
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        });
    }

    private boolean _validateFragmentEntry(FragmentEntry fragmentEntry) {
        try {
            this.fragmentEntryValidator.validateConfiguration(fragmentEntry.getConfiguration());
            this.fragmentEntryValidator.validateTypeOptions(fragmentEntry.getType(), fragmentEntry.getTypeOptions());
            this.fragmentEntryProcessorRegistry.validateFragmentEntryHTML(fragmentEntry.getHtml(), fragmentEntry.getConfiguration());
            return true;
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to validate fragment entry", (Throwable)portalException);
            return false;
        }
    }

    private class FragmentCollectionContributorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<FragmentCollectionContributor, FragmentCollectionBag> {
        private final BundleContext _bundleContext;

        public FragmentCollectionBag addingService(ServiceReference<FragmentCollectionContributor> serviceReference) {
            FragmentCollectionContributor fragmentCollectionContributor = (FragmentCollectionContributor)this._bundleContext.getService(serviceReference);
            HashMap<String, FragmentComposition> fragmentCompositions = new HashMap<String, FragmentComposition>();
            HashMap<String, FragmentEntry> fragmentEntries = new HashMap<String, FragmentEntry>();
            for (FragmentComposition fragmentComposition : fragmentCollectionContributor.getFragmentCompositions()) {
                fragmentCompositions.put(fragmentComposition.getFragmentCompositionKey(), fragmentComposition);
            }
            for (FragmentEntry fragmentEntry : fragmentCollectionContributor.getFragmentEntries(_SUPPORTED_FRAGMENT_TYPES)) {
                if (!FragmentCollectionContributorRegistryImpl.this._validateFragmentEntry(fragmentEntry)) continue;
                fragmentEntries.put(fragmentEntry.getFragmentEntryKey(), fragmentEntry);
            }
            FragmentCollectionContributorRegistryImpl.this._updateFragmentEntryLinks(fragmentEntries);
            return new FragmentCollectionBag(fragmentCollectionContributor, fragmentCompositions, fragmentEntries);
        }

        public void modifiedService(ServiceReference<FragmentCollectionContributor> serviceReference, FragmentCollectionBag fragmentCollectionBag) {
        }

        public void removedService(ServiceReference<FragmentCollectionContributor> serviceReference, FragmentCollectionBag fragmentCollectionBag) {
            this._bundleContext.ungetService(serviceReference);
        }

        private FragmentCollectionContributorServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }
    }

    private static class FragmentCollectionBag {
        private final FragmentCollectionContributor _fragmentCollectionContributor;
        private final Map<String, FragmentComposition> _fragmentCompostions;
        private final Map<String, FragmentEntry> _fragmentEntries;

        private FragmentCollectionBag(FragmentCollectionContributor fragmentCollectionContributor, Map<String, FragmentComposition> fragmentCompostions, Map<String, FragmentEntry> fragmentEntries) {
            this._fragmentCollectionContributor = fragmentCollectionContributor;
            this._fragmentCompostions = fragmentCompostions;
            this._fragmentEntries = fragmentEntries;
        }
    }
}

