/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.processor;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.CSSFragmentEntryProcessor;
import com.liferay.fragment.processor.DocumentFragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryAutocompleteContributor;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.processor.FragmentEntryValidator;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentEntryProcessorRegistry.class})
public class FragmentEntryProcessorRegistryImpl
implements FragmentEntryProcessorRegistry {
    private static final ThreadLocal<Set<String>> _validHTMLsThreadLocal = new CentralizedThreadLocal(FragmentEntryProcessorRegistryImpl.class.getName() + "._validHTMLsThreadLocal", HashSet::new);
    private ServiceTrackerList<CSSFragmentEntryProcessor> _cssFragmentEntryProcessors;
    private ServiceTrackerList<DocumentFragmentEntryProcessor> _documentFragmentEntryProcessors;
    private ServiceTrackerList<FragmentEntryAutocompleteContributor> _fragmentEntryAutocompleteContributors;
    private ServiceTrackerList<FragmentEntryProcessor> _fragmentEntryProcessors;
    private ServiceTrackerList<FragmentEntryValidator> _fragmentEntryValidators;
    @Reference
    private JSONFactory _jsonFactory;

    public JSONArray getAvailableTagsJSONArray() {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (FragmentEntryAutocompleteContributor fragmentEntryAutocompleteContributor : this._fragmentEntryAutocompleteContributors) {
            JSONArray availableTagsJSONArray = fragmentEntryAutocompleteContributor.getAvailableTagsJSONArray();
            if (availableTagsJSONArray == null) continue;
            for (int i = 0; i < availableTagsJSONArray.length(); ++i) {
                jsonArray.put(availableTagsJSONArray.getJSONObject(i));
            }
        }
        return jsonArray;
    }

    public JSONArray getDataAttributesJSONArray() {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (FragmentEntryProcessor fragmentEntryProcessor : this._fragmentEntryProcessors) {
            JSONArray dataAttributesJSONArray = fragmentEntryProcessor.getDataAttributesJSONArray();
            if (dataAttributesJSONArray == null) continue;
            for (int i = 0; i < dataAttributesJSONArray.length(); ++i) {
                jsonArray.put(dataAttributesJSONArray.getString(i));
            }
        }
        return jsonArray;
    }

    public JSONObject getDefaultEditableValuesJSONObject(String html, String configuration) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        for (FragmentEntryProcessor fragmentEntryProcessor : this._fragmentEntryProcessors) {
            JSONObject defaultEditableValuesJSONObject = fragmentEntryProcessor.getDefaultEditableValuesJSONObject(html, configuration);
            if (defaultEditableValuesJSONObject == null || defaultEditableValuesJSONObject.length() <= 0) continue;
            Class<?> clazz = fragmentEntryProcessor.getClass();
            jsonObject.put(clazz.getName(), defaultEditableValuesJSONObject);
        }
        return jsonObject;
    }

    public String processFragmentEntryLinkCSS(FragmentEntryLink fragmentEntryLink, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        String css = fragmentEntryLink.getCss();
        for (CSSFragmentEntryProcessor cssFragmentEntryProcessor : this._cssFragmentEntryProcessors) {
            css = cssFragmentEntryProcessor.processFragmentEntryLinkCSS(fragmentEntryLink, css, fragmentEntryProcessorContext);
        }
        return css;
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        String html = fragmentEntryLink.getHtml();
        for (Object fragmentEntryProcessor : this._fragmentEntryProcessors) {
            html = fragmentEntryProcessor.processFragmentEntryLinkHTML(fragmentEntryLink, html, fragmentEntryProcessorContext);
        }
        Document document = this._getDocument(html);
        for (DocumentFragmentEntryProcessor documentFragmentEntryProcessor : this._documentFragmentEntryProcessors) {
            documentFragmentEntryProcessor.processFragmentEntryLinkHTML(fragmentEntryLink, document, fragmentEntryProcessorContext);
        }
        Element bodyElement = document.body();
        return bodyElement.html();
    }

    public void validateFragmentEntryHTML(String html, String configuration) throws PortalException {
        if (CompanyThreadLocal.isInitializingPortalInstance()) {
            return;
        }
        Set<String> validHTMLs = _validHTMLsThreadLocal.get();
        if (validHTMLs.contains(html)) {
            return;
        }
        for (FragmentEntryValidator fragmentEntryValidator : this._fragmentEntryValidators) {
            fragmentEntryValidator.validateFragmentEntryHTML(html, configuration, LocaleUtil.getDefault());
        }
        validHTMLs.add(html);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._cssFragmentEntryProcessors = ServiceTrackerListFactory.open((BundleContext)bundleContext, CSSFragmentEntryProcessor.class, Collections.reverseOrder(new PropertyServiceReferenceComparator("fragment.entry.processor.priority")));
        this._documentFragmentEntryProcessors = ServiceTrackerListFactory.open((BundleContext)bundleContext, DocumentFragmentEntryProcessor.class, Collections.reverseOrder(new PropertyServiceReferenceComparator("fragment.entry.processor.priority")));
        this._fragmentEntryAutocompleteContributors = ServiceTrackerListFactory.open((BundleContext)bundleContext, FragmentEntryAutocompleteContributor.class, Collections.reverseOrder(new PropertyServiceReferenceComparator("fragment.entry.processor.priority")));
        this._fragmentEntryProcessors = ServiceTrackerListFactory.open((BundleContext)bundleContext, FragmentEntryProcessor.class, Collections.reverseOrder(new PropertyServiceReferenceComparator("fragment.entry.processor.priority")));
        this._fragmentEntryValidators = ServiceTrackerListFactory.open((BundleContext)bundleContext, FragmentEntryValidator.class, Collections.reverseOrder(new PropertyServiceReferenceComparator("fragment.entry.processor.priority")));
    }

    @Deactivate
    protected void deactivate() {
        this._cssFragmentEntryProcessors.close();
        this._documentFragmentEntryProcessors.close();
        this._fragmentEntryAutocompleteContributors.close();
        this._fragmentEntryProcessors.close();
        this._fragmentEntryValidators.close();
    }

    private Document _getDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }
}

