/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.fragment.internal.renderer.FragmentRendererUtil;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.info.item.InfoItemDetails;
import com.liferay.info.item.renderer.InfoItemRenderer;
import com.liferay.info.item.renderer.InfoItemRendererRegistry;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Layout;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentRenderer.class})
public class LayoutDisplayObjectFragmentRenderer
implements FragmentRenderer {
    @Reference
    private InfoItemRendererRegistry _infoItemRendererRegistry;
    @Reference
    private Language _language;

    public String getCollectionKey() {
        return "content-display";
    }

    public String getIcon() {
        return "web-content";
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "display-page-content");
    }

    public boolean isSelectable(HttpServletRequest httpServletRequest) {
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        return layout.isTypeAssetDisplay();
    }

    public void render(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Object infoItem = httpServletRequest.getAttribute("INFO_ITEM");
        if (infoItem == null) {
            if (FragmentRendererUtil.isEditMode(httpServletRequest)) {
                FragmentRendererUtil.printPortletMessageInfo(httpServletRequest, httpServletResponse, "the-display-page-content-will-be-shown-here");
            }
            return;
        }
        InfoItemDetails infoItemDetails = (InfoItemDetails)httpServletRequest.getAttribute("INFO_ITEM_DETAILS");
        InfoItemRenderer<Object> infoItemRenderer = this._getInfoItemRenderer(infoItemDetails.getClassName());
        if (infoItemRenderer == null) {
            if (FragmentRendererUtil.isEditMode(httpServletRequest)) {
                FragmentRendererUtil.printPortletMessageInfo(httpServletRequest, httpServletResponse, "there-are-no-available-renderers-for-the-display-page-content");
            }
            return;
        }
        infoItemRenderer.render(infoItem, httpServletRequest, httpServletResponse);
    }

    private InfoItemRenderer<Object> _getInfoItemRenderer(String displayObjectClassName) {
        List infoItemRenderers = this._infoItemRendererRegistry.getInfoItemRenderers(displayObjectClassName);
        if (infoItemRenderers == null) {
            return null;
        }
        return (InfoItemRenderer)infoItemRenderers.get(0);
    }
}

