/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.helper;

import com.liferay.fragment.contributor.FragmentCollectionContributorRegistry;
import com.liferay.fragment.helper.FragmentEntryLinkHelper;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererRegistry;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentEntryLinkHelper.class})
public class FragmentEntryLinkHelperImpl
implements FragmentEntryLinkHelper {
    @Reference
    private FragmentCollectionContributorRegistry _fragmentCollectionContributorRegistry;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private FragmentRendererRegistry _fragmentRendererRegistry;

    public String getFragmentEntryName(FragmentEntryLink fragmentEntryLink, Locale locale) {
        FragmentEntry fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(fragmentEntryLink.getFragmentEntryId());
        if (fragmentEntry != null) {
            return fragmentEntry.getName();
        }
        String rendererKey = fragmentEntryLink.getRendererKey();
        if (Validator.isNull((String)rendererKey)) {
            return "";
        }
        Map fragmentEntries = this._fragmentCollectionContributorRegistry.getFragmentEntries(locale);
        FragmentEntry contributedFragmentEntry = (FragmentEntry)fragmentEntries.get(rendererKey);
        if (contributedFragmentEntry != null) {
            return contributedFragmentEntry.getName();
        }
        FragmentRenderer fragmentRenderer = this._fragmentRendererRegistry.getFragmentRenderer(fragmentEntryLink.getRendererKey());
        if (fragmentRenderer != null) {
            return fragmentRenderer.getLabel(locale);
        }
        return "";
    }
}

