/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.importer;

import com.liferay.fragment.configuration.FragmentServiceConfiguration;
import com.liferay.fragment.constants.FragmentConstants;
import com.liferay.fragment.exception.DuplicateFragmentCollectionKeyException;
import com.liferay.fragment.exception.DuplicateFragmentCompositionKeyException;
import com.liferay.fragment.exception.DuplicateFragmentEntryKeyException;
import com.liferay.fragment.exception.FragmentCollectionNameException;
import com.liferay.fragment.importer.FragmentsImportStrategy;
import com.liferay.fragment.importer.FragmentsImporter;
import com.liferay.fragment.importer.FragmentsImporterResultEntry;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentComposition;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.service.FragmentCollectionLocalService;
import com.liferay.fragment.service.FragmentCollectionService;
import com.liferay.fragment.service.FragmentCompositionLocalService;
import com.liferay.fragment.service.FragmentCompositionService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.fragment.service.FragmentEntryService;
import com.liferay.fragment.validator.FragmentEntryValidator;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentsImporter.class})
public class FragmentsImporterImpl
implements FragmentsImporter {
    private static final String _FRAGMENT_COLLECTION_KEY_DEFAULT = "imported";
    private static final Log _log = LogFactoryUtil.getLog(FragmentsImporterImpl.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private FragmentCollectionLocalService _fragmentCollectionLocalService;
    @Reference
    private FragmentCollectionService _fragmentCollectionService;
    @Reference
    private FragmentCompositionLocalService _fragmentCompositionLocalService;
    @Reference
    private FragmentCompositionService _fragmentCompositionService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private FragmentEntryService _fragmentEntryService;
    @Reference
    private FragmentEntryValidator _fragmentEntryValidator;
    private List<FragmentsImporterResultEntry> _fragmentsImporterResultEntries;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public List<FragmentsImporterResultEntry> importFragmentEntries(long userId, long groupId, long fragmentCollectionId, File file, FragmentsImportStrategy fragmentsImportStrategy) throws Exception {
        this._fragmentsImporterResultEntries = new ArrayList<FragmentsImporterResultEntry>();
        try (ZipFile zipFile = new ZipFile(file);){
            HashMap<String, String> orphanFragmentCompositions = new HashMap<String, String>();
            HashMap<String, String> orphanFragmentEntries = new HashMap<String, String>();
            HashMap<String, String> resourceReferences = new HashMap<String, String>();
            Map<String, FragmentCollectionFolder> fragmentCollectionFolderMap = this._getFragmentCollectionFolderMap(zipFile, groupId, orphanFragmentCompositions, orphanFragmentEntries);
            for (Map.Entry<String, FragmentCollectionFolder> entry : fragmentCollectionFolderMap.entrySet()) {
                FragmentCollectionFolder fragmentCollectionFolder = entry.getValue();
                String name = entry.getKey();
                String description = "";
                String collectionJSON = this._getContent(zipFile, fragmentCollectionFolder.getFileName());
                if (Validator.isNotNull((String)collectionJSON)) {
                    JSONObject jsonObject = this._jsonFactory.createJSONObject(collectionJSON);
                    name = jsonObject.getString("name");
                    description = jsonObject.getString("description");
                }
                if (Validator.isNull((String)name)) {
                    throw new FragmentCollectionNameException();
                }
                FragmentCollection fragmentCollection = this._addFragmentCollection(groupId, entry.getKey(), name, description, fragmentsImportStrategy);
                this._importResources(userId, groupId, fragmentCollection, entry.getKey(), zipFile, resourceReferences);
                this._importFragmentCompositions(userId, groupId, zipFile, fragmentCollection.getFragmentCollectionId(), fragmentCollectionFolder.getFragmentCompositions(), fragmentsImportStrategy);
                this._importFragmentEntries(userId, groupId, zipFile, fragmentCollection.getFragmentCollectionId(), fragmentCollectionFolder.getFragmentEntries(), resourceReferences, fragmentsImportStrategy);
            }
            if (MapUtil.isNotEmpty(orphanFragmentCompositions) || MapUtil.isNotEmpty(orphanFragmentEntries)) {
                FragmentCollection fragmentCollection = this._fragmentCollectionService.fetchFragmentCollection(fragmentCollectionId);
                if (fragmentCollection == null) {
                    fragmentCollection = this._getDefaultFragmentCollection(groupId);
                }
                this._importFragmentCompositions(userId, groupId, zipFile, fragmentCollection.getFragmentCollectionId(), orphanFragmentCompositions, fragmentsImportStrategy);
                this._importFragmentEntries(userId, groupId, zipFile, fragmentCollection.getFragmentCollectionId(), orphanFragmentEntries, resourceReferences, fragmentsImportStrategy);
            }
        }
        return this._fragmentsImporterResultEntries;
    }

    public boolean validateFragmentEntries(long userId, long groupId, long fragmentCollectionId, File file) throws Exception {
        try (ZipFile zipFile = new ZipFile(file);){
            HashMap<String, String> orphanFragmentCompositions = new HashMap<String, String>();
            HashMap<String, String> orphanFragmentEntries = new HashMap<String, String>();
            Map<String, FragmentCollectionFolder> fragmentCollectionFolderMap = this._getFragmentCollectionFolderMap(zipFile, groupId, orphanFragmentCompositions, orphanFragmentEntries);
            for (Map.Entry<String, FragmentCollectionFolder> fragmentCollectionFolder : fragmentCollectionFolderMap.entrySet()) {
                FragmentCollection fragmentCollection = this._fragmentCollectionLocalService.fetchFragmentCollection(groupId, fragmentCollectionFolder.getKey());
                if (fragmentCollection != null) {
                    boolean bl = false;
                    return bl;
                }
                boolean valid = this._validateFragmentCompositions(groupId, orphanFragmentCompositions);
                if (!valid) {
                    boolean bl = false;
                    return bl;
                }
                valid = this._validateFragmentEntries(groupId, orphanFragmentEntries);
                if (valid) continue;
                boolean bl = false;
                return bl;
            }
            if (MapUtil.isNotEmpty(orphanFragmentCompositions) || MapUtil.isNotEmpty(orphanFragmentEntries)) {
                boolean valid = this._validateFragmentCompositions(groupId, orphanFragmentCompositions);
                if (!valid) {
                    boolean bl = false;
                    return bl;
                }
                valid = this._validateFragmentEntries(groupId, orphanFragmentEntries);
                if (!valid) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    private FragmentCollection _addFragmentCollection(long groupId, String fragmentCollectionKey, String name, String description, FragmentsImportStrategy fragmentsImportStrategy) throws Exception {
        FragmentCollection fragmentCollection = this._fragmentCollectionLocalService.fetchFragmentCollection(groupId, fragmentCollectionKey);
        if (fragmentCollection == null) {
            fragmentCollection = this._fragmentCollectionService.addFragmentCollection(groupId, fragmentCollectionKey, name, description, ServiceContextThreadLocal.getServiceContext());
        } else {
            if (Objects.equals(FragmentsImportStrategy.DO_NOT_IMPORT, fragmentsImportStrategy)) {
                return fragmentCollection;
            }
            if (Objects.equals(FragmentsImportStrategy.KEEP_BOTH, fragmentsImportStrategy)) {
                fragmentCollection = this._fragmentCollectionService.addFragmentCollection(groupId, this._fragmentCollectionLocalService.generateFragmentCollectionKey(groupId, fragmentCollectionKey), this._fragmentCollectionLocalService.getUniqueFragmentCollectionName(groupId, name), description, ServiceContextThreadLocal.getServiceContext());
            } else if (Objects.equals(FragmentsImportStrategy.OVERWRITE, fragmentsImportStrategy)) {
                fragmentCollection = this._fragmentCollectionService.updateFragmentCollection(fragmentCollection.getFragmentCollectionId(), name, description);
            } else {
                throw new DuplicateFragmentCollectionKeyException(fragmentCollectionKey);
            }
        }
        return fragmentCollection;
    }

    private FragmentEntry _addFragmentEntry(long groupId, FragmentEntry fragmentEntry, long fragmentCollectionId, String fragmentEntryKey, String name, String css, String html, String js, boolean cacheable, String configuration, String icon, boolean readOnly, String typeLabel, String typeOptions, FragmentsImportStrategy fragmentsImportStrategy) throws Exception {
        if (fragmentEntry != null) {
            if (Objects.equals(FragmentsImportStrategy.DO_NOT_IMPORT, fragmentsImportStrategy)) {
                return fragmentEntry;
            }
            if (Objects.equals(FragmentsImportStrategy.DO_NOT_OVERWRITE, fragmentsImportStrategy)) {
                throw new DuplicateFragmentEntryKeyException(fragmentEntryKey);
            }
        }
        int type = FragmentConstants.getTypeFromLabel((String)StringUtil.toLowerCase((String)StringUtil.trim((String)typeLabel)));
        int status = 0;
        String errorMessage = null;
        try {
            this._fragmentEntryProcessorRegistry.validateFragmentEntryHTML(html, configuration);
            this._fragmentEntryValidator.validateConfiguration(configuration);
            this._fragmentEntryValidator.validateTypeOptions(type, typeOptions);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            if (type == 2) {
                this._fragmentsImporterResultEntries.add(new FragmentsImporterResultEntry(name, FragmentsImporterResultEntry.Status.INVALID, FragmentsImporterResultEntry.Type.FRAGMENT, portalException.getMessage()));
                return null;
            }
            status = 2;
            errorMessage = portalException.getLocalizedMessage();
        }
        try {
            fragmentEntry = fragmentEntry == null ? this._fragmentEntryService.addFragmentEntry(groupId, fragmentCollectionId, fragmentEntryKey, name, css, html, js, cacheable, configuration, icon, 0L, type, typeOptions, status, ServiceContextThreadLocal.getServiceContext()) : (Objects.equals(FragmentsImportStrategy.KEEP_BOTH, fragmentsImportStrategy) ? this._fragmentEntryService.addFragmentEntry(groupId, fragmentCollectionId, this._fragmentEntryLocalService.generateFragmentEntryKey(groupId, fragmentEntryKey), this._fragmentEntryLocalService.getUniqueFragmentEntryName(groupId, fragmentCollectionId, name), css, html, js, cacheable, configuration, icon, 0L, type, typeOptions, status, ServiceContextThreadLocal.getServiceContext()) : this._fragmentEntryService.updateFragmentEntry(fragmentEntry.getFragmentEntryId(), fragmentCollectionId, name, css, html, js, cacheable, configuration, icon, fragmentEntry.getPreviewFileEntryId(), typeOptions, status));
            if (fragmentEntry.isReadOnly() != readOnly) {
                fragmentEntry.setReadOnly(readOnly);
                fragmentEntry = this._fragmentEntryLocalService.updateFragmentEntry(fragmentEntry);
            }
            FragmentsImporterResultEntry.Status fragmentsImporterResultEntryStatus = FragmentsImporterResultEntry.Status.IMPORTED;
            if (fragmentEntry.getStatus() == 2) {
                fragmentsImporterResultEntryStatus = FragmentsImporterResultEntry.Status.IMPORTED_DRAFT;
            }
            this._fragmentsImporterResultEntries.add(new FragmentsImporterResultEntry(name, fragmentsImporterResultEntryStatus, FragmentsImporterResultEntry.Type.FRAGMENT, errorMessage));
            return fragmentEntry;
        }
        catch (PortalException portalException) {
            this._fragmentsImporterResultEntries.add(new FragmentsImporterResultEntry(name, FragmentsImporterResultEntry.Status.INVALID, FragmentsImporterResultEntry.Type.FRAGMENT, portalException.getMessage()));
            return null;
        }
    }

    private void _addPortletFileEntries(long userId, long groupId, FragmentCollection fragmentCollection, ZipFile zipFile, Map<String, String> resourceReferences, Map<String, String> zipEntryNames, Repository repository) throws Exception {
        if (repository != null) {
            FragmentServiceConfiguration fragmentServiceConfiguration = (FragmentServiceConfiguration)this._configurationProvider.getCompanyConfiguration(FragmentServiceConfiguration.class, fragmentCollection.getCompanyId());
            for (FileEntry fileEntry : PortletFileRepositoryUtil.getPortletFileEntries((long)groupId, (long)fragmentCollection.getResourcesFolderId())) {
                if (!zipEntryNames.containsKey(fileEntry.getFileName())) continue;
                if (fragmentServiceConfiguration.propagateChanges()) {
                    PortletFileRepositoryUtil.deletePortletFileEntry((long)fileEntry.getFileEntryId());
                    continue;
                }
                String newFileName = PortletFileRepositoryUtil.getUniqueFileName((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getFileName());
                resourceReferences.put(fileEntry.getFileName(), newFileName);
                zipEntryNames.put(newFileName, zipEntryNames.get(fileEntry.getFileName()));
                zipEntryNames.remove(fileEntry.getFileName());
            }
        }
        for (Map.Entry<String, String> entry : zipEntryNames.entrySet()) {
            String fileName = entry.getKey();
            PortletFileRepositoryUtil.addPortletFileEntry(null, (long)groupId, (long)userId, (String)FragmentCollection.class.getName(), (long)fragmentCollection.getFragmentCollectionId(), (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (long)fragmentCollection.getResourcesFolderId(), (InputStream)this._getInputStream(zipFile, entry.getValue()), (String)fileName, (String)MimeTypesUtil.getContentType((String)fileName), (boolean)false);
        }
    }

    private void _addPortletFileEntriesWithFolders(long userId, long groupId, FragmentCollection fragmentCollection, ZipFile zipFile, Map<String, String> resourceReferences, Map<String, String> zipEntryNames, Repository repository) throws Exception {
        if (repository != null) {
            FragmentServiceConfiguration fragmentServiceConfiguration = (FragmentServiceConfiguration)this._configurationProvider.getCompanyConfiguration(FragmentServiceConfiguration.class, fragmentCollection.getCompanyId());
            Map resources = fragmentCollection.getResourcesMap();
            for (Map.Entry entry : resources.entrySet()) {
                String fileEntryPath = (String)entry.getKey();
                if (!zipEntryNames.containsKey(fileEntryPath)) continue;
                FileEntry fileEntry = (FileEntry)entry.getValue();
                if (fragmentServiceConfiguration.propagateChanges()) {
                    PortletFileRepositoryUtil.deletePortletFileEntry((long)fileEntry.getFileEntryId());
                    continue;
                }
                String folderPath = "";
                int index = fileEntryPath.lastIndexOf("/");
                if (index != -1) {
                    folderPath = fileEntryPath.substring(0, index);
                }
                String newFileName = PortletFileRepositoryUtil.getUniqueFileName((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getFileName());
                resourceReferences.put(fileEntryPath, folderPath + newFileName);
                zipEntryNames.put(folderPath + newFileName, zipEntryNames.get(fileEntryPath));
                zipEntryNames.remove(fileEntryPath);
            }
        } else {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (ServiceContext)serviceContext);
        }
        HashMap folderIdsMap = HashMapBuilder.put((Object)"", (Object)fragmentCollection.getResourcesFolderId()).build();
        for (Map.Entry<String, String> entry : zipEntryNames.entrySet()) {
            String fileName = entry.getKey();
            String folderPath = "";
            int index = fileName.lastIndexOf("/");
            if (index != -1) {
                folderPath = fileName.substring(0, index);
                fileName = fileName.substring(index + 1);
            }
            PortletFileRepositoryUtil.addPortletFileEntry(null, (long)groupId, (long)userId, (String)FragmentCollection.class.getName(), (long)fragmentCollection.getFragmentCollectionId(), (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (long)this._getOrCreateFolderId(folderIdsMap, folderPath, repository.getRepositoryId(), userId), (InputStream)this._getInputStream(zipFile, entry.getValue()), (String)fileName, (String)MimeTypesUtil.getContentType((String)fileName), (boolean)false);
        }
    }

    private String _getContent(ZipFile zipFile, String fileName) throws Exception {
        ZipEntry zipEntry = zipFile.getEntry(fileName);
        if (zipEntry == null) {
            return "";
        }
        return StringUtil.read((InputStream)zipFile.getInputStream(zipEntry));
    }

    private FragmentCollection _getDefaultFragmentCollection(long groupId) throws PortalException {
        FragmentCollection fragmentCollection = this._fragmentCollectionLocalService.fetchFragmentCollection(groupId, _FRAGMENT_COLLECTION_KEY_DEFAULT);
        if (fragmentCollection != null) {
            return fragmentCollection;
        }
        return this._fragmentCollectionService.addFragmentCollection(groupId, _FRAGMENT_COLLECTION_KEY_DEFAULT, this._language.get(this._portal.getSiteDefaultLocale(groupId), _FRAGMENT_COLLECTION_KEY_DEFAULT), "", ServiceContextThreadLocal.getServiceContext());
    }

    private String _getFileName(String path) {
        int index = path.lastIndexOf(47);
        if (index > 0) {
            return path.substring(index + 1);
        }
        return path;
    }

    private String _getFilePath(String fragmentCollectionKey, String path) {
        path = StringUtil.removeFirst((String)path, (String)(fragmentCollectionKey + "/"));
        int index = path.indexOf("resources/");
        path = path.substring(index);
        return StringUtil.removeFirst((String)path, (String)"resources/");
    }

    private Map<String, FragmentCollectionFolder> _getFragmentCollectionFolderMap(ZipFile zipFile, long groupId, Map<String, String> orphanFragmentCompositions, Map<String, String> orphanFragmentEntries) throws Exception {
        String fileName;
        ZipEntry zipEntry;
        HashMap<String, FragmentCollectionFolder> fragmentCollectionFolderMap = new HashMap<String, FragmentCollectionFolder>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !this._isFragmentCollection(fileName = zipEntry.getName())) continue;
            fragmentCollectionFolderMap.put(this._getKey(zipFile, groupId, fileName), new FragmentCollectionFolder(fileName));
        }
        enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !this._isFragmentComposition(fileName = zipEntry.getName()) && !this._isFragmentEntry(fileName)) continue;
            String fragmentCollectionPath = fileName;
            String fragmentCollectionKey = "";
            while (fragmentCollectionPath.length() > 0) {
                String fragmentCollectionFileName = (fragmentCollectionPath = fragmentCollectionPath.substring(0, fragmentCollectionPath.lastIndexOf("/") + 1)) + "collection.json";
                ZipEntry fragmentCollectionZipEntry = zipFile.getEntry(fragmentCollectionFileName);
                if (fragmentCollectionZipEntry != null) {
                    fragmentCollectionKey = this._getKey(zipFile, groupId, fragmentCollectionFileName);
                    break;
                }
                if (Validator.isNull((String)fragmentCollectionPath)) break;
                fragmentCollectionPath = fragmentCollectionPath.substring(0, fragmentCollectionPath.lastIndexOf("/"));
            }
            if (Validator.isNull((String)fragmentCollectionKey) && this._isFragmentComposition(fileName)) {
                orphanFragmentCompositions.put(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            if (Validator.isNull((String)fragmentCollectionKey) && this._isFragmentEntry(fileName)) {
                orphanFragmentEntries.put(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            FragmentCollectionFolder fragmentCollectionFolder = (FragmentCollectionFolder)fragmentCollectionFolderMap.get(fragmentCollectionKey);
            if (fragmentCollectionFolder == null && this._isFragmentComposition(fileName)) {
                orphanFragmentCompositions.put(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            if (fragmentCollectionFolder == null && this._isFragmentEntry(fileName)) {
                orphanFragmentEntries.put(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            if (this._isFragmentComposition(fileName)) {
                fragmentCollectionFolder.addFragmentComposition(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            fragmentCollectionFolder.addFragmentEntry(this._getKey(zipFile, groupId, fileName), fileName);
        }
        return fragmentCollectionFolderMap;
    }

    private String _getFragmentEntryContent(ZipFile zipFile, String fileName, String contentPath) throws Exception {
        InputStream inputStream = this._getFragmentEntryInputStream(zipFile, fileName, contentPath);
        if (inputStream == null) {
            return "";
        }
        return StringUtil.read((InputStream)inputStream);
    }

    private InputStream _getFragmentEntryInputStream(ZipFile zipFile, String fileName, String contentPath) throws Exception {
        if (contentPath.startsWith("/")) {
            return this._getInputStream(zipFile, contentPath.substring(1));
        }
        if (contentPath.startsWith("./")) {
            contentPath = contentPath.substring(2);
        }
        String path = fileName.substring(0, fileName.lastIndexOf("/"));
        return this._getInputStream(zipFile, path + "/" + contentPath);
    }

    private InputStream _getInputStream(ZipFile zipFile, String fileName) throws Exception {
        ZipEntry zipEntry = zipFile.getEntry(fileName);
        if (zipEntry == null) {
            return null;
        }
        return zipFile.getInputStream(zipEntry);
    }

    private String _getKey(ZipFile zipFile, long groupId, String fileName) throws Exception {
        String key = "";
        if (fileName.lastIndexOf(47) != -1) {
            String path = fileName.substring(0, fileName.lastIndexOf(47));
            key = path.substring(path.lastIndexOf(47) + 1);
        } else if (fileName.equals("collection.json")) {
            JSONObject collectionJSONObject = this._jsonFactory.createJSONObject(StringUtil.read((InputStream)zipFile.getInputStream(zipFile.getEntry(fileName))));
            key = this._fragmentCollectionLocalService.generateFragmentCollectionKey(groupId, collectionJSONObject.getString("name"));
        } else if (fileName.equals("fragment.json")) {
            JSONObject fragmentJSONObject = this._jsonFactory.createJSONObject(StringUtil.read((InputStream)zipFile.getInputStream(zipFile.getEntry(fileName))));
            key = this._fragmentEntryLocalService.generateFragmentEntryKey(groupId, fragmentJSONObject.getString("name"));
        }
        if (Validator.isNotNull((String)key)) {
            return key;
        }
        throw new IllegalArgumentException("Incorrect file name " + fileName);
    }

    private long _getOrCreateFolderId(Map<String, Long> folderIdsMap, String folderPath, long repositoryId, long userId) throws Exception {
        if (folderIdsMap.containsKey(folderPath)) {
            return folderIdsMap.get(folderPath);
        }
        String folderName = folderPath;
        String parentFolderPath = "";
        int index = folderName.lastIndexOf("/");
        if (index != -1) {
            folderName = folderName.substring(index + 1);
            parentFolderPath = folderPath.substring(0, index);
        }
        Folder folder = PortletFileRepositoryUtil.addPortletFolder((long)userId, (long)repositoryId, (long)this._getOrCreateFolderId(folderIdsMap, parentFolderPath, repositoryId, userId), (String)folderName, (ServiceContext)ServiceContextThreadLocal.getServiceContext());
        folderIdsMap.put(folderPath, folder.getFolderId());
        return folder.getFolderId();
    }

    private long _getPreviewFileEntryId(long userId, long groupId, ZipFile zipFile, String className, long classPK, String fileName, String contentPath) throws Exception {
        InputStream inputStream = this._getFragmentEntryInputStream(zipFile, fileName, contentPath);
        if (inputStream == null) {
            return 0L;
        }
        Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet");
        if (repository == null) {
            if (groupId == 0L && Objects.equals(className, FragmentEntry.class.getName())) {
                FragmentEntry fragmentEntry = this._fragmentEntryLocalService.getFragmentEntry(classPK);
                Company company = this._companyLocalService.getCompany(fragmentEntry.getCompanyId());
                groupId = company.getGroupId();
            } else if (groupId == 0L && Objects.equals(className, FragmentComposition.class.getName())) {
                FragmentComposition fragmentComposition = this._fragmentCompositionLocalService.getFragmentComposition(classPK);
                Company company = this._companyLocalService.getCompany(fragmentComposition.getCompanyId());
                groupId = company.getGroupId();
            }
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (ServiceContext)serviceContext);
        }
        FileEntry fileEntry = PortletFileRepositoryUtil.addPortletFileEntry(null, (long)groupId, (long)userId, (String)className, (long)classPK, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (long)repository.getDlFolderId(), (InputStream)inputStream, (String)(classPK + "_preview." + FileUtil.getExtension((String)contentPath)), (String)MimeTypesUtil.getContentType((String)contentPath), (boolean)false);
        return fileEntry.getFileEntryId();
    }

    private void _importFragmentCompositions(long userId, long groupId, ZipFile zipFile, long fragmentCollectionId, Map<String, String> fragmentCompositions, FragmentsImportStrategy fragmentsImportStrategy) throws Exception {
        for (Map.Entry<String, String> entry : fragmentCompositions.entrySet()) {
            String compositionJSON;
            FragmentComposition fragmentComposition = this._fragmentCompositionService.fetchFragmentComposition(groupId, entry.getKey());
            if (fragmentComposition != null && Objects.equals(FragmentsImportStrategy.DO_NOT_IMPORT, fragmentsImportStrategy) || Validator.isNull((String)(compositionJSON = this._getContent(zipFile, entry.getValue())))) continue;
            JSONObject jsonObject = this._jsonFactory.createJSONObject(compositionJSON);
            String name = jsonObject.getString("name", entry.getKey());
            String description = jsonObject.getString("description");
            String definitionData = this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject.getString("fragmentCompositionDefinitionPath"));
            try {
                String thumbnailPath;
                if (fragmentComposition == null) {
                    fragmentComposition = this._fragmentCompositionService.addFragmentComposition(groupId, fragmentCollectionId, entry.getKey(), name, description, definitionData, 0L, 0, ServiceContextThreadLocal.getServiceContext());
                } else if (Objects.equals(FragmentsImportStrategy.KEEP_BOTH, fragmentsImportStrategy)) {
                    fragmentComposition = this._fragmentCompositionService.addFragmentComposition(groupId, fragmentCollectionId, this._fragmentCompositionLocalService.generateFragmentCompositionKey(groupId, entry.getKey()), this._fragmentCompositionLocalService.getUniqueFragmentCompositionName(groupId, fragmentCollectionId, name), description, definitionData, 0L, 0, ServiceContextThreadLocal.getServiceContext());
                } else {
                    if (Objects.equals(FragmentsImportStrategy.DO_NOT_OVERWRITE, fragmentsImportStrategy)) {
                        throw new DuplicateFragmentCompositionKeyException();
                    }
                    fragmentComposition = this._fragmentCompositionService.updateFragmentComposition(fragmentComposition.getFragmentCompositionId(), fragmentCollectionId, name, description, definitionData, fragmentComposition.getPreviewFileEntryId(), fragmentComposition.getStatus());
                }
                if (fragmentComposition.getPreviewFileEntryId() > 0L) {
                    PortletFileRepositoryUtil.deletePortletFileEntry((long)fragmentComposition.getPreviewFileEntryId());
                }
                if (Validator.isNotNull((String)(thumbnailPath = jsonObject.getString("thumbnailPath")))) {
                    this._fragmentCompositionService.updateFragmentComposition(fragmentComposition.getFragmentCompositionId(), this._getPreviewFileEntryId(userId, groupId, zipFile, FragmentComposition.class.getName(), fragmentComposition.getFragmentCompositionId(), entry.getValue(), thumbnailPath));
                }
                this._fragmentsImporterResultEntries.add(new FragmentsImporterResultEntry(name, FragmentsImporterResultEntry.Status.IMPORTED, FragmentsImporterResultEntry.Type.COMPOSITION, null));
            }
            catch (PortalException portalException) {
                this._fragmentsImporterResultEntries.add(new FragmentsImporterResultEntry(name, FragmentsImporterResultEntry.Status.INVALID, FragmentsImporterResultEntry.Type.COMPOSITION, portalException.getMessage()));
            }
        }
    }

    private void _importFragmentEntries(long userId, long groupId, ZipFile zipFile, long fragmentCollectionId, Map<String, String> fragmentEntries, Map<String, String> resourceReferences, FragmentsImportStrategy fragmentsImportStrategy) throws Exception {
        for (Map.Entry<String, String> entry : fragmentEntries.entrySet()) {
            String thumbnailPath;
            JSONObject jsonObject;
            String name = entry.getKey();
            FragmentEntry fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(groupId, name);
            if (fragmentEntry != null && Objects.equals(FragmentsImportStrategy.DO_NOT_IMPORT, fragmentsImportStrategy)) continue;
            String css = "";
            String html = "";
            String js = "";
            boolean cacheable = false;
            String configuration = "";
            String icon = "";
            boolean readOnly = false;
            String typeLabel = "";
            String typeOptions = "";
            String fragmentJSON = this._getContent(zipFile, entry.getValue());
            if (Validator.isNotNull((String)fragmentJSON)) {
                jsonObject = this._jsonFactory.createJSONObject(fragmentJSON);
                name = jsonObject.getString("name");
                css = this._replaceResourceReferences(this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject.getString("cssPath")), resourceReferences);
                html = this._replaceResourceReferences(this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject.getString("htmlPath")), resourceReferences);
                js = this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject.getString("jsPath"));
                cacheable = jsonObject.getBoolean("cacheable");
                configuration = this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject.getString("configurationPath"));
                readOnly = jsonObject.getBoolean("readOnly");
                icon = jsonObject.getString("icon");
                typeLabel = jsonObject.getString("type");
                typeOptions = jsonObject.getString("typeOptions");
            }
            if ((fragmentEntry = this._addFragmentEntry(groupId, fragmentEntry, fragmentCollectionId, entry.getKey(), name, css, html, js, cacheable, configuration, icon, readOnly, typeLabel, typeOptions, fragmentsImportStrategy)) == null || !Validator.isNotNull((String)fragmentJSON)) continue;
            if (fragmentEntry.getPreviewFileEntryId() > 0L) {
                PortletFileRepositoryUtil.deletePortletFileEntry((long)fragmentEntry.getPreviewFileEntryId());
            }
            if (!Validator.isNotNull((String)(thumbnailPath = (jsonObject = this._jsonFactory.createJSONObject(fragmentJSON)).getString("thumbnailPath")))) continue;
            this._fragmentEntryLocalService.updateFragmentEntry(fragmentEntry.getFragmentEntryId(), this._getPreviewFileEntryId(userId, groupId, zipFile, FragmentEntry.class.getName(), fragmentEntry.getFragmentEntryId(), entry.getValue(), thumbnailPath));
        }
    }

    private void _importResources(long userId, long groupId, FragmentCollection fragmentCollection, String fragmentCollectionKey, ZipFile zipFile, Map<String, String> resourceReferences) throws Exception {
        if (groupId == 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Importing resources at the system level is not supported");
            }
            return;
        }
        HashSet<String> excludePaths = new HashSet<String>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ArrayList<? extends ZipEntry> zipEntries = Collections.list(enumeration);
        for (ZipEntry zipEntry : zipEntries) {
            String string = zipEntry.getName();
            if (!string.endsWith("collection.json") && !string.endsWith("fragment.json")) continue;
            if (string.endsWith("collection.json")) {
                excludePaths.add(string);
                continue;
            }
            try {
                JSONObject jsonObject = this._jsonFactory.createJSONObject(StringUtil.read((InputStream)zipFile.getInputStream(zipEntry)));
                String path = string.substring(0, string.lastIndexOf("/") + 1);
                Collections.addAll(excludePaths, path + "fragment.json", path + jsonObject.getString("configuration"), path + jsonObject.getString("cssPath"), path + jsonObject.getString("htmlPath"), path + jsonObject.getString("icon"), path + jsonObject.getString("jsPath"), path + jsonObject.getString("thumbnailPath"));
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to read fragments.json file " + string), (Throwable)exception);
            }
        }
        HashMap<String, String> zipEntryNames = new HashMap<String, String>();
        for (ZipEntry zipEntry : zipEntries) {
            Object[] paths = StringUtil.split((String)zipEntry.getName(), (String)"/");
            String fileName = zipEntry.getName();
            if (!ArrayUtil.contains((Object[])paths, (Object)"resources") || excludePaths.contains(zipEntry.getName()) || !fileName.contains(fragmentCollectionKey) || fileName.endsWith("/")) continue;
            if (FeatureFlagManagerUtil.isEnabled((String)"LPS-158675")) {
                zipEntryNames.put(this._getFilePath(fragmentCollectionKey, zipEntry.getName()), zipEntry.getName());
                continue;
            }
            zipEntryNames.put(this._getFileName(zipEntry.getName()), zipEntry.getName());
        }
        Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet");
        if (FeatureFlagManagerUtil.isEnabled((String)"LPS-158675")) {
            this._addPortletFileEntriesWithFolders(userId, groupId, fragmentCollection, zipFile, resourceReferences, zipEntryNames, repository);
        } else {
            this._addPortletFileEntries(userId, groupId, fragmentCollection, zipFile, resourceReferences, zipEntryNames, repository);
        }
    }

    private boolean _isFragmentCollection(String fileName) {
        return Objects.equals(this._getFileName(fileName), "collection.json");
    }

    private boolean _isFragmentComposition(String fileName) {
        return Objects.equals(this._getFileName(fileName), "fragment-composition.json");
    }

    private boolean _isFragmentEntry(String fileName) {
        return Objects.equals(this._getFileName(fileName), "fragment.json");
    }

    private String _replaceResourceReferences(String input, Map<String, String> replacedResourcesMap) {
        for (Map.Entry<String, String> replacedResource : replacedResourcesMap.entrySet()) {
            String source = "\\[resources:" + replacedResource.getKey() + "\\]";
            String target = "\\[resources:" + replacedResource.getValue() + "\\]";
            input = input.replaceAll(source, target);
        }
        return input;
    }

    private boolean _validateFragmentCompositions(long groupId, Map<String, String> fragmentCompositions) {
        for (Map.Entry<String, String> orphanFragmentComposition : fragmentCompositions.entrySet()) {
            FragmentComposition fragmentComposition = this._fragmentCompositionService.fetchFragmentComposition(groupId, orphanFragmentComposition.getKey());
            if (fragmentComposition == null) continue;
            return false;
        }
        return true;
    }

    private boolean _validateFragmentEntries(long groupId, Map<String, String> fragmentEntries) {
        for (Map.Entry<String, String> orphanFragmentEntry : fragmentEntries.entrySet()) {
            FragmentEntry fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(groupId, orphanFragmentEntry.getKey());
            if (fragmentEntry == null) continue;
            return false;
        }
        return true;
    }

    private class FragmentCollectionFolder {
        private final String _fileName;
        private final Map<String, String> _fragmentCompositions = new HashMap<String, String>();
        private final Map<String, String> _fragmentEntries = new HashMap<String, String>();

        public FragmentCollectionFolder(String fileName) {
            this._fileName = fileName;
        }

        public void addFragmentComposition(String key, String fileName) {
            this._fragmentCompositions.put(key, fileName);
        }

        public void addFragmentEntry(String key, String fileName) {
            this._fragmentEntries.put(key, fileName);
        }

        public String getFileName() {
            return this._fileName;
        }

        public Map<String, String> getFragmentCompositions() {
            return this._fragmentCompositions;
        }

        public Map<String, String> getFragmentEntries() {
            return this._fragmentEntries;
        }
    }
}

