/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.processor;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.render.PortletRenderParts;
import com.liferay.portal.kernel.portlet.render.PortletRenderUtil;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortletRegistry.class})
public class PortletRegistryImpl
implements PortletRegistry {
    private static final Log _log = LogFactoryUtil.getLog(PortletRegistryImpl.class);
    private final Map<String, String> _aliasPortletNames = new ConcurrentHashMap<String, String>();
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private PortletLocalService _portletLocalService;

    public List<String> getFragmentEntryLinkPortletIds(FragmentEntryLink fragmentEntryLink) {
        ArrayList<String> portletIds = new ArrayList<String>();
        if (fragmentEntryLink.isTypePortlet()) {
            try {
                JSONObject jsonObject = this._jsonFactory.createJSONObject(fragmentEntryLink.getEditableValues());
                String portletId = jsonObject.getString("portletId");
                if (Validator.isNotNull((String)portletId)) {
                    String instanceId = jsonObject.getString("instanceId");
                    portletIds.add(PortletIdCodec.encode((String)portletId, (String)instanceId));
                }
            }
            catch (PortalException portalException) {
                _log.error((Object)"Unable to get portlet IDs", (Throwable)portalException);
            }
            return portletIds;
        }
        Document document = Jsoup.parseBodyFragment((String)fragmentEntryLink.getHtml());
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        for (Element element : document.select("*")) {
            String alias;
            String portletName;
            String tagName = element.tagName();
            if (!StringUtil.startsWith((String)tagName, (String)"lfr-widget-") || Validator.isNull((String)(portletName = this.getPortletName(alias = StringUtil.removeSubstring((String)tagName, (String)"lfr-widget-"))))) continue;
            String portletId = PortletIdCodec.encode((String)PortletIdCodec.decodePortletName((String)portletName), (long)PortletIdCodec.decodeUserId((String)portletName), (String)(fragmentEntryLink.getNamespace() + element.attr("id")));
            portletIds.add(portletId);
        }
        return portletIds;
    }

    public List<String> getPortletAliases() {
        return new ArrayList<String>(this._aliasPortletNames.keySet());
    }

    public String getPortletName(String alias) {
        return this._aliasPortletNames.get(alias);
    }

    public void registerAlias(String alias, String portletName) {
        this._aliasPortletNames.put(alias, portletName);
    }

    public void unregisterAlias(String alias) {
        this._aliasPortletNames.remove(alias);
    }

    public void writePortletPaths(FragmentEntryLink fragmentEntryLink, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        List<String> fragmentEntryLinkPortletIds = this.getFragmentEntryLinkPortletIds(fragmentEntryLink);
        if (ListUtil.isEmpty(fragmentEntryLinkPortletIds)) {
            return;
        }
        HashSet<Portlet> portlets = new HashSet<Portlet>();
        for (String fragmentEntryLinkPortletId : fragmentEntryLinkPortletIds) {
            Portlet portlet = this._portletLocalService.getPortletById(fragmentEntryLinkPortletId);
            if (portlet == null || !portlet.isActive() || portlet.isUndeployedPortlet()) continue;
            portlets.add(portlet);
        }
        for (Portlet portlet : portlets) {
            try {
                PortletRenderParts portletRenderParts = PortletRenderUtil.getPortletRenderParts((HttpServletRequest)httpServletRequest, (String)"", (Portlet)portlet);
                PortletRenderUtil.writeHeaderPaths((HttpServletResponse)httpServletResponse, (PortletRenderParts)portletRenderParts);
                PortletRenderUtil.writeFooterPaths((HttpServletResponse)httpServletResponse, (PortletRenderParts)portletRenderParts);
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to write portlet paths " + portlet.getPortletId()), (Throwable)exception);
            }
        }
    }
}

