/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.fragment.contributor.FragmentCollectionContributorRegistry;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.fragment.renderer.FragmentRendererController;
import com.liferay.fragment.renderer.FragmentRendererRegistry;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.layout.adaptive.media.LayoutAdaptiveMediaProcessor;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import java.io.Writer;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentRendererController.class})
public class FragmentRendererControllerImpl
implements FragmentRendererController {
    private static final Log _log = LogFactoryUtil.getLog(FragmentRendererControllerImpl.class);
    @Reference
    private FragmentCollectionContributorRegistry _fragmentCollectionContributorRegistry;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private FragmentRendererRegistry _fragmentRendererRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private LayoutAdaptiveMediaProcessor _layoutAdaptiveMediaProcessor;

    public String getConfiguration(FragmentRendererContext fragmentRendererContext) {
        FragmentRenderer fragmentRenderer = this._getFragmentRenderer(fragmentRendererContext.getFragmentEntryLink());
        try {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(fragmentRenderer.getConfiguration(fragmentRendererContext));
            return this._translateConfigurationFields(jsonObject, fragmentRendererContext.getLocale());
        }
        catch (JSONException jsonException) {
            _log.error((Object)"Unable to parse fragment entry link configuration", (Throwable)jsonException);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String render(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        FragmentEntryLink fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink();
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        FragmentRenderer fragmentRenderer = this._getFragmentRenderer(fragmentEntryLink);
        Locale currentLocale = LocaleThreadLocal.getThemeDisplayLocale();
        LocaleThreadLocal.setThemeDisplayLocale((Locale)fragmentRendererContext.getLocale());
        try {
            fragmentRenderer.render(fragmentRendererContext, httpServletRequest, (HttpServletResponse)new PipingServletResponse(httpServletResponse, (Writer)unsyncStringWriter));
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to render content of fragment entry ", fragmentEntryLink.getFragmentEntryId(), ":", exception.getMessage(), ", ", throwable.getMessage()}), (Throwable)exception);
            }
            SessionErrors.add((HttpServletRequest)httpServletRequest, (String)"fragmentEntryContentInvalid");
            String string = this._getFragmentEntryContentExceptionMessage(exception, httpServletRequest);
            return string;
        }
        finally {
            LocaleThreadLocal.setThemeDisplayLocale((Locale)currentLocale);
        }
        if (fragmentRendererContext.isEditMode()) {
            return this._layoutAdaptiveMediaProcessor.processAdaptiveMediaContent(unsyncStringWriter.toString());
        }
        return unsyncStringWriter.toString();
    }

    private String _getFragmentEntryContentExceptionMessage(Exception exception, HttpServletRequest httpServletRequest) {
        StringBundler sb = new StringBundler(3);
        sb.append("<div class=\"alert alert-danger m-2\">");
        String errorMessage = "an-unexpected-error-occurred";
        Throwable throwable = exception.getCause();
        if (throwable instanceof FragmentEntryContentException) {
            FragmentEntryContentException fragmentEntryContentException = (FragmentEntryContentException)throwable;
            errorMessage = fragmentEntryContentException.getLocalizedMessage();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String localizedErrorMessage = this._language.get(themeDisplay.getLocale(), errorMessage);
        sb.append(localizedErrorMessage.replaceAll("\\n", "<br>"));
        sb.append("</div>");
        return sb.toString();
    }

    private FragmentRenderer _getFragmentRenderer(FragmentEntryLink fragmentEntryLink) {
        FragmentRenderer fragmentRenderer = null;
        if (Validator.isNotNull((String)fragmentEntryLink.getRendererKey())) {
            fragmentRenderer = this._fragmentRendererRegistry.getFragmentRenderer(fragmentEntryLink.getRendererKey());
        }
        if (fragmentRenderer == null && fragmentEntryLink.isTypeReact()) {
            fragmentRenderer = this._fragmentRendererRegistry.getFragmentRenderer("FRAGMENT_ENTRY_FRAGMENT_RENDERER_KEY_REACT");
        }
        if (fragmentRenderer == null) {
            fragmentRenderer = this._fragmentRendererRegistry.getFragmentRenderer("FRAGMENT_ENTRY_FRAGMENT_RENDERER_KEY");
        }
        return fragmentRenderer;
    }

    private String _translateConfigurationFields(JSONObject jsonObject, Locale locale) {
        AggregateResourceBundleLoader resourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{ResourceBundleLoaderUtil.getPortalResourceBundleLoader(), this._fragmentCollectionContributorRegistry.getResourceBundleLoader()});
        ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
        return this._fragmentEntryConfigurationParser.translateConfiguration(jsonObject, resourceBundle);
    }
}

