/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.fragment.exception.FragmentEntryConfigurationException;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.DefaultFragmentRendererContext;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.fragment.renderer.FragmentRendererRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.validator.FragmentEntryValidator;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={FragmentRendererRegistry.class})
public class FragmentRendererRegistryImpl
implements FragmentRendererRegistry {
    private static final Log _log = LogFactoryUtil.getLog(FragmentRendererRegistryImpl.class);
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentEntryValidator _fragmentEntryValidator;
    private ServiceTrackerMap<String, FragmentRenderer> _serviceTrackerMap;

    public FragmentRenderer getFragmentRenderer(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        return (FragmentRenderer)this._serviceTrackerMap.getService((Object)key);
    }

    public List<FragmentRenderer> getFragmentRenderers() {
        return new ArrayList<FragmentRenderer>(this._serviceTrackerMap.values());
    }

    public List<FragmentRenderer> getFragmentRenderers(int type) {
        return TransformUtil.transform((Collection)this._serviceTrackerMap.values(), fragmentRenderer -> {
            if (type != fragmentRenderer.getType()) {
                return null;
            }
            return fragmentRenderer;
        });
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, FragmentRenderer.class, null, (serviceReference, emitter) -> {
            FragmentRenderer fragmentRenderer = (FragmentRenderer)bundleContext.getService(serviceReference);
            emitter.emit((Object)fragmentRenderer.getKey());
        }, (ServiceTrackerCustomizer)new FragmentRendererRegistryServiceTrackerCustomizer(bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private class FragmentRendererRegistryServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<FragmentRenderer, FragmentRenderer> {
        private final BundleContext _bundleContext;

        public FragmentRendererRegistryServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        public FragmentRenderer addingService(ServiceReference<FragmentRenderer> serviceReference) {
            FragmentRenderer fragmentRenderer = (FragmentRenderer)this._bundleContext.getService(serviceReference);
            if (!this._isValidFragmentCollectionKey(fragmentRenderer)) {
                _log.error((Object)"Fragment renderer collection key is invalid");
                return null;
            }
            try {
                FragmentEntryLink fragmentEntryLink = FragmentRendererRegistryImpl.this._fragmentEntryLinkLocalService.createFragmentEntryLink(0L);
                FragmentRendererRegistryImpl.this._fragmentEntryValidator.validateConfiguration(fragmentRenderer.getConfiguration((FragmentRendererContext)new DefaultFragmentRendererContext(fragmentEntryLink)));
                return fragmentRenderer;
            }
            catch (FragmentEntryConfigurationException fragmentEntryConfigurationException) {
                _log.error((Object)String.format("Fragment renderer with collection key %s and label %s could not be registered due to invalid configuration", fragmentRenderer.getCollectionKey(), fragmentRenderer.getLabel(LocaleUtil.getMostRelevantLocale())), (Throwable)fragmentEntryConfigurationException);
                return null;
            }
        }

        public void modifiedService(ServiceReference<FragmentRenderer> serviceReference, FragmentRenderer fragmentRenderer) {
        }

        public void removedService(ServiceReference<FragmentRenderer> serviceReference, FragmentRenderer fragmentRenderer) {
            this._bundleContext.ungetService(serviceReference);
        }

        private boolean _isValidFragmentCollectionKey(FragmentRenderer fragmentRenderer) {
            String fragmentCollectionKey = fragmentRenderer.getCollectionKey();
            if (Validator.isNull((String)fragmentCollectionKey) && !StringUtil.equals((String)fragmentRenderer.getKey(), (String)"FRAGMENT_ENTRY_FRAGMENT_RENDERER_KEY") && !StringUtil.equals((String)fragmentRenderer.getKey(), (String)"FRAGMENT_ENTRY_FRAGMENT_RENDERER_KEY_REACT")) {
                return false;
            }
            return !Validator.isNotNull((String)fragmentCollectionKey) || !fragmentCollectionKey.contains(" ");
        }
    }
}

