/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.renderer.react.internal.model.listener;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.react.internal.helper.FragmentEntryLinkJSModuleInitializerHelper;
import com.liferay.fragment.renderer.react.internal.util.FragmentEntryFragmentRendererReactUtil;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistryUpdate;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiServiceUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.io.Serializable;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={IdentifiableOSGiService.class, ModelListener.class})
public class FragmentEntryLinkModelListener
extends BaseModelListener<FragmentEntryLink>
implements IdentifiableOSGiService {
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryLinkModelListener.class);
    private static final MethodKey _onNotifyMethodKey = new MethodKey(FragmentEntryLinkModelListener.class, "_onNotify", new Class[]{MethodType.class, String.class, FragmentEntryLink.class, FragmentEntryLink.class});
    @Reference
    private ClusterExecutor _clusterExecutor;
    @Reference
    private FragmentEntryLinkJSModuleInitializerHelper _fragmentEntryLinkJSModuleInitializerHelper;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private NPMRegistry _npmRegistry;
    @Reference
    private NPMResolver _npmResolver;

    public String getOSGiServiceIdentifier() {
        return FragmentEntryLinkModelListener.class.getName();
    }

    public void onAfterCreate(FragmentEntryLink fragmentEntryLink) {
        if (!fragmentEntryLink.isTypeReact()) {
            return;
        }
        this._updateNPMRegistry(MethodType.ADD, null, fragmentEntryLink);
        this._notifyCluster(MethodType.ADD, null, fragmentEntryLink);
    }

    public void onAfterRemove(FragmentEntryLink fragmentEntryLink) {
        if (!fragmentEntryLink.isTypeReact()) {
            return;
        }
        this._fragmentEntryLinkJSModuleInitializerHelper.ensureInitialized();
        this._updateNPMRegistry(MethodType.REMOVE, fragmentEntryLink, null);
        this._notifyCluster(MethodType.REMOVE, fragmentEntryLink, null);
    }

    public void onAfterUpdate(FragmentEntryLink originalFragmentEntryLink, FragmentEntryLink fragmentEntryLink) {
        if (!fragmentEntryLink.isTypeReact()) {
            return;
        }
        this._fragmentEntryLinkJSModuleInitializerHelper.ensureInitialized();
        this._updateNPMRegistry(MethodType.UPDATE, originalFragmentEntryLink, fragmentEntryLink);
        this._notifyCluster(MethodType.UPDATE, originalFragmentEntryLink, fragmentEntryLink);
    }

    public void onBeforeCreate(FragmentEntryLink fragmentEntryLink) throws ModelListenerException {
        this._fragmentEntryLinkJSModuleInitializerHelper.ensureInitialized();
    }

    @Deactivate
    protected void deactivate() {
        JSPackage jsPackage = this._npmResolver.getJSPackage();
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(2, -1, -1, null);
        NPMRegistryUpdate npmRegistryUpdate = this._npmRegistry.update();
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            npmRegistryUpdate.unregisterJSModule(jsPackage.getJSModule(FragmentEntryFragmentRendererReactUtil.getModuleName(fragmentEntryLink)));
        }
        npmRegistryUpdate.finish();
    }

    private static void _onNotify(MethodType methodType, String osgiServiceIdentifier, FragmentEntryLink oldFragmentEntryLink, FragmentEntryLink newFragmentEntryLink) {
        FragmentEntryLinkModelListener fragmentEntryLinkModelListener = (FragmentEntryLinkModelListener)IdentifiableOSGiServiceUtil.getIdentifiableOSGiService((String)osgiServiceIdentifier);
        fragmentEntryLinkModelListener._updateNPMRegistry(methodType, oldFragmentEntryLink, newFragmentEntryLink);
    }

    private void _notifyCluster(MethodType methodType, FragmentEntryLink oldFragmentEntryLink, FragmentEntryLink newFragmentEntryLink) {
        if (!this._clusterExecutor.isEnabled()) {
            return;
        }
        try {
            MethodHandler methodHandler = new MethodHandler(_onNotifyMethodKey, new Object[]{methodType, this.getOSGiServiceIdentifier(), oldFragmentEntryLink, newFragmentEntryLink});
            ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)methodHandler, (boolean)true);
            clusterRequest.setFireAndForget(true);
            this._clusterExecutor.execute(clusterRequest);
        }
        catch (Throwable throwable) {
            _log.error(throwable);
        }
    }

    private void _updateNPMRegistry(MethodType methodType, FragmentEntryLink oldFragmentEntryLink, FragmentEntryLink newFragmentEntryLink) {
        NPMRegistryUpdate npmRegistryUpdate = this._npmRegistry.update();
        JSPackage jsPackage = this._npmResolver.getJSPackage();
        if (methodType == MethodType.REMOVE || methodType == MethodType.UPDATE) {
            npmRegistryUpdate.unregisterJSModule(jsPackage.getJSModule(FragmentEntryFragmentRendererReactUtil.getModuleName(oldFragmentEntryLink)));
        }
        if (methodType == MethodType.ADD || methodType == MethodType.UPDATE) {
            npmRegistryUpdate.registerJSModule(jsPackage, FragmentEntryFragmentRendererReactUtil.getModuleName(newFragmentEntryLink), FragmentEntryFragmentRendererReactUtil.getDependencies(), FragmentEntryFragmentRendererReactUtil.getJs(newFragmentEntryLink, jsPackage), null);
        }
        npmRegistryUpdate.finish();
    }

    private static enum MethodType {
        ADD,
        REMOVE,
        UPDATE;

    }
}

