/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.renderer.react.internal.renderer;

import com.liferay.fragment.contributor.FragmentCollectionContributorTracker;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.servlet.taglib.util.OutputData;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.react.renderer.ComponentDescriptor;
import com.liferay.portal.template.react.renderer.ReactRenderer;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentRenderer.class})
public class FragmentEntryFragmentRendererReact
implements FragmentRenderer {
    @Reference
    private FragmentCollectionContributorTracker _fragmentCollectionContributorTracker;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    private JSPackage _jsPackage;
    @Reference
    private NPMResolver _npmResolver;
    @Reference
    private ReactRenderer _reactRenderer;

    public String getCollectionKey() {
        return "";
    }

    public String getConfiguration(FragmentRendererContext fragmentRendererContext) {
        FragmentEntryLink fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink();
        return fragmentEntryLink.getConfiguration();
    }

    public String getKey() {
        return "FRAGMENT_ENTRY_FRAGMENT_RENDERER_KEY_REACT";
    }

    public boolean isSelectable(HttpServletRequest httpServletRequest) {
        return false;
    }

    public void render(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            PrintWriter printWriter = httpServletResponse.getWriter();
            FragmentEntryLink fragmentEntryLink = this._getFragmentEntryLink(fragmentRendererContext);
            JSONObject configurationJSONObject = JSONFactoryUtil.createJSONObject();
            if (Validator.isNotNull((String)fragmentEntryLink.getConfiguration())) {
                configurationJSONObject = this._fragmentEntryConfigurationParser.getConfigurationJSONObject(fragmentEntryLink.getConfiguration(), fragmentEntryLink.getEditableValues());
            }
            printWriter.write(this._renderFragmentEntry(fragmentEntryLink, HashMapBuilder.put((Object)"configuration", (Object)configurationJSONObject).build(), httpServletRequest));
        }
        catch (PortalException portalException) {
            throw new IOException(portalException);
        }
    }

    @Activate
    protected void activate() {
        this._jsPackage = this._npmResolver.getJSPackage();
    }

    private FragmentEntry _getContributedFragmentEntry(FragmentEntryLink fragmentEntryLink) {
        Map fragmentCollectionContributorEntries = this._fragmentCollectionContributorTracker.getFragmentEntries();
        return (FragmentEntry)fragmentCollectionContributorEntries.get(fragmentEntryLink.getRendererKey());
    }

    private FragmentEntryLink _getFragmentEntryLink(FragmentRendererContext fragmentRendererContext) {
        FragmentEntryLink fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink();
        FragmentEntry fragmentEntry = this._getContributedFragmentEntry(fragmentEntryLink);
        if (fragmentEntry != null) {
            fragmentEntryLink.setCss(fragmentEntry.getCss());
            fragmentEntryLink.setHtml(fragmentEntry.getHtml());
            fragmentEntryLink.setJs(fragmentEntry.getJs());
        }
        return fragmentEntryLink;
    }

    private String _renderFragmentEntry(FragmentEntryLink fragmentEntryLink, Map<String, Object> data, HttpServletRequest httpServletRequest) throws IOException {
        StringBundler sb = new StringBundler(9);
        sb.append("<div id=\"");
        StringBundler fragmentIdSB = new StringBundler(4);
        fragmentIdSB.append("fragment-");
        fragmentIdSB.append(fragmentEntryLink.getFragmentEntryId());
        fragmentIdSB.append("-");
        fragmentIdSB.append(fragmentEntryLink.getNamespace());
        sb.append(fragmentIdSB.toString());
        sb.append("\" >");
        sb.append(fragmentEntryLink.getHtml());
        CharArrayWriter writer = new CharArrayWriter();
        this._reactRenderer.renderReact(new ComponentDescriptor(ModuleNameUtil.getModuleResolvedId((JSPackage)this._jsPackage, (String)("fragmentEntryLink/" + fragmentEntryLink.getFragmentEntryLinkId())), "fragment" + fragmentEntryLink.getFragmentEntryLinkId(), Collections.emptyList(), true), data, httpServletRequest, (Writer)writer);
        sb.append(((Object)writer).toString());
        sb.append("</div>");
        if (Validator.isNotNull((String)fragmentEntryLink.getCss())) {
            String outputKey = fragmentEntryLink.getFragmentEntryId() + "_CSS";
            OutputData outputData = (OutputData)httpServletRequest.getAttribute("LIFERAY_SHARED_OUTPUT_DATA");
            boolean cssLoaded = false;
            if (outputData != null) {
                Set outputKeys = outputData.getOutputKeys();
                cssLoaded = outputKeys.contains(outputKey);
                StringBundler cssSB = outputData.getDataSB(outputKey, "");
                if (cssSB != null) {
                    cssLoaded = Objects.equals(cssSB.toString(), fragmentEntryLink.getCss());
                }
            } else {
                outputData = new OutputData();
            }
            if (!cssLoaded) {
                sb.append("<style>");
                sb.append(fragmentEntryLink.getCss());
                sb.append("</style>");
                outputData.addOutputKey(outputKey);
                outputData.setDataSB(outputKey, "", new StringBundler(fragmentEntryLink.getCss()));
                httpServletRequest.setAttribute("LIFERAY_SHARED_OUTPUT_DATA", (Object)outputData);
            }
        }
        return sb.toString();
    }
}

