/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.exportimport.content.processor;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.xml.Element;
import java.util.Iterator;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.processor.type=FragmentEntryLinkEditableValues"}, service={ExportImportContentProcessor.class})
public class EditableValuesLayoutMappingExportImportContentProcessor
implements ExportImportContentProcessor<JSONObject> {
    private static final String _KEY_EDITABLE_FRAGMENT_ENTRY_PROCESSOR = "com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor";
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public JSONObject replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, JSONObject editableValuesJSONObject, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        JSONObject editableProcessorJSONObject = editableValuesJSONObject.getJSONObject(_KEY_EDITABLE_FRAGMENT_ENTRY_PROCESSOR);
        Iterator editableKeysIterator = editableProcessorJSONObject.keys();
        while (editableKeysIterator.hasNext()) {
            String editableKey = (String)editableKeysIterator.next();
            JSONObject editableJSONObject = editableProcessorJSONObject.getJSONObject(editableKey);
            JSONObject configJSONObject = editableJSONObject.getJSONObject("config");
            if (configJSONObject == null || !configJSONObject.has("layout")) continue;
            this._exportLayoutReferences(portletDataContext, stagedModel, configJSONObject.getJSONObject("layout"), exportReferencedContent);
        }
        return editableValuesJSONObject;
    }

    public JSONObject replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, JSONObject editableValuesJSONObject) {
        JSONObject editableProcessorJSONObject = editableValuesJSONObject.getJSONObject(_KEY_EDITABLE_FRAGMENT_ENTRY_PROCESSOR);
        Iterator editableKeysIterator = editableProcessorJSONObject.keys();
        while (editableKeysIterator.hasNext()) {
            String editableKey = (String)editableKeysIterator.next();
            JSONObject editableJSONObject = editableProcessorJSONObject.getJSONObject(editableKey);
            JSONObject configJSONObject = editableJSONObject.getJSONObject("config");
            if (configJSONObject == null || !configJSONObject.has("layout")) continue;
            this._replaceImportLayoutReferences(configJSONObject.getJSONObject("layout"), portletDataContext);
        }
        return editableValuesJSONObject;
    }

    public void validateContentReferences(long groupId, JSONObject jsonObject) {
    }

    private void _exportLayoutReferences(PortletDataContext portletDataContext, StagedModel referrerStagedModel, JSONObject layoutJSONObject, boolean exportReferencedContent) throws Exception {
        if (layoutJSONObject.length() == 0) {
            return;
        }
        Layout layout = this._layoutLocalService.fetchLayout(layoutJSONObject.getLong("groupId"), layoutJSONObject.getBoolean("privateLayout"), layoutJSONObject.getLong("layoutId"));
        if (layout == null) {
            return;
        }
        layoutJSONObject.put("plid", layout.getPlid());
        if (exportReferencedContent) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)referrerStagedModel, (StagedModel)layout, (String)"dependency");
        } else {
            Element entityElement = portletDataContext.getExportDataElement((ClassedModel)referrerStagedModel);
            portletDataContext.addReferenceElement((ClassedModel)referrerStagedModel, entityElement, (ClassedModel)layout, "dependency", true);
        }
    }

    private void _replaceImportLayoutReferences(JSONObject layoutJSONObject, PortletDataContext portletDataContext) {
        if (layoutJSONObject.length() == 0) {
            return;
        }
        long plid = GetterUtil.getLong((Object)layoutJSONObject.remove("plid"));
        Map layoutNewPrimaryKeys = portletDataContext.getNewPrimaryKeysMap(Layout.class.getName());
        Layout layout = this._layoutLocalService.fetchLayout(layoutNewPrimaryKeys.getOrDefault(plid, 0L).longValue());
        if (layout == null) {
            return;
        }
        layoutJSONObject.put("groupId", layout.getGroupId()).put("layoutId", layout.getLayoutId()).put("layoutUuid", layout.getUuid());
    }
}

