/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.exportimport.data.handler;

import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.io.Serializable;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class FragmentEntryLinkStagedModelDataHandler
extends BaseStagedModelDataHandler<FragmentEntryLink> {
    public static final String[] CLASS_NAMES = new String[]{FragmentEntryLink.class.getName()};
    @Reference(target="(content.processor.type=DLReferences)")
    private ExportImportContentProcessor<String> _dlReferencesExportImportContentProcessor;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.fragment.model.FragmentEntryLink)")
    private volatile ExportImportContentProcessor<String> _fragmentEntryLinkExportImportContentProcessor;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference(target="(model.class.name=com.liferay.fragment.model.FragmentEntryLink)", unbind="-")
    private StagedModelRepository<FragmentEntryLink> _stagedModelRepository;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, FragmentEntryLink fragmentEntryLink) throws Exception {
        FragmentEntryLink originalFragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(fragmentEntryLink.getOriginalFragmentEntryLinkId());
        if (originalFragmentEntryLink != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fragmentEntryLink, (StagedModel)originalFragmentEntryLink, (String)"parent");
        }
        Element fragmentEntryLinkElement = portletDataContext.getExportDataElement((ClassedModel)fragmentEntryLink);
        if (!MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PORTLET_DATA") && MergeLayoutPrototypesThreadLocal.isInProgress()) {
            portletDataContext.addClassedModel(fragmentEntryLinkElement, ExportImportPathUtil.getModelPath((StagedModel)fragmentEntryLink), (ClassedModel)fragmentEntryLink);
            return;
        }
        String html = fragmentEntryLink.getHtml();
        if (Validator.isNotNull((String)html)) {
            html = (String)((Object)this._dlReferencesExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)fragmentEntryLink, (Serializable)((Object)html), true, false));
        }
        fragmentEntryLink.setHtml(html);
        String editableValues = fragmentEntryLink.getEditableValues();
        if (Validator.isNotNull((String)editableValues)) {
            editableValues = (String)((Object)this._fragmentEntryLinkExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)fragmentEntryLink, (Serializable)((Object)editableValues), true, false));
        }
        fragmentEntryLink.setEditableValues(editableValues);
        portletDataContext.addClassedModel(fragmentEntryLinkElement, ExportImportPathUtil.getModelPath((StagedModel)fragmentEntryLink), (ClassedModel)fragmentEntryLink);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long fragmentEntryLinkId) {
        FragmentEntryLink existingFragmentEntryLink = (FragmentEntryLink)this.fetchMissingReference(uuid, groupId);
        if (existingFragmentEntryLink == null) {
            return;
        }
        Map fragmentEntryLinkIds = portletDataContext.getNewPrimaryKeysMap(FragmentEntryLink.class);
        fragmentEntryLinkIds.put(fragmentEntryLinkId, existingFragmentEntryLink.getFragmentEntryLinkId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, FragmentEntryLink fragmentEntryLink) throws Exception {
        FragmentEntry fragmentEntry;
        Map originalFragmentEntryLinkIds = portletDataContext.getNewPrimaryKeysMap(FragmentEntryLink.class);
        long originalFragmentEntryLinkId = MapUtil.getLong((Map)originalFragmentEntryLinkIds, (long)fragmentEntryLink.getOriginalFragmentEntryLinkId(), (long)fragmentEntryLink.getOriginalFragmentEntryLinkId());
        Map fragmentEntryIds = portletDataContext.getNewPrimaryKeysMap(FragmentEntry.class);
        long fragmentEntryId = MapUtil.getLong((Map)fragmentEntryIds, (long)fragmentEntryLink.getFragmentEntryId());
        if (fragmentEntryId == 0L && fragmentEntryLink.getFragmentEntryId() > 0L && (fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(fragmentEntryLink.getFragmentEntryId())) != null) {
            FragmentEntry targetFragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntryByUuidAndGroupId(fragmentEntry.getUuid(), portletDataContext.getGroupId());
            fragmentEntryId = targetFragmentEntry != null ? targetFragmentEntry.getFragmentEntryId() : fragmentEntryLink.getFragmentEntryId();
        }
        Map referenceClassPKs = portletDataContext.getNewPrimaryKeysMap(fragmentEntryLink.getClassName());
        long referenceClassPK = MapUtil.getLong((Map)referenceClassPKs, (long)fragmentEntryLink.getClassPK(), (long)fragmentEntryLink.getClassPK());
        FragmentEntryLink importedFragmentEntryLink = (FragmentEntryLink)fragmentEntryLink.clone();
        importedFragmentEntryLink.setGroupId(portletDataContext.getScopeGroupId());
        importedFragmentEntryLink.setOriginalFragmentEntryLinkId(originalFragmentEntryLinkId);
        importedFragmentEntryLink.setFragmentEntryId(fragmentEntryId);
        importedFragmentEntryLink.setClassPK(referenceClassPK);
        importedFragmentEntryLink.setPlid(referenceClassPK);
        String html = (String)((Object)this._dlReferencesExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)fragmentEntryLink, (Serializable)((Object)fragmentEntryLink.getHtml())));
        importedFragmentEntryLink.setHtml(html);
        String editableValues = (String)((Object)this._fragmentEntryLinkExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)fragmentEntryLink, (Serializable)((Object)fragmentEntryLink.getEditableValues())));
        importedFragmentEntryLink.setEditableValues(editableValues);
        FragmentEntryLink existingFragmentEntryLink = (FragmentEntryLink)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(fragmentEntryLink.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFragmentEntryLink == null || !portletDataContext.isDataStrategyMirror()) {
            importedFragmentEntryLink = (FragmentEntryLink)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedFragmentEntryLink);
        } else {
            importedFragmentEntryLink.setMvccVersion(existingFragmentEntryLink.getMvccVersion());
            importedFragmentEntryLink.setFragmentEntryLinkId(existingFragmentEntryLink.getFragmentEntryLinkId());
            importedFragmentEntryLink = (FragmentEntryLink)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedFragmentEntryLink);
        }
        portletDataContext.importClassedModel((ClassedModel)fragmentEntryLink, (ClassedModel)importedFragmentEntryLink);
    }

    protected StagedModelRepository<FragmentEntryLink> getStagedModelRepository() {
        return this._stagedModelRepository;
    }
}

