/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.exportimport.staged.model.repository;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryHelper;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.service.FragmentCollectionLocalService;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.fragment.model.FragmentCollection"}, service={StagedModelRepository.class})
public class FragmentCollectionStagedModelRepository
implements StagedModelRepository<FragmentCollection> {
    @Reference
    private FragmentCollectionLocalService _fragmentCollectionLocalService;
    @Reference
    private StagedModelRepositoryHelper _stagedModelRepositoryHelper;

    public FragmentCollection addStagedModel(PortletDataContext portletDataContext, FragmentCollection fragmentCollection) throws PortalException {
        long userId = portletDataContext.getUserId(fragmentCollection.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)fragmentCollection);
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setUuid(fragmentCollection.getUuid());
        }
        return this._fragmentCollectionLocalService.addFragmentCollection(userId, fragmentCollection.getGroupId(), fragmentCollection.getName(), fragmentCollection.getDescription(), serviceContext);
    }

    public void deleteStagedModel(FragmentCollection fragmentCollection) throws PortalException {
        this._fragmentCollectionLocalService.deleteFragmentCollection(fragmentCollection);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        FragmentCollection fragmentCollection = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (fragmentCollection != null) {
            this.deleteStagedModel(fragmentCollection);
        }
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
    }

    public FragmentCollection fetchMissingReference(String uuid, long groupId) {
        return (FragmentCollection)this._stagedModelRepositoryHelper.fetchMissingReference(uuid, groupId, (StagedModelRepository)this);
    }

    public FragmentCollection fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._fragmentCollectionLocalService.fetchFragmentCollectionByUuidAndGroupId(uuid, groupId);
    }

    public List<FragmentCollection> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._fragmentCollectionLocalService.getFragmentCollectionsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return this._fragmentCollectionLocalService.getExportActionableDynamicQuery(portletDataContext);
    }

    public FragmentCollection getStagedModel(long id) throws PortalException {
        return this._fragmentCollectionLocalService.getFragmentCollection(id);
    }

    public FragmentCollection saveStagedModel(FragmentCollection fragmentCollection) throws PortalException {
        return this._fragmentCollectionLocalService.updateFragmentCollection(fragmentCollection);
    }

    public FragmentCollection updateStagedModel(PortletDataContext portletDataContext, FragmentCollection fragmentCollection) throws PortalException {
        return this._fragmentCollectionLocalService.updateFragmentCollection(fragmentCollection.getFragmentCollectionId(), fragmentCollection.getName(), fragmentCollection.getDescription());
    }
}

