/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.exportimport.staged.model.repository;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryHelper;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.fragment.model.FragmentEntry"}, service={StagedModelRepository.class})
public class FragmentEntryStagedModelRepository
implements StagedModelRepository<FragmentEntry> {
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private StagedModelRepositoryHelper _stagedModelRepositoryHelper;

    public FragmentEntry addStagedModel(PortletDataContext portletDataContext, FragmentEntry fragmentEntry) throws PortalException {
        long userId = portletDataContext.getUserId(fragmentEntry.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)fragmentEntry);
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setUuid(fragmentEntry.getUuid());
        }
        return this._fragmentEntryLocalService.addFragmentEntry(userId, fragmentEntry.getGroupId(), fragmentEntry.getFragmentCollectionId(), fragmentEntry.getFragmentEntryKey(), fragmentEntry.getName(), fragmentEntry.getCss(), fragmentEntry.getHtml(), fragmentEntry.getJs(), fragmentEntry.getConfiguration(), fragmentEntry.getPreviewFileEntryId(), fragmentEntry.getType(), fragmentEntry.getStatus(), serviceContext);
    }

    public void deleteStagedModel(FragmentEntry fragmentEntry) throws PortalException {
        this._fragmentEntryLocalService.deleteFragmentEntry(fragmentEntry);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        FragmentEntry fragmentEntry = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (fragmentEntry != null) {
            this.deleteStagedModel(fragmentEntry);
        }
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
    }

    public FragmentEntry fetchMissingReference(String uuid, long groupId) {
        return (FragmentEntry)this._stagedModelRepositoryHelper.fetchMissingReference(uuid, groupId, (StagedModelRepository)this);
    }

    public FragmentEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._fragmentEntryLocalService.fetchFragmentEntryByUuidAndGroupId(uuid, groupId);
    }

    public List<FragmentEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._fragmentEntryLocalService.getFragmentEntriesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return this._fragmentEntryLocalService.getExportActionableDynamicQuery(portletDataContext);
    }

    public FragmentEntry getStagedModel(long id) throws PortalException {
        return this._fragmentEntryLocalService.getFragmentEntry(id);
    }

    public FragmentEntry saveStagedModel(FragmentEntry fragmentEntry) throws PortalException {
        return this._fragmentEntryLocalService.updateFragmentEntry(fragmentEntry);
    }

    public FragmentEntry updateStagedModel(PortletDataContext portletDataContext, FragmentEntry fragmentEntry) throws PortalException {
        return this._fragmentEntryLocalService.updateFragmentEntry(portletDataContext.getUserId(fragmentEntry.getUserUuid()), fragmentEntry.getFragmentEntryId(), fragmentEntry.getName(), fragmentEntry.getCss(), fragmentEntry.getHtml(), fragmentEntry.getJs(), fragmentEntry.getConfiguration(), fragmentEntry.getStatus());
    }
}

