/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.upgrade.v1_1_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

public class PortletPreferencesUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesUpgradeProcess.class);
    private static final Map<Long, Long> _companyControlPanelPlids = new HashMap<Long, Long>();
    private static final Map<Long, Long> _groupControlPanelPlids = new HashMap<Long, Long>();
    private final LayoutLocalService _layoutLocalService;

    public PortletPreferencesUpgradeProcess(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    protected void deleteGroupControlPanelLayouts() throws PortalException {
        for (Long groupControlPanelLayoutPlid : _groupControlPanelPlids.values()) {
            this._layoutLocalService.deleteLayout(groupControlPanelLayoutPlid.longValue());
        }
    }

    protected void doUpgrade() throws Exception {
        this._computeControlPanelPlids();
        if (_groupControlPanelPlids.isEmpty()) {
            return;
        }
        this.upgradePortletPreferences();
        this.deleteGroupControlPanelLayouts();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void upgradePortletPreferences() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select groupId, companyId, classPK, namespace from FragmentEntryLink");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("delete from PortletPreferences where portletPreferencesId = ?"));
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update PortletPreferences set plid = ? where portletPreferencesId = ?"));
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long groupId = resultSet.getLong("groupId");
                long companyId = resultSet.getLong("companyId");
                long classPK = resultSet.getLong("classPK");
                String namespace = resultSet.getString("namespace");
                try {
                    Map<Long, Long> portletPreferencesMap = this._getPortletPreferencesMap(companyId, groupId, namespace);
                    if (portletPreferencesMap.isEmpty()) continue;
                    Long companyPortletPreferencesId = null;
                    Long groupPortletPreferencesId = null;
                    Long layoutPortletPreferencesId = null;
                    long companyControlPanelPlid = _companyControlPanelPlids.get(companyId);
                    long groupControlPanelPlid = _groupControlPanelPlids.get(groupId);
                    long layoutPlid = classPK;
                    for (Map.Entry<Long, Long> entry : portletPreferencesMap.entrySet()) {
                        Long portletPreferencesId = entry.getKey();
                        Long portletPreferencesPlid = entry.getValue();
                        if (portletPreferencesPlid == companyControlPanelPlid) {
                            companyPortletPreferencesId = portletPreferencesId;
                            continue;
                        }
                        if (portletPreferencesPlid == groupControlPanelPlid) {
                            groupPortletPreferencesId = portletPreferencesId;
                            continue;
                        }
                        if (portletPreferencesPlid != layoutPlid) continue;
                        layoutPortletPreferencesId = portletPreferencesId;
                    }
                    if (groupPortletPreferencesId != null) {
                        if (companyPortletPreferencesId != null) {
                            preparedStatement2.setLong(1, companyPortletPreferencesId);
                            preparedStatement2.addBatch();
                        }
                        if (layoutPortletPreferencesId != null) {
                            preparedStatement2.setLong(1, layoutPortletPreferencesId);
                            preparedStatement2.addBatch();
                        }
                        preparedStatement3.setLong(1, classPK);
                        preparedStatement3.setLong(2, groupPortletPreferencesId);
                        preparedStatement3.addBatch();
                        continue;
                    }
                    if (companyPortletPreferencesId == null) continue;
                    if (layoutPortletPreferencesId != null) {
                        preparedStatement2.setLong(1, layoutPortletPreferencesId);
                        preparedStatement2.addBatch();
                    }
                    preparedStatement3.setLong(1, classPK);
                    preparedStatement3.setLong(2, companyPortletPreferencesId);
                    preparedStatement3.addBatch();
                }
                catch (Exception exception) {
                    _log.error((Object)exception, (Throwable)exception);
                }
            }
            preparedStatement2.executeBatch();
            preparedStatement3.executeBatch();
            return;
        }
    }

    private void _computeControlPanelPlids() throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("select Layout.plid, Group_.groupKey from Layout inner ");
        sb.append("join Group_ on Layout.groupId = Group_.groupId where ");
        sb.append("Layout.type_ = '");
        sb.append("control_panel");
        sb.append("'");
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sb.toString());
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String groupKey = resultSet.getString("groupKey");
                long plid = resultSet.getLong("plid");
                Layout layout = this._layoutLocalService.getLayout(plid);
                if (groupKey.equals("Control Panel")) {
                    _companyControlPanelPlids.put(layout.getCompanyId(), plid);
                    continue;
                }
                _groupControlPanelPlids.put(layout.getGroupId(), plid);
            }
        }
    }

    private Map<Long, Long> _getPortletPreferencesMap(long companyId, long groupId, String namespace) throws Exception {
        HashMap<Long, Long> portletPreferencesMap = new HashMap<Long, Long>();
        long companyControlPanelPlid = _companyControlPanelPlids.get(companyId);
        StringBundler sb = new StringBundler(11);
        sb.append("select PortletPreferences.portletPreferencesId, ");
        sb.append("PortletPreferences.plid from PortletPreferences inner ");
        sb.append("join Layout on PortletPreferences.plid = Layout.plid ");
        sb.append("where PortletPreferences.portletId like ");
        sb.append("CONCAT('%_INSTANCE_', '");
        sb.append(namespace);
        sb.append("') and (Layout.groupId = ");
        sb.append(groupId);
        sb.append(" or PortletPreferences.plid = ");
        sb.append(companyControlPanelPlid);
        sb.append(")");
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sb.toString());
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long portletPreferencesId = resultSet.getLong("portletPreferencesId");
                long portletPreferencesPlid = resultSet.getLong("plid");
                portletPreferencesMap.put(portletPreferencesId, portletPreferencesPlid);
            }
        }
        return portletPreferencesMap;
    }
}

