/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.upgrade.v2_5_0;

import com.liferay.fragment.internal.upgrade.v2_5_0.util.FragmentEntryLinkTable;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;

public class FragmentEntryLinkUpgradeProcess
extends UpgradeProcess {
    private static final Map<String, String> _contributedFragmentKeys = HashMapBuilder.put((Object)"BASIC_SECTION-banner", (Object)"FEATURED_CONTENT-banner").put((Object)"BASIC_SECTION-banner-center", (Object)"FEATURED_CONTENT-banner-center").put((Object)"BASIC_SECTION-banner-cover", (Object)"FEATURED_CONTENT-banner-cover").put((Object)"BASIC_SECTION-banner-cover-center", (Object)"FEATURED_CONTENT-banner-cover-center").put((Object)"BASIC_SECTION-features", (Object)"FEATURED_CONTENT-features").put((Object)"BASIC_SECTION-footer-nav-dark", (Object)"FOOTERS-footer-nav-dark").put((Object)"BASIC_SECTION-footer-nav-light", (Object)"FOOTERS-footer-nav-dark").put((Object)"BASIC_SECTION-header-dark", (Object)"NAVIGATION_BARS-header-dark").put((Object)"BASIC_SECTION-header-light", (Object)"NAVIGATION_BARS-header-light").put((Object)"BASIC_SECTION-highlights", (Object)"FEATURED_CONTENT-highlights").put((Object)"BASIC_SECTION-highlights-circle", (Object)"FEATURED_CONTENT-highlights-circle").build();

    protected void doUpgrade() throws Exception {
        this.upgradeRendererKey();
        this.upgratePlid();
    }

    protected void upgradeRendererKey() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select fragmentEntryLinkId, rendererKey from FragmentEntryLink where rendererKey like 'BASIC_SECTION%'");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update FragmentEntryLink set rendererKey = ? where fragmentEntryLinkId = ?"));){
            while (resultSet.next()) {
                long fragmentEntryLinkId = resultSet.getLong("fragmentEntryLinkId");
                String rendererKey = resultSet.getString("rendererKey");
                preparedStatement2.setString(1, _contributedFragmentKeys.getOrDefault(rendererKey, rendererKey));
                preparedStatement2.setLong(2, fragmentEntryLinkId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    protected void upgratePlid() throws Exception {
        if (!this.hasColumn("FragmentEntryLink", "plid")) {
            this.alter(FragmentEntryLinkTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "plid", "LONG")});
        }
        this.runSQL("update FragmentEntryLink set plid = classPK where classNameId = " + PortalUtil.getClassNameId((String)Layout.class.getName()));
    }
}

